/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConfigurationProfileRequest extends AppConfigRequest implements
        ToCopyableBuilder<CreateConfigurationProfileRequest.Builder, CreateConfigurationProfileRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(CreateConfigurationProfileRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateConfigurationProfileRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateConfigurationProfileRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationUri").getter(getter(CreateConfigurationProfileRequest::locationUri))
            .setter(setter(Builder::locationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()).build();

    private static final SdkField<String> RETRIEVAL_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RetrievalRoleArn").getter(getter(CreateConfigurationProfileRequest::retrievalRoleArn))
            .setter(setter(Builder::retrievalRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrievalRoleArn").build()).build();

    private static final SdkField<List<Validator>> VALIDATORS_FIELD = SdkField
            .<List<Validator>> builder(MarshallingType.LIST)
            .memberName("Validators")
            .getter(getter(CreateConfigurationProfileRequest::validators))
            .setter(setter(Builder::validators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Validator> builder(MarshallingType.SDK_POJO)
                                            .constructor(Validator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateConfigurationProfileRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CreateConfigurationProfileRequest::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(APPLICATION_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, LOCATION_URI_FIELD, RETRIEVAL_ROLE_ARN_FIELD,
                    VALIDATORS_FIELD, TAGS_FIELD, TYPE_FIELD));

    private final String applicationId;

    private final String name;

    private final String description;

    private final String locationUri;

    private final String retrievalRoleArn;

    private final List<Validator> validators;

    private final Map<String, String> tags;

    private final String type;

    private CreateConfigurationProfileRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.name = builder.name;
        this.description = builder.description;
        this.locationUri = builder.locationUri;
        this.retrievalRoleArn = builder.retrievalRoleArn;
        this.validators = builder.validators;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    /**
     * <p>
     * The application ID.
     * </p>
     * 
     * @return The application ID.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * A name for the configuration profile.
     * </p>
     * 
     * @return A name for the configuration profile.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the configuration profile.
     * </p>
     * 
     * @return A description of the configuration profile.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A URI to locate the configuration. You can specify the AppConfig hosted configuration store, Systems Manager
     * (SSM) document, an SSM Parameter Store parameter, or an Amazon S3 object. For the hosted configuration store and
     * for feature flags, specify <code>hosted</code>. For an SSM document, specify either the document name in the
     * format <code>ssm-document://&lt;Document_name&gt;</code> or the Amazon Resource Name (ARN). For a parameter,
     * specify either the parameter name in the format <code>ssm-parameter://&lt;Parameter_name&gt;</code> or the ARN.
     * For an Amazon S3 object, specify the URI in the following format:
     * <code>s3://&lt;bucket&gt;/&lt;objectKey&gt; </code>. Here is an example:
     * <code>s3://my-bucket/my-app/us-east-1/my-config.json</code>
     * </p>
     * 
     * @return A URI to locate the configuration. You can specify the AppConfig hosted configuration store, Systems
     *         Manager (SSM) document, an SSM Parameter Store parameter, or an Amazon S3 object. For the hosted
     *         configuration store and for feature flags, specify <code>hosted</code>. For an SSM document, specify
     *         either the document name in the format <code>ssm-document://&lt;Document_name&gt;</code> or the Amazon
     *         Resource Name (ARN). For a parameter, specify either the parameter name in the format
     *         <code>ssm-parameter://&lt;Parameter_name&gt;</code> or the ARN. For an Amazon S3 object, specify the URI
     *         in the following format: <code>s3://&lt;bucket&gt;/&lt;objectKey&gt; </code>. Here is an example:
     *         <code>s3://my-bucket/my-app/us-east-1/my-config.json</code>
     */
    public final String locationUri() {
        return locationUri;
    }

    /**
     * <p>
     * The ARN of an IAM role with permission to access the configuration at the specified <code>LocationUri</code>.
     * </p>
     * <important>
     * <p>
     * A retrieval role ARN is not required for configurations stored in the AppConfig hosted configuration store. It is
     * required for all other sources that store your configuration.
     * </p>
     * </important>
     * 
     * @return The ARN of an IAM role with permission to access the configuration at the specified
     *         <code>LocationUri</code>.</p> <important>
     *         <p>
     *         A retrieval role ARN is not required for configurations stored in the AppConfig hosted configuration
     *         store. It is required for all other sources that store your configuration.
     *         </p>
     */
    public final String retrievalRoleArn() {
        return retrievalRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Validators property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValidators() {
        return validators != null && !(validators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of methods for validating the configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValidators} method.
     * </p>
     * 
     * @return A list of methods for validating the configuration.
     */
    public final List<Validator> validators() {
        return validators;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata to assign to the configuration profile. Tags help organize and categorize your AppConfig resources. Each
     * tag consists of a key and an optional value, both of which you define.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata to assign to the configuration profile. Tags help organize and categorize your AppConfig
     *         resources. Each tag consists of a key and an optional value, both of which you define.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The type of configurations contained in the profile. AppConfig supports <code>feature flags</code> and
     * <code>freeform</code> configurations. We recommend you create feature flag configurations to enable or disable
     * new features and freeform configurations to distribute configurations to an application. When calling this API,
     * enter one of the following values for <code>Type</code>:
     * </p>
     * <p>
     * <code>AWS.AppConfig.FeatureFlags</code>
     * </p>
     * <p>
     * <code>AWS.Freeform</code>
     * </p>
     * 
     * @return The type of configurations contained in the profile. AppConfig supports <code>feature flags</code> and
     *         <code>freeform</code> configurations. We recommend you create feature flag configurations to enable or
     *         disable new features and freeform configurations to distribute configurations to an application. When
     *         calling this API, enter one of the following values for <code>Type</code>:</p>
     *         <p>
     *         <code>AWS.AppConfig.FeatureFlags</code>
     *         </p>
     *         <p>
     *         <code>AWS.Freeform</code>
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(retrievalRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasValidators() ? validators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationProfileRequest)) {
            return false;
        }
        CreateConfigurationProfileRequest other = (CreateConfigurationProfileRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(locationUri(), other.locationUri())
                && Objects.equals(retrievalRoleArn(), other.retrievalRoleArn()) && hasValidators() == other.hasValidators()
                && Objects.equals(validators(), other.validators()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConfigurationProfileRequest").add("ApplicationId", applicationId()).add("Name", name())
                .add("Description", description()).add("LocationUri", locationUri()).add("RetrievalRoleArn", retrievalRoleArn())
                .add("Validators", hasValidators() ? validators() : null).add("Tags", hasTags() ? tags() : null)
                .add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LocationUri":
            return Optional.ofNullable(clazz.cast(locationUri()));
        case "RetrievalRoleArn":
            return Optional.ofNullable(clazz.cast(retrievalRoleArn()));
        case "Validators":
            return Optional.ofNullable(clazz.cast(validators()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConfigurationProfileRequest, T> g) {
        return obj -> g.apply((CreateConfigurationProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateConfigurationProfileRequest> {
        /**
         * <p>
         * The application ID.
         * </p>
         * 
         * @param applicationId
         *        The application ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * A name for the configuration profile.
         * </p>
         * 
         * @param name
         *        A name for the configuration profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the configuration profile.
         * </p>
         * 
         * @param description
         *        A description of the configuration profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A URI to locate the configuration. You can specify the AppConfig hosted configuration store, Systems Manager
         * (SSM) document, an SSM Parameter Store parameter, or an Amazon S3 object. For the hosted configuration store
         * and for feature flags, specify <code>hosted</code>. For an SSM document, specify either the document name in
         * the format <code>ssm-document://&lt;Document_name&gt;</code> or the Amazon Resource Name (ARN). For a
         * parameter, specify either the parameter name in the format
         * <code>ssm-parameter://&lt;Parameter_name&gt;</code> or the ARN. For an Amazon S3 object, specify the URI in
         * the following format: <code>s3://&lt;bucket&gt;/&lt;objectKey&gt; </code>. Here is an example:
         * <code>s3://my-bucket/my-app/us-east-1/my-config.json</code>
         * </p>
         * 
         * @param locationUri
         *        A URI to locate the configuration. You can specify the AppConfig hosted configuration store, Systems
         *        Manager (SSM) document, an SSM Parameter Store parameter, or an Amazon S3 object. For the hosted
         *        configuration store and for feature flags, specify <code>hosted</code>. For an SSM document, specify
         *        either the document name in the format <code>ssm-document://&lt;Document_name&gt;</code> or the Amazon
         *        Resource Name (ARN). For a parameter, specify either the parameter name in the format
         *        <code>ssm-parameter://&lt;Parameter_name&gt;</code> or the ARN. For an Amazon S3 object, specify the
         *        URI in the following format: <code>s3://&lt;bucket&gt;/&lt;objectKey&gt; </code>. Here is an example:
         *        <code>s3://my-bucket/my-app/us-east-1/my-config.json</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationUri(String locationUri);

        /**
         * <p>
         * The ARN of an IAM role with permission to access the configuration at the specified <code>LocationUri</code>.
         * </p>
         * <important>
         * <p>
         * A retrieval role ARN is not required for configurations stored in the AppConfig hosted configuration store.
         * It is required for all other sources that store your configuration.
         * </p>
         * </important>
         * 
         * @param retrievalRoleArn
         *        The ARN of an IAM role with permission to access the configuration at the specified
         *        <code>LocationUri</code>.</p> <important>
         *        <p>
         *        A retrieval role ARN is not required for configurations stored in the AppConfig hosted configuration
         *        store. It is required for all other sources that store your configuration.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrievalRoleArn(String retrievalRoleArn);

        /**
         * <p>
         * A list of methods for validating the configuration.
         * </p>
         * 
         * @param validators
         *        A list of methods for validating the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validators(Collection<Validator> validators);

        /**
         * <p>
         * A list of methods for validating the configuration.
         * </p>
         * 
         * @param validators
         *        A list of methods for validating the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validators(Validator... validators);

        /**
         * <p>
         * A list of methods for validating the configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Validator>.Builder} avoiding the
         * need to create one manually via {@link List<Validator>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Validator>.Builder#build()} is called immediately and its
         * result is passed to {@link #validators(List<Validator>)}.
         * 
         * @param validators
         *        a consumer that will call methods on {@link List<Validator>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validators(List<Validator>)
         */
        Builder validators(Consumer<Validator.Builder>... validators);

        /**
         * <p>
         * Metadata to assign to the configuration profile. Tags help organize and categorize your AppConfig resources.
         * Each tag consists of a key and an optional value, both of which you define.
         * </p>
         * 
         * @param tags
         *        Metadata to assign to the configuration profile. Tags help organize and categorize your AppConfig
         *        resources. Each tag consists of a key and an optional value, both of which you define.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The type of configurations contained in the profile. AppConfig supports <code>feature flags</code> and
         * <code>freeform</code> configurations. We recommend you create feature flag configurations to enable or
         * disable new features and freeform configurations to distribute configurations to an application. When calling
         * this API, enter one of the following values for <code>Type</code>:
         * </p>
         * <p>
         * <code>AWS.AppConfig.FeatureFlags</code>
         * </p>
         * <p>
         * <code>AWS.Freeform</code>
         * </p>
         * 
         * @param type
         *        The type of configurations contained in the profile. AppConfig supports <code>feature flags</code> and
         *        <code>freeform</code> configurations. We recommend you create feature flag configurations to enable or
         *        disable new features and freeform configurations to distribute configurations to an application. When
         *        calling this API, enter one of the following values for <code>Type</code>:</p>
         *        <p>
         *        <code>AWS.AppConfig.FeatureFlags</code>
         *        </p>
         *        <p>
         *        <code>AWS.Freeform</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppConfigRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String name;

        private String description;

        private String locationUri;

        private String retrievalRoleArn;

        private List<Validator> validators = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationProfileRequest model) {
            super(model);
            applicationId(model.applicationId);
            name(model.name);
            description(model.description);
            locationUri(model.locationUri);
            retrievalRoleArn(model.retrievalRoleArn);
            validators(model.validators);
            tags(model.tags);
            type(model.type);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLocationUri() {
            return locationUri;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final String getRetrievalRoleArn() {
            return retrievalRoleArn;
        }

        public final void setRetrievalRoleArn(String retrievalRoleArn) {
            this.retrievalRoleArn = retrievalRoleArn;
        }

        @Override
        public final Builder retrievalRoleArn(String retrievalRoleArn) {
            this.retrievalRoleArn = retrievalRoleArn;
            return this;
        }

        public final List<Validator.Builder> getValidators() {
            List<Validator.Builder> result = ValidatorListCopier.copyToBuilder(this.validators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidators(Collection<Validator.BuilderImpl> validators) {
            this.validators = ValidatorListCopier.copyFromBuilder(validators);
        }

        @Override
        public final Builder validators(Collection<Validator> validators) {
            this.validators = ValidatorListCopier.copy(validators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validators(Validator... validators) {
            validators(Arrays.asList(validators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validators(Consumer<Validator.Builder>... validators) {
            validators(Stream.of(validators).map(c -> Validator.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConfigurationProfileRequest build() {
            return new CreateConfigurationProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
