/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HostedConfigurationVersionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<HostedConfigurationVersionSummary.Builder, HostedConfigurationVersionSummary> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(HostedConfigurationVersionSummary::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> CONFIGURATION_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationProfileId").getter(getter(HostedConfigurationVersionSummary::configurationProfileId))
            .setter(setter(Builder::configurationProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationProfileId").build())
            .build();

    private static final SdkField<Integer> VERSION_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VersionNumber").getter(getter(HostedConfigurationVersionSummary::versionNumber))
            .setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(HostedConfigurationVersionSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(HostedConfigurationVersionSummary::contentType))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CONFIGURATION_PROFILE_ID_FIELD, VERSION_NUMBER_FIELD, DESCRIPTION_FIELD, CONTENT_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String configurationProfileId;

    private final Integer versionNumber;

    private final String description;

    private final String contentType;

    private HostedConfigurationVersionSummary(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.configurationProfileId = builder.configurationProfileId;
        this.versionNumber = builder.versionNumber;
        this.description = builder.description;
        this.contentType = builder.contentType;
    }

    /**
     * <p>
     * The application ID.
     * </p>
     * 
     * @return The application ID.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The configuration profile ID.
     * </p>
     * 
     * @return The configuration profile ID.
     */
    public final String configurationProfileId() {
        return configurationProfileId;
    }

    /**
     * <p>
     * The configuration version.
     * </p>
     * 
     * @return The configuration version.
     */
    public final Integer versionNumber() {
        return versionNumber;
    }

    /**
     * <p>
     * A description of the configuration.
     * </p>
     * 
     * @return A description of the configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A standard MIME type describing the format of the configuration content. For more information, see <a
     * href="https://docs.aws.amazon.com/https:/www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17"
     * >Content-Type</a>.
     * </p>
     * 
     * @return A standard MIME type describing the format of the configuration content. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/https:/www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content
     *         -Type</a>.
     */
    public final String contentType() {
        return contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(configurationProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostedConfigurationVersionSummary)) {
            return false;
        }
        HostedConfigurationVersionSummary other = (HostedConfigurationVersionSummary) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(configurationProfileId(), other.configurationProfileId())
                && Objects.equals(versionNumber(), other.versionNumber()) && Objects.equals(description(), other.description())
                && Objects.equals(contentType(), other.contentType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HostedConfigurationVersionSummary").add("ApplicationId", applicationId())
                .add("ConfigurationProfileId", configurationProfileId()).add("VersionNumber", versionNumber())
                .add("Description", description()).add("ContentType", contentType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "ConfigurationProfileId":
            return Optional.ofNullable(clazz.cast(configurationProfileId()));
        case "VersionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HostedConfigurationVersionSummary, T> g) {
        return obj -> g.apply((HostedConfigurationVersionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HostedConfigurationVersionSummary> {
        /**
         * <p>
         * The application ID.
         * </p>
         * 
         * @param applicationId
         *        The application ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The configuration profile ID.
         * </p>
         * 
         * @param configurationProfileId
         *        The configuration profile ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationProfileId(String configurationProfileId);

        /**
         * <p>
         * The configuration version.
         * </p>
         * 
         * @param versionNumber
         *        The configuration version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Integer versionNumber);

        /**
         * <p>
         * A description of the configuration.
         * </p>
         * 
         * @param description
         *        A description of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A standard MIME type describing the format of the configuration content. For more information, see <a
         * href="https://docs.aws.amazon.com/https:/www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17"
         * >Content-Type</a>.
         * </p>
         * 
         * @param contentType
         *        A standard MIME type describing the format of the configuration content. For more information, see <a
         *        href="https://docs.aws.amazon.com/https:/www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">
         *        Content-Type</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String configurationProfileId;

        private Integer versionNumber;

        private String description;

        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(HostedConfigurationVersionSummary model) {
            applicationId(model.applicationId);
            configurationProfileId(model.configurationProfileId);
            versionNumber(model.versionNumber);
            description(model.description);
            contentType(model.contentType);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        @Transient
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getConfigurationProfileId() {
            return configurationProfileId;
        }

        public final void setConfigurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
        }

        @Override
        @Transient
        public final Builder configurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
            return this;
        }

        public final Integer getVersionNumber() {
            return versionNumber;
        }

        public final void setVersionNumber(Integer versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        @Transient
        public final Builder versionNumber(Integer versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        @Transient
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public HostedConfigurationVersionSummary build() {
            return new HostedConfigurationVersionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
