/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A validator provides a syntactic or semantic check to ensure the configuration you want to deploy functions as
 * intended. To validate your application configuration data, you provide a schema or a Lambda function that runs
 * against the configuration. The configuration deployment or update can only proceed when the configuration data is
 * valid.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Validator implements SdkPojo, Serializable, ToCopyableBuilder<Validator.Builder, Validator> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Validator::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(Validator::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, CONTENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String content;

    private Validator(BuilderImpl builder) {
        this.type = builder.type;
        this.content = builder.content;
    }

    /**
     * <p>
     * AppConfig supports validators of type <code>JSON_SCHEMA</code> and <code>LAMBDA</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ValidatorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return AppConfig supports validators of type <code>JSON_SCHEMA</code> and <code>LAMBDA</code>
     * @see ValidatorType
     */
    public final ValidatorType type() {
        return ValidatorType.fromValue(type);
    }

    /**
     * <p>
     * AppConfig supports validators of type <code>JSON_SCHEMA</code> and <code>LAMBDA</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ValidatorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return AppConfig supports validators of type <code>JSON_SCHEMA</code> and <code>LAMBDA</code>
     * @see ValidatorType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Either the JSON Schema content or the Amazon Resource Name (ARN) of an AWS Lambda function.
     * </p>
     * 
     * @return Either the JSON Schema content or the Amazon Resource Name (ARN) of an AWS Lambda function.
     */
    public final String content() {
        return content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Validator)) {
            return false;
        }
        Validator other = (Validator) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(content(), other.content());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Validator").add("Type", typeAsString())
                .add("Content", content() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Validator, T> g) {
        return obj -> g.apply((Validator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Validator> {
        /**
         * <p>
         * AppConfig supports validators of type <code>JSON_SCHEMA</code> and <code>LAMBDA</code>
         * </p>
         * 
         * @param type
         *        AppConfig supports validators of type <code>JSON_SCHEMA</code> and <code>LAMBDA</code>
         * @see ValidatorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidatorType
         */
        Builder type(String type);

        /**
         * <p>
         * AppConfig supports validators of type <code>JSON_SCHEMA</code> and <code>LAMBDA</code>
         * </p>
         * 
         * @param type
         *        AppConfig supports validators of type <code>JSON_SCHEMA</code> and <code>LAMBDA</code>
         * @see ValidatorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidatorType
         */
        Builder type(ValidatorType type);

        /**
         * <p>
         * Either the JSON Schema content or the Amazon Resource Name (ARN) of an AWS Lambda function.
         * </p>
         * 
         * @param content
         *        Either the JSON Schema content or the Amazon Resource Name (ARN) of an AWS Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String content;

        private BuilderImpl() {
        }

        private BuilderImpl(Validator model) {
            type(model.type);
            content(model.content);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(ValidatorType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        @Transient
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        @Override
        public Validator build() {
            return new Validator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
