/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDeploymentStrategyResponse extends AppConfigResponse implements
        ToCopyableBuilder<UpdateDeploymentStrategyResponse.Builder, UpdateDeploymentStrategyResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdateDeploymentStrategyResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateDeploymentStrategyResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateDeploymentStrategyResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> DEPLOYMENT_DURATION_IN_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DeploymentDurationInMinutes")
            .getter(getter(UpdateDeploymentStrategyResponse::deploymentDurationInMinutes))
            .setter(setter(Builder::deploymentDurationInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentDurationInMinutes")
                    .build()).build();

    private static final SdkField<String> GROWTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GrowthType").getter(getter(UpdateDeploymentStrategyResponse::growthTypeAsString))
            .setter(setter(Builder::growthType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrowthType").build()).build();

    private static final SdkField<Float> GROWTH_FACTOR_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("GrowthFactor").getter(getter(UpdateDeploymentStrategyResponse::growthFactor))
            .setter(setter(Builder::growthFactor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrowthFactor").build()).build();

    private static final SdkField<Integer> FINAL_BAKE_TIME_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FinalBakeTimeInMinutes").getter(getter(UpdateDeploymentStrategyResponse::finalBakeTimeInMinutes))
            .setter(setter(Builder::finalBakeTimeInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalBakeTimeInMinutes").build())
            .build();

    private static final SdkField<String> REPLICATE_TO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicateTo").getter(getter(UpdateDeploymentStrategyResponse::replicateToAsString))
            .setter(setter(Builder::replicateTo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicateTo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, DEPLOYMENT_DURATION_IN_MINUTES_FIELD, GROWTH_TYPE_FIELD, GROWTH_FACTOR_FIELD,
            FINAL_BAKE_TIME_IN_MINUTES_FIELD, REPLICATE_TO_FIELD));

    private final String id;

    private final String name;

    private final String description;

    private final Integer deploymentDurationInMinutes;

    private final String growthType;

    private final Float growthFactor;

    private final Integer finalBakeTimeInMinutes;

    private final String replicateTo;

    private UpdateDeploymentStrategyResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.deploymentDurationInMinutes = builder.deploymentDurationInMinutes;
        this.growthType = builder.growthType;
        this.growthFactor = builder.growthFactor;
        this.finalBakeTimeInMinutes = builder.finalBakeTimeInMinutes;
        this.replicateTo = builder.replicateTo;
    }

    /**
     * <p>
     * The deployment strategy ID.
     * </p>
     * 
     * @return The deployment strategy ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the deployment strategy.
     * </p>
     * 
     * @return The name of the deployment strategy.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the deployment strategy.
     * </p>
     * 
     * @return The description of the deployment strategy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Total amount of time the deployment lasted.
     * </p>
     * 
     * @return Total amount of time the deployment lasted.
     */
    public final Integer deploymentDurationInMinutes() {
        return deploymentDurationInMinutes;
    }

    /**
     * <p>
     * The algorithm used to define how percentage grew over time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #growthType} will
     * return {@link GrowthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #growthTypeAsString}.
     * </p>
     * 
     * @return The algorithm used to define how percentage grew over time.
     * @see GrowthType
     */
    public final GrowthType growthType() {
        return GrowthType.fromValue(growthType);
    }

    /**
     * <p>
     * The algorithm used to define how percentage grew over time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #growthType} will
     * return {@link GrowthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #growthTypeAsString}.
     * </p>
     * 
     * @return The algorithm used to define how percentage grew over time.
     * @see GrowthType
     */
    public final String growthTypeAsString() {
        return growthType;
    }

    /**
     * <p>
     * The percentage of targets that received a deployed configuration during each interval.
     * </p>
     * 
     * @return The percentage of targets that received a deployed configuration during each interval.
     */
    public final Float growthFactor() {
        return growthFactor;
    }

    /**
     * <p>
     * The amount of time AppConfig monitored for alarms before considering the deployment to be complete and no longer
     * eligible for automatic roll back.
     * </p>
     * 
     * @return The amount of time AppConfig monitored for alarms before considering the deployment to be complete and no
     *         longer eligible for automatic roll back.
     */
    public final Integer finalBakeTimeInMinutes() {
        return finalBakeTimeInMinutes;
    }

    /**
     * <p>
     * Save the deployment strategy to a Systems Manager (SSM) document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicateTo} will
     * return {@link ReplicateTo#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #replicateToAsString}.
     * </p>
     * 
     * @return Save the deployment strategy to a Systems Manager (SSM) document.
     * @see ReplicateTo
     */
    public final ReplicateTo replicateTo() {
        return ReplicateTo.fromValue(replicateTo);
    }

    /**
     * <p>
     * Save the deployment strategy to a Systems Manager (SSM) document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicateTo} will
     * return {@link ReplicateTo#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #replicateToAsString}.
     * </p>
     * 
     * @return Save the deployment strategy to a Systems Manager (SSM) document.
     * @see ReplicateTo
     */
    public final String replicateToAsString() {
        return replicateTo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentDurationInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(growthTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(growthFactor());
        hashCode = 31 * hashCode + Objects.hashCode(finalBakeTimeInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(replicateToAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeploymentStrategyResponse)) {
            return false;
        }
        UpdateDeploymentStrategyResponse other = (UpdateDeploymentStrategyResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(deploymentDurationInMinutes(), other.deploymentDurationInMinutes())
                && Objects.equals(growthTypeAsString(), other.growthTypeAsString())
                && Objects.equals(growthFactor(), other.growthFactor())
                && Objects.equals(finalBakeTimeInMinutes(), other.finalBakeTimeInMinutes())
                && Objects.equals(replicateToAsString(), other.replicateToAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDeploymentStrategyResponse").add("Id", id()).add("Name", name())
                .add("Description", description()).add("DeploymentDurationInMinutes", deploymentDurationInMinutes())
                .add("GrowthType", growthTypeAsString()).add("GrowthFactor", growthFactor())
                .add("FinalBakeTimeInMinutes", finalBakeTimeInMinutes()).add("ReplicateTo", replicateToAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DeploymentDurationInMinutes":
            return Optional.ofNullable(clazz.cast(deploymentDurationInMinutes()));
        case "GrowthType":
            return Optional.ofNullable(clazz.cast(growthTypeAsString()));
        case "GrowthFactor":
            return Optional.ofNullable(clazz.cast(growthFactor()));
        case "FinalBakeTimeInMinutes":
            return Optional.ofNullable(clazz.cast(finalBakeTimeInMinutes()));
        case "ReplicateTo":
            return Optional.ofNullable(clazz.cast(replicateToAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDeploymentStrategyResponse, T> g) {
        return obj -> g.apply((UpdateDeploymentStrategyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDeploymentStrategyResponse> {
        /**
         * <p>
         * The deployment strategy ID.
         * </p>
         * 
         * @param id
         *        The deployment strategy ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the deployment strategy.
         * </p>
         * 
         * @param name
         *        The name of the deployment strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the deployment strategy.
         * </p>
         * 
         * @param description
         *        The description of the deployment strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Total amount of time the deployment lasted.
         * </p>
         * 
         * @param deploymentDurationInMinutes
         *        Total amount of time the deployment lasted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentDurationInMinutes(Integer deploymentDurationInMinutes);

        /**
         * <p>
         * The algorithm used to define how percentage grew over time.
         * </p>
         * 
         * @param growthType
         *        The algorithm used to define how percentage grew over time.
         * @see GrowthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GrowthType
         */
        Builder growthType(String growthType);

        /**
         * <p>
         * The algorithm used to define how percentage grew over time.
         * </p>
         * 
         * @param growthType
         *        The algorithm used to define how percentage grew over time.
         * @see GrowthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GrowthType
         */
        Builder growthType(GrowthType growthType);

        /**
         * <p>
         * The percentage of targets that received a deployed configuration during each interval.
         * </p>
         * 
         * @param growthFactor
         *        The percentage of targets that received a deployed configuration during each interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder growthFactor(Float growthFactor);

        /**
         * <p>
         * The amount of time AppConfig monitored for alarms before considering the deployment to be complete and no
         * longer eligible for automatic roll back.
         * </p>
         * 
         * @param finalBakeTimeInMinutes
         *        The amount of time AppConfig monitored for alarms before considering the deployment to be complete and
         *        no longer eligible for automatic roll back.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalBakeTimeInMinutes(Integer finalBakeTimeInMinutes);

        /**
         * <p>
         * Save the deployment strategy to a Systems Manager (SSM) document.
         * </p>
         * 
         * @param replicateTo
         *        Save the deployment strategy to a Systems Manager (SSM) document.
         * @see ReplicateTo
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicateTo
         */
        Builder replicateTo(String replicateTo);

        /**
         * <p>
         * Save the deployment strategy to a Systems Manager (SSM) document.
         * </p>
         * 
         * @param replicateTo
         *        Save the deployment strategy to a Systems Manager (SSM) document.
         * @see ReplicateTo
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicateTo
         */
        Builder replicateTo(ReplicateTo replicateTo);
    }

    static final class BuilderImpl extends AppConfigResponse.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private Integer deploymentDurationInMinutes;

        private String growthType;

        private Float growthFactor;

        private Integer finalBakeTimeInMinutes;

        private String replicateTo;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeploymentStrategyResponse model) {
            super(model);
            id(model.id);
            name(model.name);
            description(model.description);
            deploymentDurationInMinutes(model.deploymentDurationInMinutes);
            growthType(model.growthType);
            growthFactor(model.growthFactor);
            finalBakeTimeInMinutes(model.finalBakeTimeInMinutes);
            replicateTo(model.replicateTo);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getDeploymentDurationInMinutes() {
            return deploymentDurationInMinutes;
        }

        public final void setDeploymentDurationInMinutes(Integer deploymentDurationInMinutes) {
            this.deploymentDurationInMinutes = deploymentDurationInMinutes;
        }

        @Override
        @Transient
        public final Builder deploymentDurationInMinutes(Integer deploymentDurationInMinutes) {
            this.deploymentDurationInMinutes = deploymentDurationInMinutes;
            return this;
        }

        public final String getGrowthType() {
            return growthType;
        }

        public final void setGrowthType(String growthType) {
            this.growthType = growthType;
        }

        @Override
        @Transient
        public final Builder growthType(String growthType) {
            this.growthType = growthType;
            return this;
        }

        @Override
        @Transient
        public final Builder growthType(GrowthType growthType) {
            this.growthType(growthType == null ? null : growthType.toString());
            return this;
        }

        public final Float getGrowthFactor() {
            return growthFactor;
        }

        public final void setGrowthFactor(Float growthFactor) {
            this.growthFactor = growthFactor;
        }

        @Override
        @Transient
        public final Builder growthFactor(Float growthFactor) {
            this.growthFactor = growthFactor;
            return this;
        }

        public final Integer getFinalBakeTimeInMinutes() {
            return finalBakeTimeInMinutes;
        }

        public final void setFinalBakeTimeInMinutes(Integer finalBakeTimeInMinutes) {
            this.finalBakeTimeInMinutes = finalBakeTimeInMinutes;
        }

        @Override
        @Transient
        public final Builder finalBakeTimeInMinutes(Integer finalBakeTimeInMinutes) {
            this.finalBakeTimeInMinutes = finalBakeTimeInMinutes;
            return this;
        }

        public final String getReplicateTo() {
            return replicateTo;
        }

        public final void setReplicateTo(String replicateTo) {
            this.replicateTo = replicateTo;
        }

        @Override
        @Transient
        public final Builder replicateTo(String replicateTo) {
            this.replicateTo = replicateTo;
            return this;
        }

        @Override
        @Transient
        public final Builder replicateTo(ReplicateTo replicateTo) {
            this.replicateTo(replicateTo == null ? null : replicateTo.toString());
            return this;
        }

        @Override
        public UpdateDeploymentStrategyResponse build() {
            return new UpdateDeploymentStrategyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
