/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appconfig.AppConfigClient;
import software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesRequest;
import software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesResponse;

public class ListDeploymentStrategiesIterable
implements SdkIterable<ListDeploymentStrategiesResponse> {
    private final AppConfigClient client;
    private final ListDeploymentStrategiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDeploymentStrategiesIterable(AppConfigClient client, ListDeploymentStrategiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDeploymentStrategiesResponseFetcher();
    }

    public Iterator<ListDeploymentStrategiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDeploymentStrategiesResponseFetcher
    implements SyncPageFetcher<ListDeploymentStrategiesResponse> {
        private ListDeploymentStrategiesResponseFetcher() {
        }

        public boolean hasNextPage(ListDeploymentStrategiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDeploymentStrategiesResponse nextPage(ListDeploymentStrategiesResponse previousPage) {
            if (previousPage == null) {
                return ListDeploymentStrategiesIterable.this.client.listDeploymentStrategies(ListDeploymentStrategiesIterable.this.firstRequest);
            }
            return ListDeploymentStrategiesIterable.this.client.listDeploymentStrategies((ListDeploymentStrategiesRequest)((Object)ListDeploymentStrategiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

