/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An extension that was invoked during a deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppliedExtension implements SdkPojo, Serializable,
        ToCopyableBuilder<AppliedExtension.Builder, AppliedExtension> {
    private static final SdkField<String> EXTENSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExtensionId").getter(getter(AppliedExtension::extensionId)).setter(setter(Builder::extensionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtensionId").build()).build();

    private static final SdkField<String> EXTENSION_ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExtensionAssociationId").getter(getter(AppliedExtension::extensionAssociationId))
            .setter(setter(Builder::extensionAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtensionAssociationId").build())
            .build();

    private static final SdkField<Integer> VERSION_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VersionNumber").getter(getter(AppliedExtension::versionNumber)).setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(AppliedExtension::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTENSION_ID_FIELD,
            EXTENSION_ASSOCIATION_ID_FIELD, VERSION_NUMBER_FIELD, PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String extensionId;

    private final String extensionAssociationId;

    private final Integer versionNumber;

    private final Map<String, String> parameters;

    private AppliedExtension(BuilderImpl builder) {
        this.extensionId = builder.extensionId;
        this.extensionAssociationId = builder.extensionAssociationId;
        this.versionNumber = builder.versionNumber;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The system-generated ID of the extension.
     * </p>
     * 
     * @return The system-generated ID of the extension.
     */
    public final String extensionId() {
        return extensionId;
    }

    /**
     * <p>
     * The system-generated ID for the association.
     * </p>
     * 
     * @return The system-generated ID for the association.
     */
    public final String extensionAssociationId() {
        return extensionAssociationId;
    }

    /**
     * <p>
     * The extension version number.
     * </p>
     * 
     * @return The extension version number.
     */
    public final Integer versionNumber() {
        return versionNumber;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more parameters for the actions called by the extension.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return One or more parameters for the actions called by the extension.
     */
    public final Map<String, String> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(extensionId());
        hashCode = 31 * hashCode + Objects.hashCode(extensionAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppliedExtension)) {
            return false;
        }
        AppliedExtension other = (AppliedExtension) obj;
        return Objects.equals(extensionId(), other.extensionId())
                && Objects.equals(extensionAssociationId(), other.extensionAssociationId())
                && Objects.equals(versionNumber(), other.versionNumber()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppliedExtension").add("ExtensionId", extensionId())
                .add("ExtensionAssociationId", extensionAssociationId()).add("VersionNumber", versionNumber())
                .add("Parameters", hasParameters() ? parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExtensionId":
            return Optional.ofNullable(clazz.cast(extensionId()));
        case "ExtensionAssociationId":
            return Optional.ofNullable(clazz.cast(extensionAssociationId()));
        case "VersionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppliedExtension, T> g) {
        return obj -> g.apply((AppliedExtension) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppliedExtension> {
        /**
         * <p>
         * The system-generated ID of the extension.
         * </p>
         * 
         * @param extensionId
         *        The system-generated ID of the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extensionId(String extensionId);

        /**
         * <p>
         * The system-generated ID for the association.
         * </p>
         * 
         * @param extensionAssociationId
         *        The system-generated ID for the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extensionAssociationId(String extensionAssociationId);

        /**
         * <p>
         * The extension version number.
         * </p>
         * 
         * @param versionNumber
         *        The extension version number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Integer versionNumber);

        /**
         * <p>
         * One or more parameters for the actions called by the extension.
         * </p>
         * 
         * @param parameters
         *        One or more parameters for the actions called by the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);
    }

    static final class BuilderImpl implements Builder {
        private String extensionId;

        private String extensionAssociationId;

        private Integer versionNumber;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AppliedExtension model) {
            extensionId(model.extensionId);
            extensionAssociationId(model.extensionAssociationId);
            versionNumber(model.versionNumber);
            parameters(model.parameters);
        }

        public final String getExtensionId() {
            return extensionId;
        }

        public final void setExtensionId(String extensionId) {
            this.extensionId = extensionId;
        }

        @Override
        public final Builder extensionId(String extensionId) {
            this.extensionId = extensionId;
            return this;
        }

        public final String getExtensionAssociationId() {
            return extensionAssociationId;
        }

        public final void setExtensionAssociationId(String extensionAssociationId) {
            this.extensionAssociationId = extensionAssociationId;
        }

        @Override
        public final Builder extensionAssociationId(String extensionAssociationId) {
            this.extensionAssociationId = extensionAssociationId;
            return this;
        }

        public final Integer getVersionNumber() {
            return versionNumber;
        }

        public final void setVersionNumber(Integer versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Integer versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParameterValueMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParameterValueMapCopier.copy(parameters);
            return this;
        }

        @Override
        public AppliedExtension build() {
            return new AppliedExtension(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
