/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An extension that was invoked as part of a deployment event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionInvocation implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionInvocation.Builder, ActionInvocation> {
    private static final SdkField<String> EXTENSION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExtensionIdentifier").getter(getter(ActionInvocation::extensionIdentifier))
            .setter(setter(Builder::extensionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtensionIdentifier").build())
            .build();

    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionName").getter(getter(ActionInvocation::actionName)).setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionName").build()).build();

    private static final SdkField<String> URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Uri")
            .getter(getter(ActionInvocation::uri)).setter(setter(Builder::uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Uri").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(ActionInvocation::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(ActionInvocation::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(ActionInvocation::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> INVOCATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvocationId").getter(getter(ActionInvocation::invocationId)).setter(setter(Builder::invocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTENSION_IDENTIFIER_FIELD,
            ACTION_NAME_FIELD, URI_FIELD, ROLE_ARN_FIELD, ERROR_MESSAGE_FIELD, ERROR_CODE_FIELD, INVOCATION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String extensionIdentifier;

    private final String actionName;

    private final String uri;

    private final String roleArn;

    private final String errorMessage;

    private final String errorCode;

    private final String invocationId;

    private ActionInvocation(BuilderImpl builder) {
        this.extensionIdentifier = builder.extensionIdentifier;
        this.actionName = builder.actionName;
        this.uri = builder.uri;
        this.roleArn = builder.roleArn;
        this.errorMessage = builder.errorMessage;
        this.errorCode = builder.errorCode;
        this.invocationId = builder.invocationId;
    }

    /**
     * <p>
     * The name, the ID, or the Amazon Resource Name (ARN) of the extension.
     * </p>
     * 
     * @return The name, the ID, or the Amazon Resource Name (ARN) of the extension.
     */
    public final String extensionIdentifier() {
        return extensionIdentifier;
    }

    /**
     * <p>
     * The name of the action.
     * </p>
     * 
     * @return The name of the action.
     */
    public final String actionName() {
        return actionName;
    }

    /**
     * <p>
     * The extension URI associated to the action point in the extension definition. The URI can be an Amazon Resource
     * Name (ARN) for one of the following: an Lambda function, an Amazon Simple Queue Service queue, an Amazon Simple
     * Notification Service topic, or the Amazon EventBridge default event bus.
     * </p>
     * 
     * @return The extension URI associated to the action point in the extension definition. The URI can be an Amazon
     *         Resource Name (ARN) for one of the following: an Lambda function, an Amazon Simple Queue Service queue,
     *         an Amazon Simple Notification Service topic, or the Amazon EventBridge default event bus.
     */
    public final String uri() {
        return uri;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) for an Identity and Access Management assume role.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) for an Identity and Access Management assume role.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The error message when an extension invocation fails.
     * </p>
     * 
     * @return The error message when an extension invocation fails.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The error code when an extension invocation fails.
     * </p>
     * 
     * @return The error code when an extension invocation fails.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * A system-generated ID for this invocation.
     * </p>
     * 
     * @return A system-generated ID for this invocation.
     */
    public final String invocationId() {
        return invocationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(extensionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        hashCode = 31 * hashCode + Objects.hashCode(uri());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(invocationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionInvocation)) {
            return false;
        }
        ActionInvocation other = (ActionInvocation) obj;
        return Objects.equals(extensionIdentifier(), other.extensionIdentifier())
                && Objects.equals(actionName(), other.actionName()) && Objects.equals(uri(), other.uri())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(errorCode(), other.errorCode()) && Objects.equals(invocationId(), other.invocationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionInvocation").add("ExtensionIdentifier", extensionIdentifier())
                .add("ActionName", actionName()).add("Uri", uri()).add("RoleArn", roleArn()).add("ErrorMessage", errorMessage())
                .add("ErrorCode", errorCode()).add("InvocationId", invocationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExtensionIdentifier":
            return Optional.ofNullable(clazz.cast(extensionIdentifier()));
        case "ActionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        case "Uri":
            return Optional.ofNullable(clazz.cast(uri()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "InvocationId":
            return Optional.ofNullable(clazz.cast(invocationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionInvocation, T> g) {
        return obj -> g.apply((ActionInvocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionInvocation> {
        /**
         * <p>
         * The name, the ID, or the Amazon Resource Name (ARN) of the extension.
         * </p>
         * 
         * @param extensionIdentifier
         *        The name, the ID, or the Amazon Resource Name (ARN) of the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extensionIdentifier(String extensionIdentifier);

        /**
         * <p>
         * The name of the action.
         * </p>
         * 
         * @param actionName
         *        The name of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);

        /**
         * <p>
         * The extension URI associated to the action point in the extension definition. The URI can be an Amazon
         * Resource Name (ARN) for one of the following: an Lambda function, an Amazon Simple Queue Service queue, an
         * Amazon Simple Notification Service topic, or the Amazon EventBridge default event bus.
         * </p>
         * 
         * @param uri
         *        The extension URI associated to the action point in the extension definition. The URI can be an Amazon
         *        Resource Name (ARN) for one of the following: an Lambda function, an Amazon Simple Queue Service
         *        queue, an Amazon Simple Notification Service topic, or the Amazon EventBridge default event bus.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);

        /**
         * <p>
         * An Amazon Resource Name (ARN) for an Identity and Access Management assume role.
         * </p>
         * 
         * @param roleArn
         *        An Amazon Resource Name (ARN) for an Identity and Access Management assume role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The error message when an extension invocation fails.
         * </p>
         * 
         * @param errorMessage
         *        The error message when an extension invocation fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The error code when an extension invocation fails.
         * </p>
         * 
         * @param errorCode
         *        The error code when an extension invocation fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * A system-generated ID for this invocation.
         * </p>
         * 
         * @param invocationId
         *        A system-generated ID for this invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationId(String invocationId);
    }

    static final class BuilderImpl implements Builder {
        private String extensionIdentifier;

        private String actionName;

        private String uri;

        private String roleArn;

        private String errorMessage;

        private String errorCode;

        private String invocationId;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionInvocation model) {
            extensionIdentifier(model.extensionIdentifier);
            actionName(model.actionName);
            uri(model.uri);
            roleArn(model.roleArn);
            errorMessage(model.errorMessage);
            errorCode(model.errorCode);
            invocationId(model.invocationId);
        }

        public final String getExtensionIdentifier() {
            return extensionIdentifier;
        }

        public final void setExtensionIdentifier(String extensionIdentifier) {
            this.extensionIdentifier = extensionIdentifier;
        }

        @Override
        public final Builder extensionIdentifier(String extensionIdentifier) {
            this.extensionIdentifier = extensionIdentifier;
            return this;
        }

        public final String getActionName() {
            return actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final String getUri() {
            return uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getInvocationId() {
            return invocationId;
        }

        public final void setInvocationId(String invocationId) {
            this.invocationId = invocationId;
        }

        @Override
        public final Builder invocationId(String invocationId) {
            this.invocationId = invocationId;
            return this;
        }

        @Override
        public ActionInvocation build() {
            return new ActionInvocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
