/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.appconfig.model.CreateApplicationRequest;
import software.amazon.awssdk.services.appconfig.model.CreateApplicationResponse;
import software.amazon.awssdk.services.appconfig.model.CreateConfigurationProfileRequest;
import software.amazon.awssdk.services.appconfig.model.CreateConfigurationProfileResponse;
import software.amazon.awssdk.services.appconfig.model.CreateDeploymentStrategyRequest;
import software.amazon.awssdk.services.appconfig.model.CreateDeploymentStrategyResponse;
import software.amazon.awssdk.services.appconfig.model.CreateEnvironmentRequest;
import software.amazon.awssdk.services.appconfig.model.CreateEnvironmentResponse;
import software.amazon.awssdk.services.appconfig.model.CreateExtensionAssociationRequest;
import software.amazon.awssdk.services.appconfig.model.CreateExtensionAssociationResponse;
import software.amazon.awssdk.services.appconfig.model.CreateExtensionRequest;
import software.amazon.awssdk.services.appconfig.model.CreateExtensionResponse;
import software.amazon.awssdk.services.appconfig.model.CreateHostedConfigurationVersionRequest;
import software.amazon.awssdk.services.appconfig.model.CreateHostedConfigurationVersionResponse;
import software.amazon.awssdk.services.appconfig.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.appconfig.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.appconfig.model.DeleteConfigurationProfileRequest;
import software.amazon.awssdk.services.appconfig.model.DeleteConfigurationProfileResponse;
import software.amazon.awssdk.services.appconfig.model.DeleteDeploymentStrategyRequest;
import software.amazon.awssdk.services.appconfig.model.DeleteDeploymentStrategyResponse;
import software.amazon.awssdk.services.appconfig.model.DeleteEnvironmentRequest;
import software.amazon.awssdk.services.appconfig.model.DeleteEnvironmentResponse;
import software.amazon.awssdk.services.appconfig.model.DeleteExtensionAssociationRequest;
import software.amazon.awssdk.services.appconfig.model.DeleteExtensionAssociationResponse;
import software.amazon.awssdk.services.appconfig.model.DeleteExtensionRequest;
import software.amazon.awssdk.services.appconfig.model.DeleteExtensionResponse;
import software.amazon.awssdk.services.appconfig.model.DeleteHostedConfigurationVersionRequest;
import software.amazon.awssdk.services.appconfig.model.DeleteHostedConfigurationVersionResponse;
import software.amazon.awssdk.services.appconfig.model.GetApplicationRequest;
import software.amazon.awssdk.services.appconfig.model.GetApplicationResponse;
import software.amazon.awssdk.services.appconfig.model.GetConfigurationProfileRequest;
import software.amazon.awssdk.services.appconfig.model.GetConfigurationProfileResponse;
import software.amazon.awssdk.services.appconfig.model.GetConfigurationRequest;
import software.amazon.awssdk.services.appconfig.model.GetConfigurationResponse;
import software.amazon.awssdk.services.appconfig.model.GetDeploymentRequest;
import software.amazon.awssdk.services.appconfig.model.GetDeploymentResponse;
import software.amazon.awssdk.services.appconfig.model.GetDeploymentStrategyRequest;
import software.amazon.awssdk.services.appconfig.model.GetDeploymentStrategyResponse;
import software.amazon.awssdk.services.appconfig.model.GetEnvironmentRequest;
import software.amazon.awssdk.services.appconfig.model.GetEnvironmentResponse;
import software.amazon.awssdk.services.appconfig.model.GetExtensionAssociationRequest;
import software.amazon.awssdk.services.appconfig.model.GetExtensionAssociationResponse;
import software.amazon.awssdk.services.appconfig.model.GetExtensionRequest;
import software.amazon.awssdk.services.appconfig.model.GetExtensionResponse;
import software.amazon.awssdk.services.appconfig.model.GetHostedConfigurationVersionRequest;
import software.amazon.awssdk.services.appconfig.model.GetHostedConfigurationVersionResponse;
import software.amazon.awssdk.services.appconfig.model.ListApplicationsRequest;
import software.amazon.awssdk.services.appconfig.model.ListApplicationsResponse;
import software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesRequest;
import software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesResponse;
import software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesRequest;
import software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesResponse;
import software.amazon.awssdk.services.appconfig.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.appconfig.model.ListDeploymentsResponse;
import software.amazon.awssdk.services.appconfig.model.ListEnvironmentsRequest;
import software.amazon.awssdk.services.appconfig.model.ListEnvironmentsResponse;
import software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsRequest;
import software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsResponse;
import software.amazon.awssdk.services.appconfig.model.ListExtensionsRequest;
import software.amazon.awssdk.services.appconfig.model.ListExtensionsResponse;
import software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsRequest;
import software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsResponse;
import software.amazon.awssdk.services.appconfig.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.appconfig.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.appconfig.model.StartDeploymentRequest;
import software.amazon.awssdk.services.appconfig.model.StartDeploymentResponse;
import software.amazon.awssdk.services.appconfig.model.StopDeploymentRequest;
import software.amazon.awssdk.services.appconfig.model.StopDeploymentResponse;
import software.amazon.awssdk.services.appconfig.model.TagResourceRequest;
import software.amazon.awssdk.services.appconfig.model.TagResourceResponse;
import software.amazon.awssdk.services.appconfig.model.UntagResourceRequest;
import software.amazon.awssdk.services.appconfig.model.UntagResourceResponse;
import software.amazon.awssdk.services.appconfig.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.appconfig.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.appconfig.model.UpdateConfigurationProfileRequest;
import software.amazon.awssdk.services.appconfig.model.UpdateConfigurationProfileResponse;
import software.amazon.awssdk.services.appconfig.model.UpdateDeploymentStrategyRequest;
import software.amazon.awssdk.services.appconfig.model.UpdateDeploymentStrategyResponse;
import software.amazon.awssdk.services.appconfig.model.UpdateEnvironmentRequest;
import software.amazon.awssdk.services.appconfig.model.UpdateEnvironmentResponse;
import software.amazon.awssdk.services.appconfig.model.UpdateExtensionAssociationRequest;
import software.amazon.awssdk.services.appconfig.model.UpdateExtensionAssociationResponse;
import software.amazon.awssdk.services.appconfig.model.UpdateExtensionRequest;
import software.amazon.awssdk.services.appconfig.model.UpdateExtensionResponse;
import software.amazon.awssdk.services.appconfig.model.ValidateConfigurationRequest;
import software.amazon.awssdk.services.appconfig.model.ValidateConfigurationResponse;
import software.amazon.awssdk.services.appconfig.paginators.ListApplicationsPublisher;
import software.amazon.awssdk.services.appconfig.paginators.ListConfigurationProfilesPublisher;
import software.amazon.awssdk.services.appconfig.paginators.ListDeploymentStrategiesPublisher;
import software.amazon.awssdk.services.appconfig.paginators.ListDeploymentsPublisher;
import software.amazon.awssdk.services.appconfig.paginators.ListEnvironmentsPublisher;
import software.amazon.awssdk.services.appconfig.paginators.ListExtensionAssociationsPublisher;
import software.amazon.awssdk.services.appconfig.paginators.ListExtensionsPublisher;
import software.amazon.awssdk.services.appconfig.paginators.ListHostedConfigurationVersionsPublisher;

/**
 * Service client for accessing AppConfig asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * AppConfig feature flags and dynamic configurations help software builders quickly and securely adjust application
 * behavior in production environments without full code deployments. AppConfig speeds up software release frequency,
 * improves application resiliency, and helps you address emergent issues more quickly. With feature flags, you can
 * gradually release new capabilities to users and measure the impact of those changes before fully deploying the new
 * capabilities to all users. With operational flags and dynamic configurations, you can update block lists, allow
 * lists, throttling limits, logging verbosity, and perform other operational tuning to quickly respond to issues in
 * production environments.
 * </p>
 * <note>
 * <p>
 * AppConfig is a capability of Amazon Web Services Systems Manager.
 * </p>
 * </note>
 * <p>
 * Despite the fact that application configuration content can vary greatly from application to application, AppConfig
 * supports the following use cases, which cover a broad spectrum of customer needs:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>Feature flags and toggles</b> - Safely release new capabilities to your customers in a controlled environment.
 * Instantly roll back changes if you experience a problem.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Application tuning</b> - Carefully introduce application changes while testing the impact of those changes with
 * users in production environments.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Allow list or block list</b> - Control access to premium features or instantly block specific users without
 * deploying new code.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Centralized configuration storage</b> - Keep your configuration data organized and consistent across all of your
 * workloads. You can use AppConfig to deploy configuration data stored in the AppConfig hosted configuration store,
 * Secrets Manager, Systems Manager, Parameter Store, or Amazon S3.
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>How AppConfig works</b>
 * </p>
 * <p>
 * This section provides a high-level description of how AppConfig works and how you get started.
 * </p>
 * <dl>
 * <dt>1. Identify configuration values in code you want to manage in the cloud</dt>
 * <dd>
 * <p>
 * Before you start creating AppConfig artifacts, we recommend you identify configuration data in your code that you
 * want to dynamically manage using AppConfig. Good examples include feature flags or toggles, allow and block lists,
 * logging verbosity, service limits, and throttling rules, to name a few.
 * </p>
 * <p>
 * If your configuration data already exists in the cloud, you can take advantage of AppConfig validation, deployment,
 * and extension features to further streamline configuration data management.
 * </p>
 * </dd>
 * <dt>2. Create an application namespace</dt>
 * <dd>
 * <p>
 * To create a namespace, you create an AppConfig artifact called an application. An application is simply an
 * organizational construct like a folder.
 * </p>
 * </dd>
 * <dt>3. Create environments</dt>
 * <dd>
 * <p>
 * For each AppConfig application, you define one or more environments. An environment is a logical grouping of targets,
 * such as applications in a <code>Beta</code> or <code>Production</code> environment, Lambda functions, or containers.
 * You can also define environments for application subcomponents, such as the <code>Web</code>, <code>Mobile</code>,
 * and <code>Back-end</code>.
 * </p>
 * <p>
 * You can configure Amazon CloudWatch alarms for each environment. The system monitors alarms during a configuration
 * deployment. If an alarm is triggered, the system rolls back the configuration.
 * </p>
 * </dd>
 * <dt>4. Create a configuration profile</dt>
 * <dd>
 * <p>
 * A configuration profile includes, among other things, a URI that enables AppConfig to locate your configuration data
 * in its stored location and a profile type. AppConfig supports two configuration profile types: feature flags and
 * freeform configurations. Feature flag configuration profiles store their data in the AppConfig hosted configuration
 * store and the URI is simply <code>hosted</code>. For freeform configuration profiles, you can store your data in the
 * AppConfig hosted configuration store or any Amazon Web Services service that integrates with AppConfig, as described
 * in <a href="http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-free-form-configurations-creating.html">
 * Creating a free form configuration profile</a> in the the <i>AppConfig User Guide</i>.
 * </p>
 * <p>
 * A configuration profile can also include optional validators to ensure your configuration data is syntactically and
 * semantically correct. AppConfig performs a check using the validators when you start a deployment. If any errors are
 * detected, the deployment rolls back to the previous configuration data.
 * </p>
 * </dd>
 * <dt>5. Deploy configuration data</dt>
 * <dd>
 * <p>
 * When you create a new deployment, you specify the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * An application ID
 * </p>
 * </li>
 * <li>
 * <p>
 * A configuration profile ID
 * </p>
 * </li>
 * <li>
 * <p>
 * A configuration version
 * </p>
 * </li>
 * <li>
 * <p>
 * An environment ID where you want to deploy the configuration data
 * </p>
 * </li>
 * <li>
 * <p>
 * A deployment strategy ID that defines how fast you want the changes to take effect
 * </p>
 * </li>
 * </ul>
 * <p>
 * When you call the <a
 * href="https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_StartDeployment.html">StartDeployment</a> API
 * action, AppConfig performs the following tasks:
 * </p>
 * <ol>
 * <li>
 * <p>
 * Retrieves the configuration data from the underlying data store by using the location URI in the configuration
 * profile.
 * </p>
 * </li>
 * <li>
 * <p>
 * Verifies the configuration data is syntactically and semantically correct by using the validators you specified when
 * you created your configuration profile.
 * </p>
 * </li>
 * <li>
 * <p>
 * Caches a copy of the data so it is ready to be retrieved by your application. This cached copy is called the
 * <i>deployed data</i>.
 * </p>
 * </li>
 * </ol>
 * </dd>
 * <dt>6. Retrieve the configuration</dt>
 * <dd>
 * <p>
 * You can configure AppConfig Agent as a local host and have the agent poll AppConfig for configuration updates. The
 * agent calls the <a href=
 * "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_StartConfigurationSession.html"
 * >StartConfigurationSession</a> and <a
 * href="https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
 * >GetLatestConfiguration</a> API actions and caches your configuration data locally. To retrieve the data, your
 * application makes an HTTP call to the localhost server. AppConfig Agent supports several use cases, as described in
 * <a href="http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-simplified-methods.html">
 * Simplified retrieval methods</a> in the the <i>AppConfig User Guide</i>.
 * </p>
 * <p>
 * If AppConfig Agent isn't supported for your use case, you can configure your application to poll AppConfig for
 * configuration updates by directly calling the <a href=
 * "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_StartConfigurationSession.html"
 * >StartConfigurationSession</a> and <a
 * href="https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
 * >GetLatestConfiguration</a> API actions.
 * </p>
 * </dd>
 * </dl>
 * <p>
 * This reference is intended to be used with the <a
 * href="http://docs.aws.amazon.com/appconfig/latest/userguide/what-is-appconfig.html">AppConfig User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AppConfigAsyncClient extends AwsClient {
    String SERVICE_NAME = "appconfig";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "appconfig";

    /**
     * <p>
     * Creates an application. In AppConfig, an application is simply an organizational construct like a folder. This
     * organizational construct has a relationship with some unit of executable code. For example, you could create an
     * application called MyMobileApp to organize and manage configuration data for a mobile application installed by
     * your users.
     * </p>
     *
     * @param createApplicationRequest
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ServiceQuotaExceededException The number of one more AppConfig resources exceeds the maximum allowed.
     *         Verify that your environment doesn't exceed the following service quotas:</p>
     *         <p>
     *         Applications: 100 max
     *         </p>
     *         <p>
     *         Deployment strategies: 20 max
     *         </p>
     *         <p>
     *         Configuration profiles: 100 max per application
     *         </p>
     *         <p>
     *         Environments: 20 max per application
     *         </p>
     *         <p>
     *         To resolve this issue, you can delete one or more resources and try again. Or, you can request a quota
     *         increase. For more information about quotas and to request an increase, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/appconfig.html#limits_appconfig">Service quotas for
     *         AppConfig</a> in the Amazon Web Services General Reference.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(CreateApplicationRequest createApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an application. In AppConfig, an application is simply an organizational construct like a folder. This
     * organizational construct has a relationship with some unit of executable code. For example, you could create an
     * application called MyMobileApp to organize and manage configuration data for a mobile application installed by
     * your users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     * </p>
     *
     * @param createApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.CreateApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ServiceQuotaExceededException The number of one more AppConfig resources exceeds the maximum allowed.
     *         Verify that your environment doesn't exceed the following service quotas:</p>
     *         <p>
     *         Applications: 100 max
     *         </p>
     *         <p>
     *         Deployment strategies: 20 max
     *         </p>
     *         <p>
     *         Configuration profiles: 100 max per application
     *         </p>
     *         <p>
     *         Environments: 20 max per application
     *         </p>
     *         <p>
     *         To resolve this issue, you can delete one or more resources and try again. Or, you can request a quota
     *         increase. For more information about quotas and to request an increase, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/appconfig.html#limits_appconfig">Service quotas for
     *         AppConfig</a> in the Amazon Web Services General Reference.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(
            Consumer<CreateApplicationRequest.Builder> createApplicationRequest) {
        return createApplication(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
    }

    /**
     * <p>
     * Creates a configuration profile, which is information that enables AppConfig to access the configuration source.
     * Valid configuration sources include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Configuration data in YAML, JSON, and other formats stored in the AppConfig hosted configuration store
     * </p>
     * </li>
     * <li>
     * <p>
     * Configuration data stored as objects in an Amazon Simple Storage Service (Amazon S3) bucket
     * </p>
     * </li>
     * <li>
     * <p>
     * Pipelines stored in CodePipeline
     * </p>
     * </li>
     * <li>
     * <p>
     * Secrets stored in Secrets Manager
     * </p>
     * </li>
     * <li>
     * <p>
     * Standard and secure string parameters stored in Amazon Web Services Systems Manager Parameter Store
     * </p>
     * </li>
     * <li>
     * <p>
     * Configuration data in SSM documents stored in the Systems Manager document store
     * </p>
     * </li>
     * </ul>
     * <p>
     * A configuration profile includes the following information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The URI location of the configuration data.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Identity and Access Management (IAM) role that provides access to the configuration data.
     * </p>
     * </li>
     * <li>
     * <p>
     * A validator for the configuration data. Available validators include either a JSON Schema or an Amazon Web
     * Services Lambda function.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-configuration-and-profile.html"
     * >Create a Configuration and a Configuration Profile</a> in the <i>AppConfig User Guide</i>.
     * </p>
     *
     * @param createConfigurationProfileRequest
     * @return A Java Future containing the result of the CreateConfigurationProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>ServiceQuotaExceededException The number of one more AppConfig resources exceeds the maximum allowed.
     *         Verify that your environment doesn't exceed the following service quotas:</p>
     *         <p>
     *         Applications: 100 max
     *         </p>
     *         <p>
     *         Deployment strategies: 20 max
     *         </p>
     *         <p>
     *         Configuration profiles: 100 max per application
     *         </p>
     *         <p>
     *         Environments: 20 max per application
     *         </p>
     *         <p>
     *         To resolve this issue, you can delete one or more resources and try again. Or, you can request a quota
     *         increase. For more information about quotas and to request an increase, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/appconfig.html#limits_appconfig">Service quotas for
     *         AppConfig</a> in the Amazon Web Services General Reference.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.CreateConfigurationProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateConfigurationProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConfigurationProfileResponse> createConfigurationProfile(
            CreateConfigurationProfileRequest createConfigurationProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a configuration profile, which is information that enables AppConfig to access the configuration source.
     * Valid configuration sources include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Configuration data in YAML, JSON, and other formats stored in the AppConfig hosted configuration store
     * </p>
     * </li>
     * <li>
     * <p>
     * Configuration data stored as objects in an Amazon Simple Storage Service (Amazon S3) bucket
     * </p>
     * </li>
     * <li>
     * <p>
     * Pipelines stored in CodePipeline
     * </p>
     * </li>
     * <li>
     * <p>
     * Secrets stored in Secrets Manager
     * </p>
     * </li>
     * <li>
     * <p>
     * Standard and secure string parameters stored in Amazon Web Services Systems Manager Parameter Store
     * </p>
     * </li>
     * <li>
     * <p>
     * Configuration data in SSM documents stored in the Systems Manager document store
     * </p>
     * </li>
     * </ul>
     * <p>
     * A configuration profile includes the following information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The URI location of the configuration data.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Identity and Access Management (IAM) role that provides access to the configuration data.
     * </p>
     * </li>
     * <li>
     * <p>
     * A validator for the configuration data. Available validators include either a JSON Schema or an Amazon Web
     * Services Lambda function.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-configuration-and-profile.html"
     * >Create a Configuration and a Configuration Profile</a> in the <i>AppConfig User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfigurationProfileRequest.Builder} avoiding
     * the need to create one manually via {@link CreateConfigurationProfileRequest#builder()}
     * </p>
     *
     * @param createConfigurationProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.CreateConfigurationProfileRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateConfigurationProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>ServiceQuotaExceededException The number of one more AppConfig resources exceeds the maximum allowed.
     *         Verify that your environment doesn't exceed the following service quotas:</p>
     *         <p>
     *         Applications: 100 max
     *         </p>
     *         <p>
     *         Deployment strategies: 20 max
     *         </p>
     *         <p>
     *         Configuration profiles: 100 max per application
     *         </p>
     *         <p>
     *         Environments: 20 max per application
     *         </p>
     *         <p>
     *         To resolve this issue, you can delete one or more resources and try again. Or, you can request a quota
     *         increase. For more information about quotas and to request an increase, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/appconfig.html#limits_appconfig">Service quotas for
     *         AppConfig</a> in the Amazon Web Services General Reference.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.CreateConfigurationProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateConfigurationProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConfigurationProfileResponse> createConfigurationProfile(
            Consumer<CreateConfigurationProfileRequest.Builder> createConfigurationProfileRequest) {
        return createConfigurationProfile(CreateConfigurationProfileRequest.builder()
                .applyMutation(createConfigurationProfileRequest).build());
    }

    /**
     * <p>
     * Creates a deployment strategy that defines important criteria for rolling out your configuration to the
     * designated targets. A deployment strategy includes the overall duration required, a percentage of targets to
     * receive the deployment during each interval, an algorithm that defines how percentage grows, and bake time.
     * </p>
     *
     * @param createDeploymentStrategyRequest
     * @return A Java Future containing the result of the CreateDeploymentStrategy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>ServiceQuotaExceededException The number of one more AppConfig resources exceeds the maximum allowed.
     *         Verify that your environment doesn't exceed the following service quotas:</p>
     *         <p>
     *         Applications: 100 max
     *         </p>
     *         <p>
     *         Deployment strategies: 20 max
     *         </p>
     *         <p>
     *         Configuration profiles: 100 max per application
     *         </p>
     *         <p>
     *         Environments: 20 max per application
     *         </p>
     *         <p>
     *         To resolve this issue, you can delete one or more resources and try again. Or, you can request a quota
     *         increase. For more information about quotas and to request an increase, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/appconfig.html#limits_appconfig">Service quotas for
     *         AppConfig</a> in the Amazon Web Services General Reference.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.CreateDeploymentStrategy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateDeploymentStrategy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDeploymentStrategyResponse> createDeploymentStrategy(
            CreateDeploymentStrategyRequest createDeploymentStrategyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a deployment strategy that defines important criteria for rolling out your configuration to the
     * designated targets. A deployment strategy includes the overall duration required, a percentage of targets to
     * receive the deployment during each interval, an algorithm that defines how percentage grows, and bake time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeploymentStrategyRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDeploymentStrategyRequest#builder()}
     * </p>
     *
     * @param createDeploymentStrategyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.CreateDeploymentStrategyRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateDeploymentStrategy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>ServiceQuotaExceededException The number of one more AppConfig resources exceeds the maximum allowed.
     *         Verify that your environment doesn't exceed the following service quotas:</p>
     *         <p>
     *         Applications: 100 max
     *         </p>
     *         <p>
     *         Deployment strategies: 20 max
     *         </p>
     *         <p>
     *         Configuration profiles: 100 max per application
     *         </p>
     *         <p>
     *         Environments: 20 max per application
     *         </p>
     *         <p>
     *         To resolve this issue, you can delete one or more resources and try again. Or, you can request a quota
     *         increase. For more information about quotas and to request an increase, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/appconfig.html#limits_appconfig">Service quotas for
     *         AppConfig</a> in the Amazon Web Services General Reference.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.CreateDeploymentStrategy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateDeploymentStrategy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDeploymentStrategyResponse> createDeploymentStrategy(
            Consumer<CreateDeploymentStrategyRequest.Builder> createDeploymentStrategyRequest) {
        return createDeploymentStrategy(CreateDeploymentStrategyRequest.builder().applyMutation(createDeploymentStrategyRequest)
                .build());
    }

    /**
     * <p>
     * Creates an environment. For each application, you define one or more environments. An environment is a deployment
     * group of AppConfig targets, such as applications in a <code>Beta</code> or <code>Production</code> environment.
     * You can also define environments for application subcomponents such as the <code>Web</code>, <code>Mobile</code>
     * and <code>Back-end</code> components for your application. You can configure Amazon CloudWatch alarms for each
     * environment. The system monitors alarms during a configuration deployment. If an alarm is triggered, the system
     * rolls back the configuration.
     * </p>
     *
     * @param createEnvironmentRequest
     * @return A Java Future containing the result of the CreateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ServiceQuotaExceededException The number of one more AppConfig resources exceeds the maximum allowed.
     *         Verify that your environment doesn't exceed the following service quotas:</p>
     *         <p>
     *         Applications: 100 max
     *         </p>
     *         <p>
     *         Deployment strategies: 20 max
     *         </p>
     *         <p>
     *         Configuration profiles: 100 max per application
     *         </p>
     *         <p>
     *         Environments: 20 max per application
     *         </p>
     *         <p>
     *         To resolve this issue, you can delete one or more resources and try again. Or, you can request a quota
     *         increase. For more information about quotas and to request an increase, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/appconfig.html#limits_appconfig">Service quotas for
     *         AppConfig</a> in the Amazon Web Services General Reference.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.CreateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentResponse> createEnvironment(CreateEnvironmentRequest createEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an environment. For each application, you define one or more environments. An environment is a deployment
     * group of AppConfig targets, such as applications in a <code>Beta</code> or <code>Production</code> environment.
     * You can also define environments for application subcomponents such as the <code>Web</code>, <code>Mobile</code>
     * and <code>Back-end</code> components for your application. You can configure Amazon CloudWatch alarms for each
     * environment. The system monitors alarms during a configuration deployment. If an alarm is triggered, the system
     * rolls back the configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateEnvironmentRequest#builder()}
     * </p>
     *
     * @param createEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.CreateEnvironmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ServiceQuotaExceededException The number of one more AppConfig resources exceeds the maximum allowed.
     *         Verify that your environment doesn't exceed the following service quotas:</p>
     *         <p>
     *         Applications: 100 max
     *         </p>
     *         <p>
     *         Deployment strategies: 20 max
     *         </p>
     *         <p>
     *         Configuration profiles: 100 max per application
     *         </p>
     *         <p>
     *         Environments: 20 max per application
     *         </p>
     *         <p>
     *         To resolve this issue, you can delete one or more resources and try again. Or, you can request a quota
     *         increase. For more information about quotas and to request an increase, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/appconfig.html#limits_appconfig">Service quotas for
     *         AppConfig</a> in the Amazon Web Services General Reference.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.CreateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentResponse> createEnvironment(
            Consumer<CreateEnvironmentRequest.Builder> createEnvironmentRequest) {
        return createEnvironment(CreateEnvironmentRequest.builder().applyMutation(createEnvironmentRequest).build());
    }

    /**
     * <p>
     * Creates an AppConfig extension. An extension augments your ability to inject logic or behavior at different
     * points during the AppConfig workflow of creating or deploying a configuration.
     * </p>
     * <p>
     * You can create your own extensions or use the Amazon Web Services authored extensions provided by AppConfig. For
     * an AppConfig extension that uses Lambda, you must create a Lambda function to perform any computation and
     * processing defined in the extension. If you plan to create custom versions of the Amazon Web Services authored
     * notification extensions, you only need to specify an Amazon Resource Name (ARN) in the <code>Uri</code> field for
     * the new extension version.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For a custom EventBridge notification extension, enter the ARN of the EventBridge default events in the
     * <code>Uri</code> field.
     * </p>
     * </li>
     * <li>
     * <p>
     * For a custom Amazon SNS notification extension, enter the ARN of an Amazon SNS topic in the <code>Uri</code>
     * field.
     * </p>
     * </li>
     * <li>
     * <p>
     * For a custom Amazon SQS notification extension, enter the ARN of an Amazon SQS message queue in the
     * <code>Uri</code> field.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about extensions, see <a
     * href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html">Extending
     * workflows</a> in the <i>AppConfig User Guide</i>.
     * </p>
     *
     * @param createExtensionRequest
     * @return A Java Future containing the result of the CreateExtension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ServiceQuotaExceededException The number of one more AppConfig resources exceeds the maximum allowed.
     *         Verify that your environment doesn't exceed the following service quotas:</p>
     *         <p>
     *         Applications: 100 max
     *         </p>
     *         <p>
     *         Deployment strategies: 20 max
     *         </p>
     *         <p>
     *         Configuration profiles: 100 max per application
     *         </p>
     *         <p>
     *         Environments: 20 max per application
     *         </p>
     *         <p>
     *         To resolve this issue, you can delete one or more resources and try again. Or, you can request a quota
     *         increase. For more information about quotas and to request an increase, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/appconfig.html#limits_appconfig">Service quotas for
     *         AppConfig</a> in the Amazon Web Services General Reference.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.CreateExtension
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateExtension" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateExtensionResponse> createExtension(CreateExtensionRequest createExtensionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AppConfig extension. An extension augments your ability to inject logic or behavior at different
     * points during the AppConfig workflow of creating or deploying a configuration.
     * </p>
     * <p>
     * You can create your own extensions or use the Amazon Web Services authored extensions provided by AppConfig. For
     * an AppConfig extension that uses Lambda, you must create a Lambda function to perform any computation and
     * processing defined in the extension. If you plan to create custom versions of the Amazon Web Services authored
     * notification extensions, you only need to specify an Amazon Resource Name (ARN) in the <code>Uri</code> field for
     * the new extension version.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For a custom EventBridge notification extension, enter the ARN of the EventBridge default events in the
     * <code>Uri</code> field.
     * </p>
     * </li>
     * <li>
     * <p>
     * For a custom Amazon SNS notification extension, enter the ARN of an Amazon SNS topic in the <code>Uri</code>
     * field.
     * </p>
     * </li>
     * <li>
     * <p>
     * For a custom Amazon SQS notification extension, enter the ARN of an Amazon SQS message queue in the
     * <code>Uri</code> field.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about extensions, see <a
     * href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html">Extending
     * workflows</a> in the <i>AppConfig User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateExtensionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateExtensionRequest#builder()}
     * </p>
     *
     * @param createExtensionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.CreateExtensionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateExtension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ServiceQuotaExceededException The number of one more AppConfig resources exceeds the maximum allowed.
     *         Verify that your environment doesn't exceed the following service quotas:</p>
     *         <p>
     *         Applications: 100 max
     *         </p>
     *         <p>
     *         Deployment strategies: 20 max
     *         </p>
     *         <p>
     *         Configuration profiles: 100 max per application
     *         </p>
     *         <p>
     *         Environments: 20 max per application
     *         </p>
     *         <p>
     *         To resolve this issue, you can delete one or more resources and try again. Or, you can request a quota
     *         increase. For more information about quotas and to request an increase, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/appconfig.html#limits_appconfig">Service quotas for
     *         AppConfig</a> in the Amazon Web Services General Reference.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.CreateExtension
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateExtension" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateExtensionResponse> createExtension(
            Consumer<CreateExtensionRequest.Builder> createExtensionRequest) {
        return createExtension(CreateExtensionRequest.builder().applyMutation(createExtensionRequest).build());
    }

    /**
     * <p>
     * When you create an extension or configure an Amazon Web Services authored extension, you associate the extension
     * with an AppConfig application, environment, or configuration profile. For example, you can choose to run the
     * <code>AppConfig deployment events to Amazon SNS</code> Amazon Web Services authored extension and receive
     * notifications on an Amazon SNS topic anytime a configuration deployment is started for a specific application.
     * Defining which extension to associate with an AppConfig resource is called an <i>extension association</i>. An
     * extension association is a specified relationship between an extension and an AppConfig resource, such as an
     * application or a configuration profile. For more information about extensions and associations, see <a
     * href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html">Extending
     * workflows</a> in the <i>AppConfig User Guide</i>.
     * </p>
     *
     * @param createExtensionAssociationRequest
     * @return A Java Future containing the result of the CreateExtensionAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>ServiceQuotaExceededException The number of one more AppConfig resources exceeds the maximum allowed.
     *         Verify that your environment doesn't exceed the following service quotas:</p>
     *         <p>
     *         Applications: 100 max
     *         </p>
     *         <p>
     *         Deployment strategies: 20 max
     *         </p>
     *         <p>
     *         Configuration profiles: 100 max per application
     *         </p>
     *         <p>
     *         Environments: 20 max per application
     *         </p>
     *         <p>
     *         To resolve this issue, you can delete one or more resources and try again. Or, you can request a quota
     *         increase. For more information about quotas and to request an increase, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/appconfig.html#limits_appconfig">Service quotas for
     *         AppConfig</a> in the Amazon Web Services General Reference.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.CreateExtensionAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateExtensionAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateExtensionAssociationResponse> createExtensionAssociation(
            CreateExtensionAssociationRequest createExtensionAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * When you create an extension or configure an Amazon Web Services authored extension, you associate the extension
     * with an AppConfig application, environment, or configuration profile. For example, you can choose to run the
     * <code>AppConfig deployment events to Amazon SNS</code> Amazon Web Services authored extension and receive
     * notifications on an Amazon SNS topic anytime a configuration deployment is started for a specific application.
     * Defining which extension to associate with an AppConfig resource is called an <i>extension association</i>. An
     * extension association is a specified relationship between an extension and an AppConfig resource, such as an
     * application or a configuration profile. For more information about extensions and associations, see <a
     * href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html">Extending
     * workflows</a> in the <i>AppConfig User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateExtensionAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateExtensionAssociationRequest#builder()}
     * </p>
     *
     * @param createExtensionAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.CreateExtensionAssociationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateExtensionAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>ServiceQuotaExceededException The number of one more AppConfig resources exceeds the maximum allowed.
     *         Verify that your environment doesn't exceed the following service quotas:</p>
     *         <p>
     *         Applications: 100 max
     *         </p>
     *         <p>
     *         Deployment strategies: 20 max
     *         </p>
     *         <p>
     *         Configuration profiles: 100 max per application
     *         </p>
     *         <p>
     *         Environments: 20 max per application
     *         </p>
     *         <p>
     *         To resolve this issue, you can delete one or more resources and try again. Or, you can request a quota
     *         increase. For more information about quotas and to request an increase, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/appconfig.html#limits_appconfig">Service quotas for
     *         AppConfig</a> in the Amazon Web Services General Reference.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.CreateExtensionAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateExtensionAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateExtensionAssociationResponse> createExtensionAssociation(
            Consumer<CreateExtensionAssociationRequest.Builder> createExtensionAssociationRequest) {
        return createExtensionAssociation(CreateExtensionAssociationRequest.builder()
                .applyMutation(createExtensionAssociationRequest).build());
    }

    /**
     * <p>
     * Creates a new configuration in the AppConfig hosted configuration store.
     * </p>
     *
     * @param createHostedConfigurationVersionRequest
     * @return A Java Future containing the result of the CreateHostedConfigurationVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ServiceQuotaExceededException The number of one more AppConfig resources exceeds the maximum allowed.
     *         Verify that your environment doesn't exceed the following service quotas:</p>
     *         <p>
     *         Applications: 100 max
     *         </p>
     *         <p>
     *         Deployment strategies: 20 max
     *         </p>
     *         <p>
     *         Configuration profiles: 100 max per application
     *         </p>
     *         <p>
     *         Environments: 20 max per application
     *         </p>
     *         <p>
     *         To resolve this issue, you can delete one or more resources and try again. Or, you can request a quota
     *         increase. For more information about quotas and to request an increase, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/appconfig.html#limits_appconfig">Service quotas for
     *         AppConfig</a> in the Amazon Web Services General Reference.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>PayloadTooLargeException The configuration size is too large.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.CreateHostedConfigurationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateHostedConfigurationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateHostedConfigurationVersionResponse> createHostedConfigurationVersion(
            CreateHostedConfigurationVersionRequest createHostedConfigurationVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new configuration in the AppConfig hosted configuration store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHostedConfigurationVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateHostedConfigurationVersionRequest#builder()}
     * </p>
     *
     * @param createHostedConfigurationVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.CreateHostedConfigurationVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateHostedConfigurationVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ServiceQuotaExceededException The number of one more AppConfig resources exceeds the maximum allowed.
     *         Verify that your environment doesn't exceed the following service quotas:</p>
     *         <p>
     *         Applications: 100 max
     *         </p>
     *         <p>
     *         Deployment strategies: 20 max
     *         </p>
     *         <p>
     *         Configuration profiles: 100 max per application
     *         </p>
     *         <p>
     *         Environments: 20 max per application
     *         </p>
     *         <p>
     *         To resolve this issue, you can delete one or more resources and try again. Or, you can request a quota
     *         increase. For more information about quotas and to request an increase, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/appconfig.html#limits_appconfig">Service quotas for
     *         AppConfig</a> in the Amazon Web Services General Reference.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>PayloadTooLargeException The configuration size is too large.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.CreateHostedConfigurationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateHostedConfigurationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateHostedConfigurationVersionResponse> createHostedConfigurationVersion(
            Consumer<CreateHostedConfigurationVersionRequest.Builder> createHostedConfigurationVersionRequest) {
        return createHostedConfigurationVersion(CreateHostedConfigurationVersionRequest.builder()
                .applyMutation(createHostedConfigurationVersionRequest).build());
    }

    /**
     * <p>
     * Deletes an application. Deleting an application does not delete a configuration from a host.
     * </p>
     *
     * @param deleteApplicationRequest
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an application. Deleting an application does not delete a configuration from a host.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteApplicationRequest#builder()}
     * </p>
     *
     * @param deleteApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.DeleteApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationResponse> deleteApplication(
            Consumer<DeleteApplicationRequest.Builder> deleteApplicationRequest) {
        return deleteApplication(DeleteApplicationRequest.builder().applyMutation(deleteApplicationRequest).build());
    }

    /**
     * <p>
     * Deletes a configuration profile. Deleting a configuration profile does not delete a configuration from a host.
     * </p>
     *
     * @param deleteConfigurationProfileRequest
     * @return A Java Future containing the result of the DeleteConfigurationProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.DeleteConfigurationProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteConfigurationProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationProfileResponse> deleteConfigurationProfile(
            DeleteConfigurationProfileRequest deleteConfigurationProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a configuration profile. Deleting a configuration profile does not delete a configuration from a host.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigurationProfileRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteConfigurationProfileRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.DeleteConfigurationProfileRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteConfigurationProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.DeleteConfigurationProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteConfigurationProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationProfileResponse> deleteConfigurationProfile(
            Consumer<DeleteConfigurationProfileRequest.Builder> deleteConfigurationProfileRequest) {
        return deleteConfigurationProfile(DeleteConfigurationProfileRequest.builder()
                .applyMutation(deleteConfigurationProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a deployment strategy. Deleting a deployment strategy does not delete a configuration from a host.
     * </p>
     *
     * @param deleteDeploymentStrategyRequest
     * @return A Java Future containing the result of the DeleteDeploymentStrategy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.DeleteDeploymentStrategy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteDeploymentStrategy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDeploymentStrategyResponse> deleteDeploymentStrategy(
            DeleteDeploymentStrategyRequest deleteDeploymentStrategyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a deployment strategy. Deleting a deployment strategy does not delete a configuration from a host.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeploymentStrategyRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDeploymentStrategyRequest#builder()}
     * </p>
     *
     * @param deleteDeploymentStrategyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.DeleteDeploymentStrategyRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteDeploymentStrategy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.DeleteDeploymentStrategy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteDeploymentStrategy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDeploymentStrategyResponse> deleteDeploymentStrategy(
            Consumer<DeleteDeploymentStrategyRequest.Builder> deleteDeploymentStrategyRequest) {
        return deleteDeploymentStrategy(DeleteDeploymentStrategyRequest.builder().applyMutation(deleteDeploymentStrategyRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an environment. Deleting an environment does not delete a configuration from a host.
     * </p>
     *
     * @param deleteEnvironmentRequest
     * @return A Java Future containing the result of the DeleteEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.DeleteEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentResponse> deleteEnvironment(DeleteEnvironmentRequest deleteEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an environment. Deleting an environment does not delete a configuration from a host.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteEnvironmentRequest#builder()}
     * </p>
     *
     * @param deleteEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.DeleteEnvironmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.DeleteEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentResponse> deleteEnvironment(
            Consumer<DeleteEnvironmentRequest.Builder> deleteEnvironmentRequest) {
        return deleteEnvironment(DeleteEnvironmentRequest.builder().applyMutation(deleteEnvironmentRequest).build());
    }

    /**
     * <p>
     * Deletes an AppConfig extension. You must delete all associations to an extension before you delete the extension.
     * </p>
     *
     * @param deleteExtensionRequest
     * @return A Java Future containing the result of the DeleteExtension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.DeleteExtension
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteExtension" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteExtensionResponse> deleteExtension(DeleteExtensionRequest deleteExtensionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an AppConfig extension. You must delete all associations to an extension before you delete the extension.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteExtensionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteExtensionRequest#builder()}
     * </p>
     *
     * @param deleteExtensionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.DeleteExtensionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteExtension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.DeleteExtension
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteExtension" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteExtensionResponse> deleteExtension(
            Consumer<DeleteExtensionRequest.Builder> deleteExtensionRequest) {
        return deleteExtension(DeleteExtensionRequest.builder().applyMutation(deleteExtensionRequest).build());
    }

    /**
     * <p>
     * Deletes an extension association. This action doesn't delete extensions defined in the association.
     * </p>
     *
     * @param deleteExtensionAssociationRequest
     * @return A Java Future containing the result of the DeleteExtensionAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.DeleteExtensionAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteExtensionAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteExtensionAssociationResponse> deleteExtensionAssociation(
            DeleteExtensionAssociationRequest deleteExtensionAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an extension association. This action doesn't delete extensions defined in the association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteExtensionAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteExtensionAssociationRequest#builder()}
     * </p>
     *
     * @param deleteExtensionAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.DeleteExtensionAssociationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteExtensionAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.DeleteExtensionAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteExtensionAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteExtensionAssociationResponse> deleteExtensionAssociation(
            Consumer<DeleteExtensionAssociationRequest.Builder> deleteExtensionAssociationRequest) {
        return deleteExtensionAssociation(DeleteExtensionAssociationRequest.builder()
                .applyMutation(deleteExtensionAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes a version of a configuration from the AppConfig hosted configuration store.
     * </p>
     *
     * @param deleteHostedConfigurationVersionRequest
     * @return A Java Future containing the result of the DeleteHostedConfigurationVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.DeleteHostedConfigurationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteHostedConfigurationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteHostedConfigurationVersionResponse> deleteHostedConfigurationVersion(
            DeleteHostedConfigurationVersionRequest deleteHostedConfigurationVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a version of a configuration from the AppConfig hosted configuration store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHostedConfigurationVersionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteHostedConfigurationVersionRequest#builder()}
     * </p>
     *
     * @param deleteHostedConfigurationVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.DeleteHostedConfigurationVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteHostedConfigurationVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.DeleteHostedConfigurationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteHostedConfigurationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteHostedConfigurationVersionResponse> deleteHostedConfigurationVersion(
            Consumer<DeleteHostedConfigurationVersionRequest.Builder> deleteHostedConfigurationVersionRequest) {
        return deleteHostedConfigurationVersion(DeleteHostedConfigurationVersionRequest.builder()
                .applyMutation(deleteHostedConfigurationVersionRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an application.
     * </p>
     *
     * @param getApplicationRequest
     * @return A Java Future containing the result of the GetApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetApplicationResponse> getApplication(GetApplicationRequest getApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationRequest.Builder} avoiding the need to
     * create one manually via {@link GetApplicationRequest#builder()}
     * </p>
     *
     * @param getApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.GetApplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetApplicationResponse> getApplication(Consumer<GetApplicationRequest.Builder> getApplicationRequest) {
        return getApplication(GetApplicationRequest.builder().applyMutation(getApplicationRequest).build());
    }

    /**
     * <p>
     * (Deprecated) Retrieves the latest deployed configuration.
     * </p>
     * <important>
     * <p>
     * Note the following important information.
     * </p>
     * <ul>
     * <li>
     * <p>
     * This API action is deprecated. Calls to receive configuration data should use the <a href=
     * "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_StartConfigurationSession.html"
     * >StartConfigurationSession</a> and <a href=
     * "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
     * >GetLatestConfiguration</a> APIs instead.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GetConfiguration</code> is a priced call. For more information, see <a
     * href="https://aws.amazon.com/systems-manager/pricing/">Pricing</a>.
     * </p>
     * </li>
     * </ul>
     * </important>
     *
     * @param getConfigurationRequest
     * @return A Java Future containing the result of the GetConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.GetConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetConfiguration" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This API has been deprecated in favor of the GetLatestConfiguration API used in conjunction with
     *             StartConfigurationSession.
     */
    @Deprecated
    default CompletableFuture<GetConfigurationResponse> getConfiguration(GetConfigurationRequest getConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * (Deprecated) Retrieves the latest deployed configuration.
     * </p>
     * <important>
     * <p>
     * Note the following important information.
     * </p>
     * <ul>
     * <li>
     * <p>
     * This API action is deprecated. Calls to receive configuration data should use the <a href=
     * "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_StartConfigurationSession.html"
     * >StartConfigurationSession</a> and <a href=
     * "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
     * >GetLatestConfiguration</a> APIs instead.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GetConfiguration</code> is a priced call. For more information, see <a
     * href="https://aws.amazon.com/systems-manager/pricing/">Pricing</a>.
     * </p>
     * </li>
     * </ul>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfigurationRequest.Builder} avoiding the need
     * to create one manually via {@link GetConfigurationRequest#builder()}
     * </p>
     *
     * @param getConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.GetConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.GetConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetConfiguration" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This API has been deprecated in favor of the GetLatestConfiguration API used in conjunction with
     *             StartConfigurationSession.
     */
    @Deprecated
    default CompletableFuture<GetConfigurationResponse> getConfiguration(
            Consumer<GetConfigurationRequest.Builder> getConfigurationRequest) {
        return getConfiguration(GetConfigurationRequest.builder().applyMutation(getConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a configuration profile.
     * </p>
     *
     * @param getConfigurationProfileRequest
     * @return A Java Future containing the result of the GetConfigurationProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.GetConfigurationProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetConfigurationProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConfigurationProfileResponse> getConfigurationProfile(
            GetConfigurationProfileRequest getConfigurationProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a configuration profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfigurationProfileRequest.Builder} avoiding
     * the need to create one manually via {@link GetConfigurationProfileRequest#builder()}
     * </p>
     *
     * @param getConfigurationProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.GetConfigurationProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetConfigurationProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.GetConfigurationProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetConfigurationProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConfigurationProfileResponse> getConfigurationProfile(
            Consumer<GetConfigurationProfileRequest.Builder> getConfigurationProfileRequest) {
        return getConfigurationProfile(GetConfigurationProfileRequest.builder().applyMutation(getConfigurationProfileRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about a configuration deployment.
     * </p>
     *
     * @param getDeploymentRequest
     * @return A Java Future containing the result of the GetDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.GetDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDeploymentResponse> getDeployment(GetDeploymentRequest getDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a configuration deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeploymentRequest#builder()}
     * </p>
     *
     * @param getDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.GetDeploymentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.GetDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDeploymentResponse> getDeployment(Consumer<GetDeploymentRequest.Builder> getDeploymentRequest) {
        return getDeployment(GetDeploymentRequest.builder().applyMutation(getDeploymentRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a deployment strategy. A deployment strategy defines important criteria for rolling
     * out your configuration to the designated targets. A deployment strategy includes the overall duration required, a
     * percentage of targets to receive the deployment during each interval, an algorithm that defines how percentage
     * grows, and bake time.
     * </p>
     *
     * @param getDeploymentStrategyRequest
     * @return A Java Future containing the result of the GetDeploymentStrategy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.GetDeploymentStrategy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetDeploymentStrategy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeploymentStrategyResponse> getDeploymentStrategy(
            GetDeploymentStrategyRequest getDeploymentStrategyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a deployment strategy. A deployment strategy defines important criteria for rolling
     * out your configuration to the designated targets. A deployment strategy includes the overall duration required, a
     * percentage of targets to receive the deployment during each interval, an algorithm that defines how percentage
     * grows, and bake time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentStrategyRequest.Builder} avoiding the
     * need to create one manually via {@link GetDeploymentStrategyRequest#builder()}
     * </p>
     *
     * @param getDeploymentStrategyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.GetDeploymentStrategyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDeploymentStrategy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.GetDeploymentStrategy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetDeploymentStrategy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeploymentStrategyResponse> getDeploymentStrategy(
            Consumer<GetDeploymentStrategyRequest.Builder> getDeploymentStrategyRequest) {
        return getDeploymentStrategy(GetDeploymentStrategyRequest.builder().applyMutation(getDeploymentStrategyRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an environment. An environment is a deployment group of AppConfig applications, such
     * as applications in a <code>Production</code> environment or in an <code>EU_Region</code> environment. Each
     * configuration deployment targets an environment. You can enable one or more Amazon CloudWatch alarms for an
     * environment. If an alarm is triggered during a deployment, AppConfig roles back the configuration.
     * </p>
     *
     * @param getEnvironmentRequest
     * @return A Java Future containing the result of the GetEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.GetEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEnvironmentResponse> getEnvironment(GetEnvironmentRequest getEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an environment. An environment is a deployment group of AppConfig applications, such
     * as applications in a <code>Production</code> environment or in an <code>EU_Region</code> environment. Each
     * configuration deployment targets an environment. You can enable one or more Amazon CloudWatch alarms for an
     * environment. If an alarm is triggered during a deployment, AppConfig roles back the configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnvironmentRequest.Builder} avoiding the need to
     * create one manually via {@link GetEnvironmentRequest#builder()}
     * </p>
     *
     * @param getEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.GetEnvironmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.GetEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEnvironmentResponse> getEnvironment(Consumer<GetEnvironmentRequest.Builder> getEnvironmentRequest) {
        return getEnvironment(GetEnvironmentRequest.builder().applyMutation(getEnvironmentRequest).build());
    }

    /**
     * <p>
     * Returns information about an AppConfig extension.
     * </p>
     *
     * @param getExtensionRequest
     * @return A Java Future containing the result of the GetExtension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.GetExtension
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetExtension" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetExtensionResponse> getExtension(GetExtensionRequest getExtensionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an AppConfig extension.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExtensionRequest.Builder} avoiding the need to
     * create one manually via {@link GetExtensionRequest#builder()}
     * </p>
     *
     * @param getExtensionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.GetExtensionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetExtension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.GetExtension
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetExtension" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetExtensionResponse> getExtension(Consumer<GetExtensionRequest.Builder> getExtensionRequest) {
        return getExtension(GetExtensionRequest.builder().applyMutation(getExtensionRequest).build());
    }

    /**
     * <p>
     * Returns information about an AppConfig extension association. For more information about extensions and
     * associations, see <a
     * href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html">Extending
     * workflows</a> in the <i>AppConfig User Guide</i>.
     * </p>
     *
     * @param getExtensionAssociationRequest
     * @return A Java Future containing the result of the GetExtensionAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.GetExtensionAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetExtensionAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetExtensionAssociationResponse> getExtensionAssociation(
            GetExtensionAssociationRequest getExtensionAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an AppConfig extension association. For more information about extensions and
     * associations, see <a
     * href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html">Extending
     * workflows</a> in the <i>AppConfig User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExtensionAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link GetExtensionAssociationRequest#builder()}
     * </p>
     *
     * @param getExtensionAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.GetExtensionAssociationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetExtensionAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.GetExtensionAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetExtensionAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetExtensionAssociationResponse> getExtensionAssociation(
            Consumer<GetExtensionAssociationRequest.Builder> getExtensionAssociationRequest) {
        return getExtensionAssociation(GetExtensionAssociationRequest.builder().applyMutation(getExtensionAssociationRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about a specific configuration version.
     * </p>
     *
     * @param getHostedConfigurationVersionRequest
     * @return A Java Future containing the result of the GetHostedConfigurationVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.GetHostedConfigurationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetHostedConfigurationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetHostedConfigurationVersionResponse> getHostedConfigurationVersion(
            GetHostedConfigurationVersionRequest getHostedConfigurationVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specific configuration version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetHostedConfigurationVersionRequest.Builder}
     * avoiding the need to create one manually via {@link GetHostedConfigurationVersionRequest#builder()}
     * </p>
     *
     * @param getHostedConfigurationVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.GetHostedConfigurationVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetHostedConfigurationVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.GetHostedConfigurationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetHostedConfigurationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetHostedConfigurationVersionResponse> getHostedConfigurationVersion(
            Consumer<GetHostedConfigurationVersionRequest.Builder> getHostedConfigurationVersionRequest) {
        return getHostedConfigurationVersion(GetHostedConfigurationVersionRequest.builder()
                .applyMutation(getHostedConfigurationVersionRequest).build());
    }

    /**
     * <p>
     * Lists all applications in your Amazon Web Services account.
     * </p>
     *
     * @param listApplicationsRequest
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(ListApplicationsRequest listApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all applications in your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.ListApplicationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(
            Consumer<ListApplicationsRequest.Builder> listApplicationsRequest) {
        return listApplications(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.appconfig.model.ListApplicationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appconfig.model.ListApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appconfig.model.ListApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.appconfig.model.ListApplicationsRequest)} operation.</b>
     * </p>
     *
     * @param listApplicationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApplicationsPublisher listApplicationsPaginator(ListApplicationsRequest listApplicationsRequest) {
        return new ListApplicationsPublisher(this, listApplicationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.appconfig.model.ListApplicationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appconfig.model.ListApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appconfig.model.ListApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.appconfig.model.ListApplicationsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.ListApplicationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApplicationsPublisher listApplicationsPaginator(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest) {
        return listApplicationsPaginator(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Lists the configuration profiles for an application.
     * </p>
     *
     * @param listConfigurationProfilesRequest
     * @return A Java Future containing the result of the ListConfigurationProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListConfigurationProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListConfigurationProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConfigurationProfilesResponse> listConfigurationProfiles(
            ListConfigurationProfilesRequest listConfigurationProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the configuration profiles for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationProfilesRequest.Builder} avoiding
     * the need to create one manually via {@link ListConfigurationProfilesRequest#builder()}
     * </p>
     *
     * @param listConfigurationProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListConfigurationProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListConfigurationProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListConfigurationProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConfigurationProfilesResponse> listConfigurationProfiles(
            Consumer<ListConfigurationProfilesRequest.Builder> listConfigurationProfilesRequest) {
        return listConfigurationProfiles(ListConfigurationProfilesRequest.builder()
                .applyMutation(listConfigurationProfilesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurationProfiles(software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListConfigurationProfilesPublisher publisher = client.listConfigurationProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListConfigurationProfilesPublisher publisher = client.listConfigurationProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationProfiles(software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConfigurationProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListConfigurationProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListConfigurationProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationProfilesPublisher listConfigurationProfilesPaginator(
            ListConfigurationProfilesRequest listConfigurationProfilesRequest) {
        return new ListConfigurationProfilesPublisher(this, listConfigurationProfilesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurationProfiles(software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListConfigurationProfilesPublisher publisher = client.listConfigurationProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListConfigurationProfilesPublisher publisher = client.listConfigurationProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationProfiles(software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationProfilesRequest.Builder} avoiding
     * the need to create one manually via {@link ListConfigurationProfilesRequest#builder()}
     * </p>
     *
     * @param listConfigurationProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListConfigurationProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListConfigurationProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationProfilesPublisher listConfigurationProfilesPaginator(
            Consumer<ListConfigurationProfilesRequest.Builder> listConfigurationProfilesRequest) {
        return listConfigurationProfilesPaginator(ListConfigurationProfilesRequest.builder()
                .applyMutation(listConfigurationProfilesRequest).build());
    }

    /**
     * <p>
     * Lists deployment strategies.
     * </p>
     *
     * @param listDeploymentStrategiesRequest
     * @return A Java Future containing the result of the ListDeploymentStrategies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListDeploymentStrategies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListDeploymentStrategies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeploymentStrategiesResponse> listDeploymentStrategies(
            ListDeploymentStrategiesRequest listDeploymentStrategiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists deployment strategies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentStrategiesRequest.Builder} avoiding
     * the need to create one manually via {@link ListDeploymentStrategiesRequest#builder()}
     * </p>
     *
     * @param listDeploymentStrategiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListDeploymentStrategies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListDeploymentStrategies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListDeploymentStrategies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeploymentStrategiesResponse> listDeploymentStrategies(
            Consumer<ListDeploymentStrategiesRequest.Builder> listDeploymentStrategiesRequest) {
        return listDeploymentStrategies(ListDeploymentStrategiesRequest.builder().applyMutation(listDeploymentStrategiesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDeploymentStrategies(software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListDeploymentStrategiesPublisher publisher = client.listDeploymentStrategiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListDeploymentStrategiesPublisher publisher = client.listDeploymentStrategiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeploymentStrategies(software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeploymentStrategiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListDeploymentStrategies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListDeploymentStrategies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentStrategiesPublisher listDeploymentStrategiesPaginator(
            ListDeploymentStrategiesRequest listDeploymentStrategiesRequest) {
        return new ListDeploymentStrategiesPublisher(this, listDeploymentStrategiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDeploymentStrategies(software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListDeploymentStrategiesPublisher publisher = client.listDeploymentStrategiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListDeploymentStrategiesPublisher publisher = client.listDeploymentStrategiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeploymentStrategies(software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentStrategiesRequest.Builder} avoiding
     * the need to create one manually via {@link ListDeploymentStrategiesRequest#builder()}
     * </p>
     *
     * @param listDeploymentStrategiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListDeploymentStrategies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListDeploymentStrategies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentStrategiesPublisher listDeploymentStrategiesPaginator(
            Consumer<ListDeploymentStrategiesRequest.Builder> listDeploymentStrategiesRequest) {
        return listDeploymentStrategiesPaginator(ListDeploymentStrategiesRequest.builder()
                .applyMutation(listDeploymentStrategiesRequest).build());
    }

    /**
     * <p>
     * Lists the deployments for an environment in descending deployment number order.
     * </p>
     *
     * @param listDeploymentsRequest
     * @return A Java Future containing the result of the ListDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListDeployments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDeploymentsResponse> listDeployments(ListDeploymentsRequest listDeploymentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the deployments for an environment in descending deployment number order.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDeploymentsRequest#builder()}
     * </p>
     *
     * @param listDeploymentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.ListDeploymentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListDeployments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDeploymentsResponse> listDeployments(
            Consumer<ListDeploymentsRequest.Builder> listDeploymentsRequest) {
        return listDeployments(ListDeploymentsRequest.builder().applyMutation(listDeploymentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDeployments(software.amazon.awssdk.services.appconfig.model.ListDeploymentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListDeploymentsPublisher publisher = client.listDeploymentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListDeploymentsPublisher publisher = client.listDeploymentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appconfig.model.ListDeploymentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appconfig.model.ListDeploymentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeployments(software.amazon.awssdk.services.appconfig.model.ListDeploymentsRequest)} operation.</b>
     * </p>
     *
     * @param listDeploymentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListDeployments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDeploymentsPublisher listDeploymentsPaginator(ListDeploymentsRequest listDeploymentsRequest) {
        return new ListDeploymentsPublisher(this, listDeploymentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDeployments(software.amazon.awssdk.services.appconfig.model.ListDeploymentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListDeploymentsPublisher publisher = client.listDeploymentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListDeploymentsPublisher publisher = client.listDeploymentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appconfig.model.ListDeploymentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appconfig.model.ListDeploymentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeployments(software.amazon.awssdk.services.appconfig.model.ListDeploymentsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDeploymentsRequest#builder()}
     * </p>
     *
     * @param listDeploymentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.ListDeploymentsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListDeployments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDeploymentsPublisher listDeploymentsPaginator(Consumer<ListDeploymentsRequest.Builder> listDeploymentsRequest) {
        return listDeploymentsPaginator(ListDeploymentsRequest.builder().applyMutation(listDeploymentsRequest).build());
    }

    /**
     * <p>
     * Lists the environments for an application.
     * </p>
     *
     * @param listEnvironmentsRequest
     * @return A Java Future containing the result of the ListEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListEnvironments" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentsResponse> listEnvironments(ListEnvironmentsRequest listEnvironmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the environments for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEnvironmentsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.ListEnvironmentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListEnvironments" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentsResponse> listEnvironments(
            Consumer<ListEnvironmentsRequest.Builder> listEnvironmentsRequest) {
        return listEnvironments(ListEnvironmentsRequest.builder().applyMutation(listEnvironmentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironments(software.amazon.awssdk.services.appconfig.model.ListEnvironmentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appconfig.model.ListEnvironmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appconfig.model.ListEnvironmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironments(software.amazon.awssdk.services.appconfig.model.ListEnvironmentsRequest)} operation.</b>
     * </p>
     *
     * @param listEnvironmentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListEnvironments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEnvironmentsPublisher listEnvironmentsPaginator(ListEnvironmentsRequest listEnvironmentsRequest) {
        return new ListEnvironmentsPublisher(this, listEnvironmentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironments(software.amazon.awssdk.services.appconfig.model.ListEnvironmentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appconfig.model.ListEnvironmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appconfig.model.ListEnvironmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironments(software.amazon.awssdk.services.appconfig.model.ListEnvironmentsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEnvironmentsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.ListEnvironmentsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListEnvironments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEnvironmentsPublisher listEnvironmentsPaginator(Consumer<ListEnvironmentsRequest.Builder> listEnvironmentsRequest) {
        return listEnvironmentsPaginator(ListEnvironmentsRequest.builder().applyMutation(listEnvironmentsRequest).build());
    }

    /**
     * <p>
     * Lists all AppConfig extension associations in the account. For more information about extensions and
     * associations, see <a
     * href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html">Extending
     * workflows</a> in the <i>AppConfig User Guide</i>.
     * </p>
     *
     * @param listExtensionAssociationsRequest
     * @return A Java Future containing the result of the ListExtensionAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListExtensionAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListExtensionAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListExtensionAssociationsResponse> listExtensionAssociations(
            ListExtensionAssociationsRequest listExtensionAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all AppConfig extension associations in the account. For more information about extensions and
     * associations, see <a
     * href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html">Extending
     * workflows</a> in the <i>AppConfig User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExtensionAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListExtensionAssociationsRequest#builder()}
     * </p>
     *
     * @param listExtensionAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListExtensionAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListExtensionAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListExtensionAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListExtensionAssociationsResponse> listExtensionAssociations(
            Consumer<ListExtensionAssociationsRequest.Builder> listExtensionAssociationsRequest) {
        return listExtensionAssociations(ListExtensionAssociationsRequest.builder()
                .applyMutation(listExtensionAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listExtensionAssociations(software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListExtensionAssociationsPublisher publisher = client.listExtensionAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListExtensionAssociationsPublisher publisher = client.listExtensionAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExtensionAssociations(software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listExtensionAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListExtensionAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListExtensionAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListExtensionAssociationsPublisher listExtensionAssociationsPaginator(
            ListExtensionAssociationsRequest listExtensionAssociationsRequest) {
        return new ListExtensionAssociationsPublisher(this, listExtensionAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listExtensionAssociations(software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListExtensionAssociationsPublisher publisher = client.listExtensionAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListExtensionAssociationsPublisher publisher = client.listExtensionAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExtensionAssociations(software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExtensionAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListExtensionAssociationsRequest#builder()}
     * </p>
     *
     * @param listExtensionAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListExtensionAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListExtensionAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListExtensionAssociationsPublisher listExtensionAssociationsPaginator(
            Consumer<ListExtensionAssociationsRequest.Builder> listExtensionAssociationsRequest) {
        return listExtensionAssociationsPaginator(ListExtensionAssociationsRequest.builder()
                .applyMutation(listExtensionAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists all custom and Amazon Web Services authored AppConfig extensions in the account. For more information about
     * extensions, see <a
     * href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html">Extending
     * workflows</a> in the <i>AppConfig User Guide</i>.
     * </p>
     *
     * @param listExtensionsRequest
     * @return A Java Future containing the result of the ListExtensions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListExtensions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListExtensions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExtensionsResponse> listExtensions(ListExtensionsRequest listExtensionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all custom and Amazon Web Services authored AppConfig extensions in the account. For more information about
     * extensions, see <a
     * href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html">Extending
     * workflows</a> in the <i>AppConfig User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExtensionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExtensionsRequest#builder()}
     * </p>
     *
     * @param listExtensionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.ListExtensionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListExtensions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListExtensions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListExtensions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExtensionsResponse> listExtensions(Consumer<ListExtensionsRequest.Builder> listExtensionsRequest) {
        return listExtensions(ListExtensionsRequest.builder().applyMutation(listExtensionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listExtensions(software.amazon.awssdk.services.appconfig.model.ListExtensionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListExtensionsPublisher publisher = client.listExtensionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListExtensionsPublisher publisher = client.listExtensionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appconfig.model.ListExtensionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appconfig.model.ListExtensionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExtensions(software.amazon.awssdk.services.appconfig.model.ListExtensionsRequest)} operation.</b>
     * </p>
     *
     * @param listExtensionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListExtensions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListExtensions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExtensionsPublisher listExtensionsPaginator(ListExtensionsRequest listExtensionsRequest) {
        return new ListExtensionsPublisher(this, listExtensionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listExtensions(software.amazon.awssdk.services.appconfig.model.ListExtensionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListExtensionsPublisher publisher = client.listExtensionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListExtensionsPublisher publisher = client.listExtensionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appconfig.model.ListExtensionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appconfig.model.ListExtensionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExtensions(software.amazon.awssdk.services.appconfig.model.ListExtensionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExtensionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExtensionsRequest#builder()}
     * </p>
     *
     * @param listExtensionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.ListExtensionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListExtensions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListExtensions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExtensionsPublisher listExtensionsPaginator(Consumer<ListExtensionsRequest.Builder> listExtensionsRequest) {
        return listExtensionsPaginator(ListExtensionsRequest.builder().applyMutation(listExtensionsRequest).build());
    }

    /**
     * <p>
     * Lists configurations stored in the AppConfig hosted configuration store by version.
     * </p>
     *
     * @param listHostedConfigurationVersionsRequest
     * @return A Java Future containing the result of the ListHostedConfigurationVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListHostedConfigurationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListHostedConfigurationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListHostedConfigurationVersionsResponse> listHostedConfigurationVersions(
            ListHostedConfigurationVersionsRequest listHostedConfigurationVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists configurations stored in the AppConfig hosted configuration store by version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHostedConfigurationVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListHostedConfigurationVersionsRequest#builder()}
     * </p>
     *
     * @param listHostedConfigurationVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListHostedConfigurationVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListHostedConfigurationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListHostedConfigurationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListHostedConfigurationVersionsResponse> listHostedConfigurationVersions(
            Consumer<ListHostedConfigurationVersionsRequest.Builder> listHostedConfigurationVersionsRequest) {
        return listHostedConfigurationVersions(ListHostedConfigurationVersionsRequest.builder()
                .applyMutation(listHostedConfigurationVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listHostedConfigurationVersions(software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListHostedConfigurationVersionsPublisher publisher = client.listHostedConfigurationVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListHostedConfigurationVersionsPublisher publisher = client.listHostedConfigurationVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHostedConfigurationVersions(software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listHostedConfigurationVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListHostedConfigurationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListHostedConfigurationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHostedConfigurationVersionsPublisher listHostedConfigurationVersionsPaginator(
            ListHostedConfigurationVersionsRequest listHostedConfigurationVersionsRequest) {
        return new ListHostedConfigurationVersionsPublisher(this, listHostedConfigurationVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listHostedConfigurationVersions(software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListHostedConfigurationVersionsPublisher publisher = client.listHostedConfigurationVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appconfig.paginators.ListHostedConfigurationVersionsPublisher publisher = client.listHostedConfigurationVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHostedConfigurationVersions(software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHostedConfigurationVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListHostedConfigurationVersionsRequest#builder()}
     * </p>
     *
     * @param listHostedConfigurationVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListHostedConfigurationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListHostedConfigurationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHostedConfigurationVersionsPublisher listHostedConfigurationVersionsPaginator(
            Consumer<ListHostedConfigurationVersionsRequest.Builder> listHostedConfigurationVersionsRequest) {
        return listHostedConfigurationVersionsPaginator(ListHostedConfigurationVersionsRequest.builder()
                .applyMutation(listHostedConfigurationVersionsRequest).build());
    }

    /**
     * <p>
     * Retrieves the list of key-value tags assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the list of key-value tags assigned to the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Starts a deployment.
     * </p>
     *
     * @param startDeploymentRequest
     * @return A Java Future containing the result of the StartDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.StartDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/StartDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartDeploymentResponse> startDeployment(StartDeploymentRequest startDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link StartDeploymentRequest#builder()}
     * </p>
     *
     * @param startDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.StartDeploymentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.StartDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/StartDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartDeploymentResponse> startDeployment(
            Consumer<StartDeploymentRequest.Builder> startDeploymentRequest) {
        return startDeployment(StartDeploymentRequest.builder().applyMutation(startDeploymentRequest).build());
    }

    /**
     * <p>
     * Stops a deployment. This API action works only on deployments that have a status of <code>DEPLOYING</code>. This
     * action moves the deployment to a status of <code>ROLLED_BACK</code>.
     * </p>
     *
     * @param stopDeploymentRequest
     * @return A Java Future containing the result of the StopDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.StopDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/StopDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopDeploymentResponse> stopDeployment(StopDeploymentRequest stopDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a deployment. This API action works only on deployments that have a status of <code>DEPLOYING</code>. This
     * action moves the deployment to a status of <code>ROLLED_BACK</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopDeploymentRequest.Builder} avoiding the need to
     * create one manually via {@link StopDeploymentRequest#builder()}
     * </p>
     *
     * @param stopDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.StopDeploymentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.StopDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/StopDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopDeploymentResponse> stopDeployment(Consumer<StopDeploymentRequest.Builder> stopDeploymentRequest) {
        return stopDeployment(StopDeploymentRequest.builder().applyMutation(stopDeploymentRequest).build());
    }

    /**
     * <p>
     * Assigns metadata to an AppConfig resource. Tags help organize and categorize your AppConfig resources. Each tag
     * consists of a key and an optional value, both of which you define. You can specify a maximum of 50 tags for a
     * resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns metadata to an AppConfig resource. Tags help organize and categorize your AppConfig resources. Each tag
     * consists of a key and an optional value, both of which you define. You can specify a maximum of 50 tags for a
     * resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deletes a tag key and value from an AppConfig resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a tag key and value from an AppConfig resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an application.
     * </p>
     *
     * @param updateApplicationRequest
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UpdateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest updateApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     * </p>
     *
     * @param updateApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.UpdateApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UpdateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(
            Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest) {
        return updateApplication(UpdateApplicationRequest.builder().applyMutation(updateApplicationRequest).build());
    }

    /**
     * <p>
     * Updates a configuration profile.
     * </p>
     *
     * @param updateConfigurationProfileRequest
     * @return A Java Future containing the result of the UpdateConfigurationProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.UpdateConfigurationProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UpdateConfigurationProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationProfileResponse> updateConfigurationProfile(
            UpdateConfigurationProfileRequest updateConfigurationProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a configuration profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConfigurationProfileRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateConfigurationProfileRequest#builder()}
     * </p>
     *
     * @param updateConfigurationProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.UpdateConfigurationProfileRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateConfigurationProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.UpdateConfigurationProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UpdateConfigurationProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationProfileResponse> updateConfigurationProfile(
            Consumer<UpdateConfigurationProfileRequest.Builder> updateConfigurationProfileRequest) {
        return updateConfigurationProfile(UpdateConfigurationProfileRequest.builder()
                .applyMutation(updateConfigurationProfileRequest).build());
    }

    /**
     * <p>
     * Updates a deployment strategy.
     * </p>
     *
     * @param updateDeploymentStrategyRequest
     * @return A Java Future containing the result of the UpdateDeploymentStrategy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.UpdateDeploymentStrategy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UpdateDeploymentStrategy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDeploymentStrategyResponse> updateDeploymentStrategy(
            UpdateDeploymentStrategyRequest updateDeploymentStrategyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a deployment strategy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDeploymentStrategyRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDeploymentStrategyRequest#builder()}
     * </p>
     *
     * @param updateDeploymentStrategyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.UpdateDeploymentStrategyRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateDeploymentStrategy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.UpdateDeploymentStrategy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UpdateDeploymentStrategy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDeploymentStrategyResponse> updateDeploymentStrategy(
            Consumer<UpdateDeploymentStrategyRequest.Builder> updateDeploymentStrategyRequest) {
        return updateDeploymentStrategy(UpdateDeploymentStrategyRequest.builder().applyMutation(updateDeploymentStrategyRequest)
                .build());
    }

    /**
     * <p>
     * Updates an environment.
     * </p>
     *
     * @param updateEnvironmentRequest
     * @return A Java Future containing the result of the UpdateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.UpdateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UpdateEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateEnvironmentResponse> updateEnvironment(UpdateEnvironmentRequest updateEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateEnvironmentRequest#builder()}
     * </p>
     *
     * @param updateEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.UpdateEnvironmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.UpdateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UpdateEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateEnvironmentResponse> updateEnvironment(
            Consumer<UpdateEnvironmentRequest.Builder> updateEnvironmentRequest) {
        return updateEnvironment(UpdateEnvironmentRequest.builder().applyMutation(updateEnvironmentRequest).build());
    }

    /**
     * <p>
     * Updates an AppConfig extension. For more information about extensions, see <a
     * href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html">Extending
     * workflows</a> in the <i>AppConfig User Guide</i>.
     * </p>
     *
     * @param updateExtensionRequest
     * @return A Java Future containing the result of the UpdateExtension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.UpdateExtension
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UpdateExtension" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateExtensionResponse> updateExtension(UpdateExtensionRequest updateExtensionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an AppConfig extension. For more information about extensions, see <a
     * href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html">Extending
     * workflows</a> in the <i>AppConfig User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateExtensionRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateExtensionRequest#builder()}
     * </p>
     *
     * @param updateExtensionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.UpdateExtensionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateExtension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.UpdateExtension
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UpdateExtension" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateExtensionResponse> updateExtension(
            Consumer<UpdateExtensionRequest.Builder> updateExtensionRequest) {
        return updateExtension(UpdateExtensionRequest.builder().applyMutation(updateExtensionRequest).build());
    }

    /**
     * <p>
     * Updates an association. For more information about extensions and associations, see <a
     * href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html">Extending
     * workflows</a> in the <i>AppConfig User Guide</i>.
     * </p>
     *
     * @param updateExtensionAssociationRequest
     * @return A Java Future containing the result of the UpdateExtensionAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.UpdateExtensionAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UpdateExtensionAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateExtensionAssociationResponse> updateExtensionAssociation(
            UpdateExtensionAssociationRequest updateExtensionAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an association. For more information about extensions and associations, see <a
     * href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html">Extending
     * workflows</a> in the <i>AppConfig User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateExtensionAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateExtensionAssociationRequest#builder()}
     * </p>
     *
     * @param updateExtensionAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.UpdateExtensionAssociationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateExtensionAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.UpdateExtensionAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UpdateExtensionAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateExtensionAssociationResponse> updateExtensionAssociation(
            Consumer<UpdateExtensionAssociationRequest.Builder> updateExtensionAssociationRequest) {
        return updateExtensionAssociation(UpdateExtensionAssociationRequest.builder()
                .applyMutation(updateExtensionAssociationRequest).build());
    }

    /**
     * <p>
     * Uses the validators in a configuration profile to validate a configuration.
     * </p>
     *
     * @param validateConfigurationRequest
     * @return A Java Future containing the result of the ValidateConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ValidateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ValidateConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ValidateConfigurationResponse> validateConfiguration(
            ValidateConfigurationRequest validateConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uses the validators in a configuration profile to validate a configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ValidateConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link ValidateConfigurationRequest#builder()}
     * </p>
     *
     * @param validateConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appconfig.model.ValidateConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ValidateConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>InternalServerException There was an internal failure in the AppConfig service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigAsyncClient.ValidateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ValidateConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ValidateConfigurationResponse> validateConfiguration(
            Consumer<ValidateConfigurationRequest.Builder> validateConfigurationRequest) {
        return validateConfiguration(ValidateConfigurationRequest.builder().applyMutation(validateConfigurationRequest).build());
    }

    @Override
    default AppConfigServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link AppConfigAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AppConfigAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AppConfigAsyncClient}.
     */
    static AppConfigAsyncClientBuilder builder() {
        return new DefaultAppConfigAsyncClientBuilder();
    }
}
