/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Parameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Parameter> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Parameter.getter(Parameter::description)).setter(Parameter.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Required").getter(Parameter.getter(Parameter::required)).setter(Parameter.setter(Builder::required)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Required").build()}).build();
    private static final SdkField<Boolean> DYNAMIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Dynamic").getter(Parameter.getter(Parameter::dynamic)).setter(Parameter.setter(Builder::dynamic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dynamic").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, REQUIRED_FIELD, DYNAMIC_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final Boolean required;
    private final Boolean dynamic;

    private Parameter(BuilderImpl builder) {
        this.description = builder.description;
        this.required = builder.required;
        this.dynamic = builder.dynamic;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean required() {
        return this.required;
    }

    public final Boolean dynamic() {
        return this.dynamic;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.required());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamic());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.required(), other.required()) && Objects.equals(this.dynamic(), other.dynamic());
    }

    public final String toString() {
        return ToString.builder((String)"Parameter").add("Description", (Object)this.description()).add("Required", (Object)this.required()).add("Dynamic", (Object)this.dynamic()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Required": {
                return Optional.ofNullable(clazz.cast(this.required()));
            }
            case "Dynamic": {
                return Optional.ofNullable(clazz.cast(this.dynamic()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Parameter, T> g) {
        return obj -> g.apply((Parameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private Boolean required;
        private Boolean dynamic;

        private BuilderImpl() {
        }

        private BuilderImpl(Parameter model) {
            this.description(model.description);
            this.required(model.required);
            this.dynamic(model.dynamic);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getRequired() {
            return this.required;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public final Boolean getDynamic() {
            return this.dynamic;
        }

        public final void setDynamic(Boolean dynamic) {
            this.dynamic = dynamic;
        }

        @Override
        public final Builder dynamic(Boolean dynamic) {
            this.dynamic = dynamic;
            return this;
        }

        public Parameter build() {
            return new Parameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Parameter> {
        public Builder description(String var1);

        public Builder required(Boolean var1);

        public Builder dynamic(Boolean var1);
    }
}

