/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteConfigurationProfileRequest extends AppConfigRequest implements
        ToCopyableBuilder<DeleteConfigurationProfileRequest.Builder, DeleteConfigurationProfileRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(DeleteConfigurationProfileRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationId").build()).build();

    private static final SdkField<String> CONFIGURATION_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationProfileId").getter(getter(DeleteConfigurationProfileRequest::configurationProfileId))
            .setter(setter(Builder::configurationProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConfigurationProfileId").build())
            .build();

    private static final SdkField<String> DELETION_PROTECTION_CHECK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DeletionProtectionCheck")
            .getter(getter(DeleteConfigurationProfileRequest::deletionProtectionCheckAsString))
            .setter(setter(Builder::deletionProtectionCheck))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-deletion-protection-check")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CONFIGURATION_PROFILE_ID_FIELD, DELETION_PROTECTION_CHECK_FIELD));

    private final String applicationId;

    private final String configurationProfileId;

    private final String deletionProtectionCheck;

    private DeleteConfigurationProfileRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.configurationProfileId = builder.configurationProfileId;
        this.deletionProtectionCheck = builder.deletionProtectionCheck;
    }

    /**
     * <p>
     * The application ID that includes the configuration profile you want to delete.
     * </p>
     * 
     * @return The application ID that includes the configuration profile you want to delete.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The ID of the configuration profile you want to delete.
     * </p>
     * 
     * @return The ID of the configuration profile you want to delete.
     */
    public final String configurationProfileId() {
        return configurationProfileId;
    }

    /**
     * <p>
     * A parameter to configure deletion protection. If enabled, deletion protection prevents a user from deleting a
     * configuration profile if your application has called either <a href=
     * "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
     * >GetLatestConfiguration</a> or for the configuration profile during the specified interval.
     * </p>
     * <p>
     * This parameter supports the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BYPASS</code>: Instructs AppConfig to bypass the deletion protection check and delete a configuration
     * profile even if deletion protection would have otherwise prevented it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APPLY</code>: Instructs the deletion protection check to run, even if deletion protection is disabled at
     * the account level. <code>APPLY</code> also forces the deletion protection check to run against resources created
     * in the past hour, which are normally excluded from deletion protection checks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACCOUNT_DEFAULT</code>: The default setting, which instructs AppConfig to implement the deletion protection
     * value specified in the <code>UpdateAccountSettings</code> API.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deletionProtectionCheck} will return {@link DeletionProtectionCheck#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deletionProtectionCheckAsString}.
     * </p>
     * 
     * @return A parameter to configure deletion protection. If enabled, deletion protection prevents a user from
     *         deleting a configuration profile if your application has called either <a href=
     *         "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
     *         >GetLatestConfiguration</a> or for the configuration profile during the specified interval. </p>
     *         <p>
     *         This parameter supports the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BYPASS</code>: Instructs AppConfig to bypass the deletion protection check and delete a
     *         configuration profile even if deletion protection would have otherwise prevented it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APPLY</code>: Instructs the deletion protection check to run, even if deletion protection is
     *         disabled at the account level. <code>APPLY</code> also forces the deletion protection check to run
     *         against resources created in the past hour, which are normally excluded from deletion protection checks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACCOUNT_DEFAULT</code>: The default setting, which instructs AppConfig to implement the deletion
     *         protection value specified in the <code>UpdateAccountSettings</code> API.
     *         </p>
     *         </li>
     * @see DeletionProtectionCheck
     */
    public final DeletionProtectionCheck deletionProtectionCheck() {
        return DeletionProtectionCheck.fromValue(deletionProtectionCheck);
    }

    /**
     * <p>
     * A parameter to configure deletion protection. If enabled, deletion protection prevents a user from deleting a
     * configuration profile if your application has called either <a href=
     * "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
     * >GetLatestConfiguration</a> or for the configuration profile during the specified interval.
     * </p>
     * <p>
     * This parameter supports the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BYPASS</code>: Instructs AppConfig to bypass the deletion protection check and delete a configuration
     * profile even if deletion protection would have otherwise prevented it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APPLY</code>: Instructs the deletion protection check to run, even if deletion protection is disabled at
     * the account level. <code>APPLY</code> also forces the deletion protection check to run against resources created
     * in the past hour, which are normally excluded from deletion protection checks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACCOUNT_DEFAULT</code>: The default setting, which instructs AppConfig to implement the deletion protection
     * value specified in the <code>UpdateAccountSettings</code> API.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deletionProtectionCheck} will return {@link DeletionProtectionCheck#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deletionProtectionCheckAsString}.
     * </p>
     * 
     * @return A parameter to configure deletion protection. If enabled, deletion protection prevents a user from
     *         deleting a configuration profile if your application has called either <a href=
     *         "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
     *         >GetLatestConfiguration</a> or for the configuration profile during the specified interval. </p>
     *         <p>
     *         This parameter supports the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BYPASS</code>: Instructs AppConfig to bypass the deletion protection check and delete a
     *         configuration profile even if deletion protection would have otherwise prevented it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APPLY</code>: Instructs the deletion protection check to run, even if deletion protection is
     *         disabled at the account level. <code>APPLY</code> also forces the deletion protection check to run
     *         against resources created in the past hour, which are normally excluded from deletion protection checks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACCOUNT_DEFAULT</code>: The default setting, which instructs AppConfig to implement the deletion
     *         protection value specified in the <code>UpdateAccountSettings</code> API.
     *         </p>
     *         </li>
     * @see DeletionProtectionCheck
     */
    public final String deletionProtectionCheckAsString() {
        return deletionProtectionCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(configurationProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtectionCheckAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteConfigurationProfileRequest)) {
            return false;
        }
        DeleteConfigurationProfileRequest other = (DeleteConfigurationProfileRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(configurationProfileId(), other.configurationProfileId())
                && Objects.equals(deletionProtectionCheckAsString(), other.deletionProtectionCheckAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteConfigurationProfileRequest").add("ApplicationId", applicationId())
                .add("ConfigurationProfileId", configurationProfileId())
                .add("DeletionProtectionCheck", deletionProtectionCheckAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "ConfigurationProfileId":
            return Optional.ofNullable(clazz.cast(configurationProfileId()));
        case "DeletionProtectionCheck":
            return Optional.ofNullable(clazz.cast(deletionProtectionCheckAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteConfigurationProfileRequest, T> g) {
        return obj -> g.apply((DeleteConfigurationProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteConfigurationProfileRequest> {
        /**
         * <p>
         * The application ID that includes the configuration profile you want to delete.
         * </p>
         * 
         * @param applicationId
         *        The application ID that includes the configuration profile you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The ID of the configuration profile you want to delete.
         * </p>
         * 
         * @param configurationProfileId
         *        The ID of the configuration profile you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationProfileId(String configurationProfileId);

        /**
         * <p>
         * A parameter to configure deletion protection. If enabled, deletion protection prevents a user from deleting a
         * configuration profile if your application has called either <a href=
         * "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
         * >GetLatestConfiguration</a> or for the configuration profile during the specified interval.
         * </p>
         * <p>
         * This parameter supports the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BYPASS</code>: Instructs AppConfig to bypass the deletion protection check and delete a configuration
         * profile even if deletion protection would have otherwise prevented it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APPLY</code>: Instructs the deletion protection check to run, even if deletion protection is disabled
         * at the account level. <code>APPLY</code> also forces the deletion protection check to run against resources
         * created in the past hour, which are normally excluded from deletion protection checks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACCOUNT_DEFAULT</code>: The default setting, which instructs AppConfig to implement the deletion
         * protection value specified in the <code>UpdateAccountSettings</code> API.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deletionProtectionCheck
         *        A parameter to configure deletion protection. If enabled, deletion protection prevents a user from
         *        deleting a configuration profile if your application has called either <a href=
         *        "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
         *        >GetLatestConfiguration</a> or for the configuration profile during the specified interval. </p>
         *        <p>
         *        This parameter supports the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BYPASS</code>: Instructs AppConfig to bypass the deletion protection check and delete a
         *        configuration profile even if deletion protection would have otherwise prevented it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APPLY</code>: Instructs the deletion protection check to run, even if deletion protection is
         *        disabled at the account level. <code>APPLY</code> also forces the deletion protection check to run
         *        against resources created in the past hour, which are normally excluded from deletion protection
         *        checks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACCOUNT_DEFAULT</code>: The default setting, which instructs AppConfig to implement the deletion
         *        protection value specified in the <code>UpdateAccountSettings</code> API.
         *        </p>
         *        </li>
         * @see DeletionProtectionCheck
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeletionProtectionCheck
         */
        Builder deletionProtectionCheck(String deletionProtectionCheck);

        /**
         * <p>
         * A parameter to configure deletion protection. If enabled, deletion protection prevents a user from deleting a
         * configuration profile if your application has called either <a href=
         * "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
         * >GetLatestConfiguration</a> or for the configuration profile during the specified interval.
         * </p>
         * <p>
         * This parameter supports the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BYPASS</code>: Instructs AppConfig to bypass the deletion protection check and delete a configuration
         * profile even if deletion protection would have otherwise prevented it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APPLY</code>: Instructs the deletion protection check to run, even if deletion protection is disabled
         * at the account level. <code>APPLY</code> also forces the deletion protection check to run against resources
         * created in the past hour, which are normally excluded from deletion protection checks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACCOUNT_DEFAULT</code>: The default setting, which instructs AppConfig to implement the deletion
         * protection value specified in the <code>UpdateAccountSettings</code> API.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deletionProtectionCheck
         *        A parameter to configure deletion protection. If enabled, deletion protection prevents a user from
         *        deleting a configuration profile if your application has called either <a href=
         *        "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
         *        >GetLatestConfiguration</a> or for the configuration profile during the specified interval. </p>
         *        <p>
         *        This parameter supports the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BYPASS</code>: Instructs AppConfig to bypass the deletion protection check and delete a
         *        configuration profile even if deletion protection would have otherwise prevented it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APPLY</code>: Instructs the deletion protection check to run, even if deletion protection is
         *        disabled at the account level. <code>APPLY</code> also forces the deletion protection check to run
         *        against resources created in the past hour, which are normally excluded from deletion protection
         *        checks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACCOUNT_DEFAULT</code>: The default setting, which instructs AppConfig to implement the deletion
         *        protection value specified in the <code>UpdateAccountSettings</code> API.
         *        </p>
         *        </li>
         * @see DeletionProtectionCheck
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeletionProtectionCheck
         */
        Builder deletionProtectionCheck(DeletionProtectionCheck deletionProtectionCheck);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppConfigRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String configurationProfileId;

        private String deletionProtectionCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteConfigurationProfileRequest model) {
            super(model);
            applicationId(model.applicationId);
            configurationProfileId(model.configurationProfileId);
            deletionProtectionCheck(model.deletionProtectionCheck);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getConfigurationProfileId() {
            return configurationProfileId;
        }

        public final void setConfigurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
        }

        @Override
        public final Builder configurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
            return this;
        }

        public final String getDeletionProtectionCheck() {
            return deletionProtectionCheck;
        }

        public final void setDeletionProtectionCheck(String deletionProtectionCheck) {
            this.deletionProtectionCheck = deletionProtectionCheck;
        }

        @Override
        public final Builder deletionProtectionCheck(String deletionProtectionCheck) {
            this.deletionProtectionCheck = deletionProtectionCheck;
            return this;
        }

        @Override
        public final Builder deletionProtectionCheck(DeletionProtectionCheck deletionProtectionCheck) {
            this.deletionProtectionCheck(deletionProtectionCheck == null ? null : deletionProtectionCheck.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteConfigurationProfileRequest build() {
            return new DeleteConfigurationProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
