/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccountSettingsResponse extends AppConfigResponse implements
        ToCopyableBuilder<GetAccountSettingsResponse.Builder, GetAccountSettingsResponse> {
    private static final SdkField<DeletionProtectionSettings> DELETION_PROTECTION_FIELD = SdkField
            .<DeletionProtectionSettings> builder(MarshallingType.SDK_POJO).memberName("DeletionProtection")
            .getter(getter(GetAccountSettingsResponse::deletionProtection)).setter(setter(Builder::deletionProtection))
            .constructor(DeletionProtectionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETION_PROTECTION_FIELD));

    private final DeletionProtectionSettings deletionProtection;

    private GetAccountSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.deletionProtection = builder.deletionProtection;
    }

    /**
     * <p>
     * A parameter to configure deletion protection. If enabled, deletion protection prevents a user from deleting a
     * configuration profile or an environment if AppConfig has called either <a href=
     * "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
     * >GetLatestConfiguration</a> or for the configuration profile or from the environment during the specified
     * interval. Deletion protection is disabled by default. The default interval for
     * <code>ProtectionPeriodInMinutes</code> is 60.
     * </p>
     * 
     * @return A parameter to configure deletion protection. If enabled, deletion protection prevents a user from
     *         deleting a configuration profile or an environment if AppConfig has called either <a href=
     *         "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
     *         >GetLatestConfiguration</a> or for the configuration profile or from the environment during the specified
     *         interval. Deletion protection is disabled by default. The default interval for
     *         <code>ProtectionPeriodInMinutes</code> is 60.
     */
    public final DeletionProtectionSettings deletionProtection() {
        return deletionProtection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountSettingsResponse)) {
            return false;
        }
        GetAccountSettingsResponse other = (GetAccountSettingsResponse) obj;
        return Objects.equals(deletionProtection(), other.deletionProtection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccountSettingsResponse").add("DeletionProtection", deletionProtection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccountSettingsResponse, T> g) {
        return obj -> g.apply((GetAccountSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppConfigResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAccountSettingsResponse> {
        /**
         * <p>
         * A parameter to configure deletion protection. If enabled, deletion protection prevents a user from deleting a
         * configuration profile or an environment if AppConfig has called either <a href=
         * "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
         * >GetLatestConfiguration</a> or for the configuration profile or from the environment during the specified
         * interval. Deletion protection is disabled by default. The default interval for
         * <code>ProtectionPeriodInMinutes</code> is 60.
         * </p>
         * 
         * @param deletionProtection
         *        A parameter to configure deletion protection. If enabled, deletion protection prevents a user from
         *        deleting a configuration profile or an environment if AppConfig has called either <a href=
         *        "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
         *        >GetLatestConfiguration</a> or for the configuration profile or from the environment during the
         *        specified interval. Deletion protection is disabled by default. The default interval for
         *        <code>ProtectionPeriodInMinutes</code> is 60.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(DeletionProtectionSettings deletionProtection);

        /**
         * <p>
         * A parameter to configure deletion protection. If enabled, deletion protection prevents a user from deleting a
         * configuration profile or an environment if AppConfig has called either <a href=
         * "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
         * >GetLatestConfiguration</a> or for the configuration profile or from the environment during the specified
         * interval. Deletion protection is disabled by default. The default interval for
         * <code>ProtectionPeriodInMinutes</code> is 60.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeletionProtectionSettings.Builder}
         * avoiding the need to create one manually via {@link DeletionProtectionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeletionProtectionSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #deletionProtection(DeletionProtectionSettings)}.
         * 
         * @param deletionProtection
         *        a consumer that will call methods on {@link DeletionProtectionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deletionProtection(DeletionProtectionSettings)
         */
        default Builder deletionProtection(Consumer<DeletionProtectionSettings.Builder> deletionProtection) {
            return deletionProtection(DeletionProtectionSettings.builder().applyMutation(deletionProtection).build());
        }
    }

    static final class BuilderImpl extends AppConfigResponse.BuilderImpl implements Builder {
        private DeletionProtectionSettings deletionProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountSettingsResponse model) {
            super(model);
            deletionProtection(model.deletionProtection);
        }

        public final DeletionProtectionSettings.Builder getDeletionProtection() {
            return deletionProtection != null ? deletionProtection.toBuilder() : null;
        }

        public final void setDeletionProtection(DeletionProtectionSettings.BuilderImpl deletionProtection) {
            this.deletionProtection = deletionProtection != null ? deletionProtection.build() : null;
        }

        @Override
        public final Builder deletionProtection(DeletionProtectionSettings deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        @Override
        public GetAccountSettingsResponse build() {
            return new GetAccountSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
