/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appconfig.model.ActionInvocation;
import software.amazon.awssdk.services.appconfig.model.ActionInvocationsCopier;
import software.amazon.awssdk.services.appconfig.model.DeploymentEventType;
import software.amazon.awssdk.services.appconfig.model.TriggeredBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentEvent> {
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventType").getter(DeploymentEvent.getter(DeploymentEvent::eventTypeAsString)).setter(DeploymentEvent.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").build()}).build();
    private static final SdkField<String> TRIGGERED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TriggeredBy").getter(DeploymentEvent.getter(DeploymentEvent::triggeredByAsString)).setter(DeploymentEvent.setter(Builder::triggeredBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggeredBy").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DeploymentEvent.getter(DeploymentEvent::description)).setter(DeploymentEvent.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<ActionInvocation>> ACTION_INVOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ActionInvocations").getter(DeploymentEvent.getter(DeploymentEvent::actionInvocations)).setter(DeploymentEvent.setter(Builder::actionInvocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionInvocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionInvocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> OCCURRED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("OccurredAt").getter(DeploymentEvent.getter(DeploymentEvent::occurredAt)).setter(DeploymentEvent.setter(Builder::occurredAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OccurredAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_FIELD, TRIGGERED_BY_FIELD, DESCRIPTION_FIELD, ACTION_INVOCATIONS_FIELD, OCCURRED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EventType", EVENT_TYPE_FIELD);
            this.put("TriggeredBy", TRIGGERED_BY_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("ActionInvocations", ACTION_INVOCATIONS_FIELD);
            this.put("OccurredAt", OCCURRED_AT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String eventType;
    private final String triggeredBy;
    private final String description;
    private final List<ActionInvocation> actionInvocations;
    private final Instant occurredAt;

    private DeploymentEvent(BuilderImpl builder) {
        this.eventType = builder.eventType;
        this.triggeredBy = builder.triggeredBy;
        this.description = builder.description;
        this.actionInvocations = builder.actionInvocations;
        this.occurredAt = builder.occurredAt;
    }

    public final DeploymentEventType eventType() {
        return DeploymentEventType.fromValue(this.eventType);
    }

    public final String eventTypeAsString() {
        return this.eventType;
    }

    public final TriggeredBy triggeredBy() {
        return TriggeredBy.fromValue(this.triggeredBy);
    }

    public final String triggeredByAsString() {
        return this.triggeredBy;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasActionInvocations() {
        return this.actionInvocations != null && !(this.actionInvocations instanceof SdkAutoConstructList);
    }

    public final List<ActionInvocation> actionInvocations() {
        return this.actionInvocations;
    }

    public final Instant occurredAt() {
        return this.occurredAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggeredByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionInvocations() ? this.actionInvocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.occurredAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentEvent)) {
            return false;
        }
        DeploymentEvent other = (DeploymentEvent)obj;
        return Objects.equals(this.eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(this.triggeredByAsString(), other.triggeredByAsString()) && Objects.equals(this.description(), other.description()) && this.hasActionInvocations() == other.hasActionInvocations() && Objects.equals(this.actionInvocations(), other.actionInvocations()) && Objects.equals(this.occurredAt(), other.occurredAt());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentEvent").add("EventType", (Object)this.eventTypeAsString()).add("TriggeredBy", (Object)this.triggeredByAsString()).add("Description", (Object)this.description()).add("ActionInvocations", this.hasActionInvocations() ? this.actionInvocations() : null).add("OccurredAt", (Object)this.occurredAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
            case "TriggeredBy": {
                return Optional.ofNullable(clazz.cast(this.triggeredByAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ActionInvocations": {
                return Optional.ofNullable(clazz.cast(this.actionInvocations()));
            }
            case "OccurredAt": {
                return Optional.ofNullable(clazz.cast(this.occurredAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentEvent, T> g) {
        return obj -> g.apply((DeploymentEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventType;
        private String triggeredBy;
        private String description;
        private List<ActionInvocation> actionInvocations = DefaultSdkAutoConstructList.getInstance();
        private Instant occurredAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentEvent model) {
            this.eventType(model.eventType);
            this.triggeredBy(model.triggeredBy);
            this.description(model.description);
            this.actionInvocations(model.actionInvocations);
            this.occurredAt(model.occurredAt);
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(DeploymentEventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final String getTriggeredBy() {
            return this.triggeredBy;
        }

        public final void setTriggeredBy(String triggeredBy) {
            this.triggeredBy = triggeredBy;
        }

        @Override
        public final Builder triggeredBy(String triggeredBy) {
            this.triggeredBy = triggeredBy;
            return this;
        }

        @Override
        public final Builder triggeredBy(TriggeredBy triggeredBy) {
            this.triggeredBy(triggeredBy == null ? null : triggeredBy.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<ActionInvocation.Builder> getActionInvocations() {
            List<ActionInvocation.Builder> result = ActionInvocationsCopier.copyToBuilder(this.actionInvocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionInvocations(Collection<ActionInvocation.BuilderImpl> actionInvocations) {
            this.actionInvocations = ActionInvocationsCopier.copyFromBuilder(actionInvocations);
        }

        @Override
        public final Builder actionInvocations(Collection<ActionInvocation> actionInvocations) {
            this.actionInvocations = ActionInvocationsCopier.copy(actionInvocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionInvocations(ActionInvocation ... actionInvocations) {
            this.actionInvocations(Arrays.asList(actionInvocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionInvocations(Consumer<ActionInvocation.Builder> ... actionInvocations) {
            this.actionInvocations(Stream.of(actionInvocations).map(c -> (ActionInvocation)((ActionInvocation.Builder)ActionInvocation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getOccurredAt() {
            return this.occurredAt;
        }

        public final void setOccurredAt(Instant occurredAt) {
            this.occurredAt = occurredAt;
        }

        @Override
        public final Builder occurredAt(Instant occurredAt) {
            this.occurredAt = occurredAt;
            return this;
        }

        public DeploymentEvent build() {
            return new DeploymentEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentEvent> {
        public Builder eventType(String var1);

        public Builder eventType(DeploymentEventType var1);

        public Builder triggeredBy(String var1);

        public Builder triggeredBy(TriggeredBy var1);

        public Builder description(String var1);

        public Builder actionInvocations(Collection<ActionInvocation> var1);

        public Builder actionInvocations(ActionInvocation ... var1);

        public Builder actionInvocations(Consumer<ActionInvocation.Builder> ... var1);

        public Builder occurredAt(Instant var1);
    }
}

