/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appconfig.model.Action;
import software.amazon.awssdk.services.appconfig.model.ActionPoint;
import software.amazon.awssdk.services.appconfig.model.ActionsMapCopier;
import software.amazon.awssdk.services.appconfig.model.AppConfigRequest;
import software.amazon.awssdk.services.appconfig.model.Parameter;
import software.amazon.awssdk.services.appconfig.model.ParameterMapCopier;
import software.amazon.awssdk.services.appconfig.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateExtensionRequest
extends AppConfigRequest
implements ToCopyableBuilder<Builder, CreateExtensionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateExtensionRequest.getter(CreateExtensionRequest::name)).setter(CreateExtensionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateExtensionRequest.getter(CreateExtensionRequest::description)).setter(CreateExtensionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, List<Action>>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Actions").getter(CreateExtensionRequest.getter(CreateExtensionRequest::actionsAsStrings)).setter(CreateExtensionRequest.setter(Builder::actionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Map<String, Parameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(CreateExtensionRequest.getter(CreateExtensionRequest::parameters)).setter(CreateExtensionRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Parameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateExtensionRequest.getter(CreateExtensionRequest::tags)).setter(CreateExtensionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> LATEST_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LatestVersionNumber").getter(CreateExtensionRequest.getter(CreateExtensionRequest::latestVersionNumber)).setter(CreateExtensionRequest.setter(Builder::latestVersionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Latest-Version-Number").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, ACTIONS_FIELD, PARAMETERS_FIELD, TAGS_FIELD, LATEST_VERSION_NUMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateExtensionRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final Map<String, List<Action>> actions;
    private final Map<String, Parameter> parameters;
    private final Map<String, String> tags;
    private final Integer latestVersionNumber;

    private CreateExtensionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.actions = builder.actions;
        this.parameters = builder.parameters;
        this.tags = builder.tags;
        this.latestVersionNumber = builder.latestVersionNumber;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Map<ActionPoint, List<Action>> actions() {
        return ActionsMapCopier.copyStringToEnum(this.actions);
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<Action>> actionsAsStrings() {
        return this.actions;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, Parameter> parameters() {
        return this.parameters;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Integer latestVersionNumber() {
        return this.latestVersionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersionNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExtensionRequest)) {
            return false;
        }
        CreateExtensionRequest other = (CreateExtensionRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasActions() == other.hasActions() && Objects.equals(this.actionsAsStrings(), other.actionsAsStrings()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.latestVersionNumber(), other.latestVersionNumber());
    }

    public final String toString() {
        return ToString.builder((String)"CreateExtensionRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Actions", this.hasActions() ? this.actionsAsStrings() : null).add("Parameters", this.hasParameters() ? this.parameters() : null).add("Tags", this.hasTags() ? this.tags() : null).add("LatestVersionNumber", (Object)this.latestVersionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actionsAsStrings()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "LatestVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.latestVersionNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Actions", ACTIONS_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Latest-Version-Number", LATEST_VERSION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateExtensionRequest, T> g) {
        return obj -> g.apply((CreateExtensionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private Map<String, List<Action>> actions = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Parameter> parameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Integer latestVersionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExtensionRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.actionsWithStrings(model.actions);
            this.parameters(model.parameters);
            this.tags(model.tags);
            this.latestVersionNumber(model.latestVersionNumber);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, List<Action.Builder>> getActions() {
            Map<String, List<Action.Builder>> result = ActionsMapCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setActions(Map<String, ? extends Collection<Action.BuilderImpl>> actions) {
            this.actions = ActionsMapCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actionsWithStrings(Map<String, ? extends Collection<Action>> actions) {
            this.actions = ActionsMapCopier.copy(actions);
            return this;
        }

        @Override
        public final Builder actions(Map<ActionPoint, ? extends Collection<Action>> actions) {
            this.actions = ActionsMapCopier.copyEnumToString(actions);
            return this;
        }

        public final Map<String, Parameter.Builder> getParameters() {
            Map<String, Parameter.Builder> result = ParameterMapCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, Parameter.BuilderImpl> parameters) {
            this.parameters = ParameterMapCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, Parameter> parameters) {
            this.parameters = ParameterMapCopier.copy(parameters);
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Integer getLatestVersionNumber() {
            return this.latestVersionNumber;
        }

        public final void setLatestVersionNumber(Integer latestVersionNumber) {
            this.latestVersionNumber = latestVersionNumber;
        }

        @Override
        public final Builder latestVersionNumber(Integer latestVersionNumber) {
            this.latestVersionNumber = latestVersionNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateExtensionRequest build() {
            return new CreateExtensionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateExtensionRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder actionsWithStrings(Map<String, ? extends Collection<Action>> var1);

        public Builder actions(Map<ActionPoint, ? extends Collection<Action>> var1);

        public Builder parameters(Map<String, Parameter> var1);

        public Builder tags(Map<String, String> var1);

        public Builder latestVersionNumber(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

