/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class ActionsMapCopier {
    static Map<String, List<Action>> copy(Map<String, ? extends Collection<? extends Action>> actionsMapParam) {
        Map<String, List<Action>> map;
        if (actionsMapParam == null || actionsMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<Action>> modifiableMap = new LinkedHashMap<>(actionsMapParam.size());
            actionsMapParam.forEach((key, value) -> {
                List<Action> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<Action> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        modifiableList.add(entry);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<Action>> copyFromBuilder(Map<String, ? extends Collection<? extends Action.Builder>> actionsMapParam) {
        Map<String, List<Action>> map;
        if (actionsMapParam == null || actionsMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<Action>> modifiableMap = new LinkedHashMap<>(actionsMapParam.size());
            actionsMapParam.forEach((key, value) -> {
                List<Action> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<Action> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        Action member = entry == null ? null : entry.build();
                        modifiableList.add(member);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<Action.Builder>> copyToBuilder(Map<String, ? extends Collection<? extends Action>> actionsMapParam) {
        Map<String, List<Action.Builder>> map;
        if (actionsMapParam == null || actionsMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<Action.Builder>> modifiableMap = new LinkedHashMap<>(actionsMapParam.size());
            actionsMapParam.forEach((key, value) -> {
                List<Action.Builder> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<Action.Builder> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        Action.Builder member = entry == null ? null : entry.toBuilder();
                        modifiableList.add(member);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<Action>> copyEnumToString(Map<ActionPoint, ? extends Collection<? extends Action>> actionsMapParam) {
        Map<String, List<Action>> map;
        if (actionsMapParam == null || actionsMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<Action>> modifiableMap = new LinkedHashMap<>(actionsMapParam.size());
            actionsMapParam.forEach((key, value) -> {
                String result = key == null ? null : key.toString();
                List<Action> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<Action> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        modifiableList.add(entry);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(result, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<ActionPoint, List<Action>> copyStringToEnum(Map<String, ? extends Collection<? extends Action>> actionsMapParam) {
        Map<ActionPoint, List<Action>> map;
        if (actionsMapParam == null || actionsMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<ActionPoint, List<Action>> modifiableMap = new LinkedHashMap<>(actionsMapParam.size());
            actionsMapParam.forEach((key, value) -> {
                ActionPoint result = ActionPoint.fromValue(key);
                List<Action> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<Action> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        modifiableList.add(entry);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                if (result != ActionPoint.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, list);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
