/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appconfig.model.DeploymentState;
import software.amazon.awssdk.services.appconfig.model.GrowthType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentSummary> {
    private static final SdkField<Integer> DEPLOYMENT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DeploymentNumber").getter(DeploymentSummary.getter(DeploymentSummary::deploymentNumber)).setter(DeploymentSummary.setter(Builder::deploymentNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentNumber").build()}).build();
    private static final SdkField<String> CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationName").getter(DeploymentSummary.getter(DeploymentSummary::configurationName)).setter(DeploymentSummary.setter(Builder::configurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationName").build()}).build();
    private static final SdkField<String> CONFIGURATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationVersion").getter(DeploymentSummary.getter(DeploymentSummary::configurationVersion)).setter(DeploymentSummary.setter(Builder::configurationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationVersion").build()}).build();
    private static final SdkField<Integer> DEPLOYMENT_DURATION_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DeploymentDurationInMinutes").getter(DeploymentSummary.getter(DeploymentSummary::deploymentDurationInMinutes)).setter(DeploymentSummary.setter(Builder::deploymentDurationInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentDurationInMinutes").build()}).build();
    private static final SdkField<String> GROWTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrowthType").getter(DeploymentSummary.getter(DeploymentSummary::growthTypeAsString)).setter(DeploymentSummary.setter(Builder::growthType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrowthType").build()}).build();
    private static final SdkField<Float> GROWTH_FACTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("GrowthFactor").getter(DeploymentSummary.getter(DeploymentSummary::growthFactor)).setter(DeploymentSummary.setter(Builder::growthFactor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrowthFactor").build()}).build();
    private static final SdkField<Integer> FINAL_BAKE_TIME_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FinalBakeTimeInMinutes").getter(DeploymentSummary.getter(DeploymentSummary::finalBakeTimeInMinutes)).setter(DeploymentSummary.setter(Builder::finalBakeTimeInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalBakeTimeInMinutes").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(DeploymentSummary.getter(DeploymentSummary::stateAsString)).setter(DeploymentSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Float> PERCENTAGE_COMPLETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("PercentageComplete").getter(DeploymentSummary.getter(DeploymentSummary::percentageComplete)).setter(DeploymentSummary.setter(Builder::percentageComplete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentageComplete").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedAt").getter(DeploymentSummary.getter(DeploymentSummary::startedAt)).setter(DeploymentSummary.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletedAt").getter(DeploymentSummary.getter(DeploymentSummary::completedAt)).setter(DeploymentSummary.setter(Builder::completedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> VERSION_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionLabel").getter(DeploymentSummary.getter(DeploymentSummary::versionLabel)).setter(DeploymentSummary.setter(Builder::versionLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionLabel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_NUMBER_FIELD, CONFIGURATION_NAME_FIELD, CONFIGURATION_VERSION_FIELD, DEPLOYMENT_DURATION_IN_MINUTES_FIELD, GROWTH_TYPE_FIELD, GROWTH_FACTOR_FIELD, FINAL_BAKE_TIME_IN_MINUTES_FIELD, STATE_FIELD, PERCENTAGE_COMPLETE_FIELD, STARTED_AT_FIELD, COMPLETED_AT_FIELD, VERSION_LABEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeploymentSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer deploymentNumber;
    private final String configurationName;
    private final String configurationVersion;
    private final Integer deploymentDurationInMinutes;
    private final String growthType;
    private final Float growthFactor;
    private final Integer finalBakeTimeInMinutes;
    private final String state;
    private final Float percentageComplete;
    private final Instant startedAt;
    private final Instant completedAt;
    private final String versionLabel;

    private DeploymentSummary(BuilderImpl builder) {
        this.deploymentNumber = builder.deploymentNumber;
        this.configurationName = builder.configurationName;
        this.configurationVersion = builder.configurationVersion;
        this.deploymentDurationInMinutes = builder.deploymentDurationInMinutes;
        this.growthType = builder.growthType;
        this.growthFactor = builder.growthFactor;
        this.finalBakeTimeInMinutes = builder.finalBakeTimeInMinutes;
        this.state = builder.state;
        this.percentageComplete = builder.percentageComplete;
        this.startedAt = builder.startedAt;
        this.completedAt = builder.completedAt;
        this.versionLabel = builder.versionLabel;
    }

    public final Integer deploymentNumber() {
        return this.deploymentNumber;
    }

    public final String configurationName() {
        return this.configurationName;
    }

    public final String configurationVersion() {
        return this.configurationVersion;
    }

    public final Integer deploymentDurationInMinutes() {
        return this.deploymentDurationInMinutes;
    }

    public final GrowthType growthType() {
        return GrowthType.fromValue(this.growthType);
    }

    public final String growthTypeAsString() {
        return this.growthType;
    }

    public final Float growthFactor() {
        return this.growthFactor;
    }

    public final Integer finalBakeTimeInMinutes() {
        return this.finalBakeTimeInMinutes;
    }

    public final DeploymentState state() {
        return DeploymentState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Float percentageComplete() {
        return this.percentageComplete;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant completedAt() {
        return this.completedAt;
    }

    public final String versionLabel() {
        return this.versionLabel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentDurationInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.growthTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.growthFactor());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalBakeTimeInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentageComplete());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionLabel());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentSummary)) {
            return false;
        }
        DeploymentSummary other = (DeploymentSummary)obj;
        return Objects.equals(this.deploymentNumber(), other.deploymentNumber()) && Objects.equals(this.configurationName(), other.configurationName()) && Objects.equals(this.configurationVersion(), other.configurationVersion()) && Objects.equals(this.deploymentDurationInMinutes(), other.deploymentDurationInMinutes()) && Objects.equals(this.growthTypeAsString(), other.growthTypeAsString()) && Objects.equals(this.growthFactor(), other.growthFactor()) && Objects.equals(this.finalBakeTimeInMinutes(), other.finalBakeTimeInMinutes()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.percentageComplete(), other.percentageComplete()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.completedAt(), other.completedAt()) && Objects.equals(this.versionLabel(), other.versionLabel());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentSummary").add("DeploymentNumber", (Object)this.deploymentNumber()).add("ConfigurationName", (Object)this.configurationName()).add("ConfigurationVersion", (Object)this.configurationVersion()).add("DeploymentDurationInMinutes", (Object)this.deploymentDurationInMinutes()).add("GrowthType", (Object)this.growthTypeAsString()).add("GrowthFactor", (Object)this.growthFactor()).add("FinalBakeTimeInMinutes", (Object)this.finalBakeTimeInMinutes()).add("State", (Object)this.stateAsString()).add("PercentageComplete", (Object)this.percentageComplete()).add("StartedAt", (Object)this.startedAt()).add("CompletedAt", (Object)this.completedAt()).add("VersionLabel", (Object)this.versionLabel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeploymentNumber": {
                return Optional.ofNullable(clazz.cast(this.deploymentNumber()));
            }
            case "ConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.configurationName()));
            }
            case "ConfigurationVersion": {
                return Optional.ofNullable(clazz.cast(this.configurationVersion()));
            }
            case "DeploymentDurationInMinutes": {
                return Optional.ofNullable(clazz.cast(this.deploymentDurationInMinutes()));
            }
            case "GrowthType": {
                return Optional.ofNullable(clazz.cast(this.growthTypeAsString()));
            }
            case "GrowthFactor": {
                return Optional.ofNullable(clazz.cast(this.growthFactor()));
            }
            case "FinalBakeTimeInMinutes": {
                return Optional.ofNullable(clazz.cast(this.finalBakeTimeInMinutes()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "PercentageComplete": {
                return Optional.ofNullable(clazz.cast(this.percentageComplete()));
            }
            case "StartedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "CompletedAt": {
                return Optional.ofNullable(clazz.cast(this.completedAt()));
            }
            case "VersionLabel": {
                return Optional.ofNullable(clazz.cast(this.versionLabel()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeploymentNumber", DEPLOYMENT_NUMBER_FIELD);
        map.put("ConfigurationName", CONFIGURATION_NAME_FIELD);
        map.put("ConfigurationVersion", CONFIGURATION_VERSION_FIELD);
        map.put("DeploymentDurationInMinutes", DEPLOYMENT_DURATION_IN_MINUTES_FIELD);
        map.put("GrowthType", GROWTH_TYPE_FIELD);
        map.put("GrowthFactor", GROWTH_FACTOR_FIELD);
        map.put("FinalBakeTimeInMinutes", FINAL_BAKE_TIME_IN_MINUTES_FIELD);
        map.put("State", STATE_FIELD);
        map.put("PercentageComplete", PERCENTAGE_COMPLETE_FIELD);
        map.put("StartedAt", STARTED_AT_FIELD);
        map.put("CompletedAt", COMPLETED_AT_FIELD);
        map.put("VersionLabel", VERSION_LABEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeploymentSummary, T> g) {
        return obj -> g.apply((DeploymentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer deploymentNumber;
        private String configurationName;
        private String configurationVersion;
        private Integer deploymentDurationInMinutes;
        private String growthType;
        private Float growthFactor;
        private Integer finalBakeTimeInMinutes;
        private String state;
        private Float percentageComplete;
        private Instant startedAt;
        private Instant completedAt;
        private String versionLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentSummary model) {
            this.deploymentNumber(model.deploymentNumber);
            this.configurationName(model.configurationName);
            this.configurationVersion(model.configurationVersion);
            this.deploymentDurationInMinutes(model.deploymentDurationInMinutes);
            this.growthType(model.growthType);
            this.growthFactor(model.growthFactor);
            this.finalBakeTimeInMinutes(model.finalBakeTimeInMinutes);
            this.state(model.state);
            this.percentageComplete(model.percentageComplete);
            this.startedAt(model.startedAt);
            this.completedAt(model.completedAt);
            this.versionLabel(model.versionLabel);
        }

        public final Integer getDeploymentNumber() {
            return this.deploymentNumber;
        }

        public final void setDeploymentNumber(Integer deploymentNumber) {
            this.deploymentNumber = deploymentNumber;
        }

        @Override
        public final Builder deploymentNumber(Integer deploymentNumber) {
            this.deploymentNumber = deploymentNumber;
            return this;
        }

        public final String getConfigurationName() {
            return this.configurationName;
        }

        public final void setConfigurationName(String configurationName) {
            this.configurationName = configurationName;
        }

        @Override
        public final Builder configurationName(String configurationName) {
            this.configurationName = configurationName;
            return this;
        }

        public final String getConfigurationVersion() {
            return this.configurationVersion;
        }

        public final void setConfigurationVersion(String configurationVersion) {
            this.configurationVersion = configurationVersion;
        }

        @Override
        public final Builder configurationVersion(String configurationVersion) {
            this.configurationVersion = configurationVersion;
            return this;
        }

        public final Integer getDeploymentDurationInMinutes() {
            return this.deploymentDurationInMinutes;
        }

        public final void setDeploymentDurationInMinutes(Integer deploymentDurationInMinutes) {
            this.deploymentDurationInMinutes = deploymentDurationInMinutes;
        }

        @Override
        public final Builder deploymentDurationInMinutes(Integer deploymentDurationInMinutes) {
            this.deploymentDurationInMinutes = deploymentDurationInMinutes;
            return this;
        }

        public final String getGrowthType() {
            return this.growthType;
        }

        public final void setGrowthType(String growthType) {
            this.growthType = growthType;
        }

        @Override
        public final Builder growthType(String growthType) {
            this.growthType = growthType;
            return this;
        }

        @Override
        public final Builder growthType(GrowthType growthType) {
            this.growthType(growthType == null ? null : growthType.toString());
            return this;
        }

        public final Float getGrowthFactor() {
            return this.growthFactor;
        }

        public final void setGrowthFactor(Float growthFactor) {
            this.growthFactor = growthFactor;
        }

        @Override
        public final Builder growthFactor(Float growthFactor) {
            this.growthFactor = growthFactor;
            return this;
        }

        public final Integer getFinalBakeTimeInMinutes() {
            return this.finalBakeTimeInMinutes;
        }

        public final void setFinalBakeTimeInMinutes(Integer finalBakeTimeInMinutes) {
            this.finalBakeTimeInMinutes = finalBakeTimeInMinutes;
        }

        @Override
        public final Builder finalBakeTimeInMinutes(Integer finalBakeTimeInMinutes) {
            this.finalBakeTimeInMinutes = finalBakeTimeInMinutes;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DeploymentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Float getPercentageComplete() {
            return this.percentageComplete;
        }

        public final void setPercentageComplete(Float percentageComplete) {
            this.percentageComplete = percentageComplete;
        }

        @Override
        public final Builder percentageComplete(Float percentageComplete) {
            this.percentageComplete = percentageComplete;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getCompletedAt() {
            return this.completedAt;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public DeploymentSummary build() {
            return new DeploymentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentSummary> {
        public Builder deploymentNumber(Integer var1);

        public Builder configurationName(String var1);

        public Builder configurationVersion(String var1);

        public Builder deploymentDurationInMinutes(Integer var1);

        public Builder growthType(String var1);

        public Builder growthType(GrowthType var1);

        public Builder growthFactor(Float var1);

        public Builder finalBakeTimeInMinutes(Integer var1);

        public Builder state(String var1);

        public Builder state(DeploymentState var1);

        public Builder percentageComplete(Float var1);

        public Builder startedAt(Instant var1);

        public Builder completedAt(Instant var1);

        public Builder versionLabel(String var1);
    }
}

