/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteEnvironmentRequest extends AppConfigRequest implements
        ToCopyableBuilder<DeleteEnvironmentRequest.Builder, DeleteEnvironmentRequest> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentId").getter(getter(DeleteEnvironmentRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("EnvironmentId").build()).build();

    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(DeleteEnvironmentRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationId").build()).build();

    private static final SdkField<String> DELETION_PROTECTION_CHECK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DeletionProtectionCheck")
            .getter(getter(DeleteEnvironmentRequest::deletionProtectionCheckAsString))
            .setter(setter(Builder::deletionProtectionCheck))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-deletion-protection-check")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD,
            APPLICATION_ID_FIELD, DELETION_PROTECTION_CHECK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String environmentId;

    private final String applicationId;

    private final String deletionProtectionCheck;

    private DeleteEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.applicationId = builder.applicationId;
        this.deletionProtectionCheck = builder.deletionProtectionCheck;
    }

    /**
     * <p>
     * The ID of the environment that you want to delete.
     * </p>
     * 
     * @return The ID of the environment that you want to delete.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The application ID that includes the environment that you want to delete.
     * </p>
     * 
     * @return The application ID that includes the environment that you want to delete.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * A parameter to configure deletion protection. Deletion protection prevents a user from deleting an environment if
     * your application called either <a href=
     * "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
     * >GetLatestConfiguration</a> or in the environment during the specified interval.
     * </p>
     * <p>
     * This parameter supports the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BYPASS</code>: Instructs AppConfig to bypass the deletion protection check and delete a configuration
     * profile even if deletion protection would have otherwise prevented it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APPLY</code>: Instructs the deletion protection check to run, even if deletion protection is disabled at
     * the account level. <code>APPLY</code> also forces the deletion protection check to run against resources created
     * in the past hour, which are normally excluded from deletion protection checks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACCOUNT_DEFAULT</code>: The default setting, which instructs AppConfig to implement the deletion protection
     * value specified in the <code>UpdateAccountSettings</code> API.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deletionProtectionCheck} will return {@link DeletionProtectionCheck#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deletionProtectionCheckAsString}.
     * </p>
     * 
     * @return A parameter to configure deletion protection. Deletion protection prevents a user from deleting an
     *         environment if your application called either <a href=
     *         "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
     *         >GetLatestConfiguration</a> or in the environment during the specified interval. </p>
     *         <p>
     *         This parameter supports the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BYPASS</code>: Instructs AppConfig to bypass the deletion protection check and delete a
     *         configuration profile even if deletion protection would have otherwise prevented it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APPLY</code>: Instructs the deletion protection check to run, even if deletion protection is
     *         disabled at the account level. <code>APPLY</code> also forces the deletion protection check to run
     *         against resources created in the past hour, which are normally excluded from deletion protection checks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACCOUNT_DEFAULT</code>: The default setting, which instructs AppConfig to implement the deletion
     *         protection value specified in the <code>UpdateAccountSettings</code> API.
     *         </p>
     *         </li>
     * @see DeletionProtectionCheck
     */
    public final DeletionProtectionCheck deletionProtectionCheck() {
        return DeletionProtectionCheck.fromValue(deletionProtectionCheck);
    }

    /**
     * <p>
     * A parameter to configure deletion protection. Deletion protection prevents a user from deleting an environment if
     * your application called either <a href=
     * "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
     * >GetLatestConfiguration</a> or in the environment during the specified interval.
     * </p>
     * <p>
     * This parameter supports the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BYPASS</code>: Instructs AppConfig to bypass the deletion protection check and delete a configuration
     * profile even if deletion protection would have otherwise prevented it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APPLY</code>: Instructs the deletion protection check to run, even if deletion protection is disabled at
     * the account level. <code>APPLY</code> also forces the deletion protection check to run against resources created
     * in the past hour, which are normally excluded from deletion protection checks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACCOUNT_DEFAULT</code>: The default setting, which instructs AppConfig to implement the deletion protection
     * value specified in the <code>UpdateAccountSettings</code> API.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deletionProtectionCheck} will return {@link DeletionProtectionCheck#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deletionProtectionCheckAsString}.
     * </p>
     * 
     * @return A parameter to configure deletion protection. Deletion protection prevents a user from deleting an
     *         environment if your application called either <a href=
     *         "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
     *         >GetLatestConfiguration</a> or in the environment during the specified interval. </p>
     *         <p>
     *         This parameter supports the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BYPASS</code>: Instructs AppConfig to bypass the deletion protection check and delete a
     *         configuration profile even if deletion protection would have otherwise prevented it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APPLY</code>: Instructs the deletion protection check to run, even if deletion protection is
     *         disabled at the account level. <code>APPLY</code> also forces the deletion protection check to run
     *         against resources created in the past hour, which are normally excluded from deletion protection checks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACCOUNT_DEFAULT</code>: The default setting, which instructs AppConfig to implement the deletion
     *         protection value specified in the <code>UpdateAccountSettings</code> API.
     *         </p>
     *         </li>
     * @see DeletionProtectionCheck
     */
    public final String deletionProtectionCheckAsString() {
        return deletionProtectionCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtectionCheckAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEnvironmentRequest)) {
            return false;
        }
        DeleteEnvironmentRequest other = (DeleteEnvironmentRequest) obj;
        return Objects.equals(environmentId(), other.environmentId()) && Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(deletionProtectionCheckAsString(), other.deletionProtectionCheckAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteEnvironmentRequest").add("EnvironmentId", environmentId())
                .add("ApplicationId", applicationId()).add("DeletionProtectionCheck", deletionProtectionCheckAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnvironmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "DeletionProtectionCheck":
            return Optional.ofNullable(clazz.cast(deletionProtectionCheckAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EnvironmentId", ENVIRONMENT_ID_FIELD);
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("x-amzn-deletion-protection-check", DELETION_PROTECTION_CHECK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteEnvironmentRequest, T> g) {
        return obj -> g.apply((DeleteEnvironmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteEnvironmentRequest> {
        /**
         * <p>
         * The ID of the environment that you want to delete.
         * </p>
         * 
         * @param environmentId
         *        The ID of the environment that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The application ID that includes the environment that you want to delete.
         * </p>
         * 
         * @param applicationId
         *        The application ID that includes the environment that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * A parameter to configure deletion protection. Deletion protection prevents a user from deleting an
         * environment if your application called either <a href=
         * "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
         * >GetLatestConfiguration</a> or in the environment during the specified interval.
         * </p>
         * <p>
         * This parameter supports the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BYPASS</code>: Instructs AppConfig to bypass the deletion protection check and delete a configuration
         * profile even if deletion protection would have otherwise prevented it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APPLY</code>: Instructs the deletion protection check to run, even if deletion protection is disabled
         * at the account level. <code>APPLY</code> also forces the deletion protection check to run against resources
         * created in the past hour, which are normally excluded from deletion protection checks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACCOUNT_DEFAULT</code>: The default setting, which instructs AppConfig to implement the deletion
         * protection value specified in the <code>UpdateAccountSettings</code> API.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deletionProtectionCheck
         *        A parameter to configure deletion protection. Deletion protection prevents a user from deleting an
         *        environment if your application called either <a href=
         *        "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
         *        >GetLatestConfiguration</a> or in the environment during the specified interval. </p>
         *        <p>
         *        This parameter supports the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BYPASS</code>: Instructs AppConfig to bypass the deletion protection check and delete a
         *        configuration profile even if deletion protection would have otherwise prevented it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APPLY</code>: Instructs the deletion protection check to run, even if deletion protection is
         *        disabled at the account level. <code>APPLY</code> also forces the deletion protection check to run
         *        against resources created in the past hour, which are normally excluded from deletion protection
         *        checks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACCOUNT_DEFAULT</code>: The default setting, which instructs AppConfig to implement the deletion
         *        protection value specified in the <code>UpdateAccountSettings</code> API.
         *        </p>
         *        </li>
         * @see DeletionProtectionCheck
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeletionProtectionCheck
         */
        Builder deletionProtectionCheck(String deletionProtectionCheck);

        /**
         * <p>
         * A parameter to configure deletion protection. Deletion protection prevents a user from deleting an
         * environment if your application called either <a href=
         * "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
         * >GetLatestConfiguration</a> or in the environment during the specified interval.
         * </p>
         * <p>
         * This parameter supports the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BYPASS</code>: Instructs AppConfig to bypass the deletion protection check and delete a configuration
         * profile even if deletion protection would have otherwise prevented it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APPLY</code>: Instructs the deletion protection check to run, even if deletion protection is disabled
         * at the account level. <code>APPLY</code> also forces the deletion protection check to run against resources
         * created in the past hour, which are normally excluded from deletion protection checks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACCOUNT_DEFAULT</code>: The default setting, which instructs AppConfig to implement the deletion
         * protection value specified in the <code>UpdateAccountSettings</code> API.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deletionProtectionCheck
         *        A parameter to configure deletion protection. Deletion protection prevents a user from deleting an
         *        environment if your application called either <a href=
         *        "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
         *        >GetLatestConfiguration</a> or in the environment during the specified interval. </p>
         *        <p>
         *        This parameter supports the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BYPASS</code>: Instructs AppConfig to bypass the deletion protection check and delete a
         *        configuration profile even if deletion protection would have otherwise prevented it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APPLY</code>: Instructs the deletion protection check to run, even if deletion protection is
         *        disabled at the account level. <code>APPLY</code> also forces the deletion protection check to run
         *        against resources created in the past hour, which are normally excluded from deletion protection
         *        checks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACCOUNT_DEFAULT</code>: The default setting, which instructs AppConfig to implement the deletion
         *        protection value specified in the <code>UpdateAccountSettings</code> API.
         *        </p>
         *        </li>
         * @see DeletionProtectionCheck
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeletionProtectionCheck
         */
        Builder deletionProtectionCheck(DeletionProtectionCheck deletionProtectionCheck);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppConfigRequest.BuilderImpl implements Builder {
        private String environmentId;

        private String applicationId;

        private String deletionProtectionCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEnvironmentRequest model) {
            super(model);
            environmentId(model.environmentId);
            applicationId(model.applicationId);
            deletionProtectionCheck(model.deletionProtectionCheck);
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getDeletionProtectionCheck() {
            return deletionProtectionCheck;
        }

        public final void setDeletionProtectionCheck(String deletionProtectionCheck) {
            this.deletionProtectionCheck = deletionProtectionCheck;
        }

        @Override
        public final Builder deletionProtectionCheck(String deletionProtectionCheck) {
            this.deletionProtectionCheck = deletionProtectionCheck;
            return this;
        }

        @Override
        public final Builder deletionProtectionCheck(DeletionProtectionCheck deletionProtectionCheck) {
            this.deletionProtectionCheck(deletionProtectionCheck == null ? null : deletionProtectionCheck.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteEnvironmentRequest build() {
            return new DeleteEnvironmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
