/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfigdata.model;

import java.beans.Transient;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response parameters for the GetLatestConfiguration API
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLatestConfigurationResponse extends AppConfigDataResponse implements
        ToCopyableBuilder<GetLatestConfigurationResponse.Builder, GetLatestConfigurationResponse> {
    private static final SdkField<SdkBytes> CONFIGURATION_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("Configuration")
            .getter(getter(GetLatestConfigurationResponse::configuration))
            .setter(setter(Builder::configuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build(),
                    PayloadTrait.create()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(GetLatestConfigurationResponse::contentType))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<String> NEXT_POLL_CONFIGURATION_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextPollConfigurationToken")
            .getter(getter(GetLatestConfigurationResponse::nextPollConfigurationToken))
            .setter(setter(Builder::nextPollConfigurationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Next-Poll-Configuration-Token")
                    .build()).build();

    private static final SdkField<Integer> NEXT_POLL_INTERVAL_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NextPollIntervalInSeconds")
            .getter(getter(GetLatestConfigurationResponse::nextPollIntervalInSeconds))
            .setter(setter(Builder::nextPollIntervalInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Next-Poll-Interval-In-Seconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD,
            CONTENT_TYPE_FIELD, NEXT_POLL_CONFIGURATION_TOKEN_FIELD, NEXT_POLL_INTERVAL_IN_SECONDS_FIELD));

    private final SdkBytes configuration;

    private final String contentType;

    private final String nextPollConfigurationToken;

    private final Integer nextPollIntervalInSeconds;

    private GetLatestConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.configuration = builder.configuration;
        this.contentType = builder.contentType;
        this.nextPollConfigurationToken = builder.nextPollConfigurationToken;
        this.nextPollIntervalInSeconds = builder.nextPollIntervalInSeconds;
    }

    /**
     * <p>
     * The data of the configuration. Note that this may be empty if the client already has the latest version of
     * configuration.
     * </p>
     * 
     * @return The data of the configuration. Note that this may be empty if the client already has the latest version
     *         of configuration.
     */
    public final SdkBytes configuration() {
        return configuration;
    }

    /**
     * <p>
     * A standard MIME type describing the format of the configuration content.
     * </p>
     * 
     * @return A standard MIME type describing the format of the configuration content.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The latest token describing the current state of the configuration session. This MUST be provided to the next
     * call to GetLatestConfiguration.
     * </p>
     * 
     * @return The latest token describing the current state of the configuration session. This MUST be provided to the
     *         next call to GetLatestConfiguration.
     */
    public final String nextPollConfigurationToken() {
        return nextPollConfigurationToken;
    }

    /**
     * <p>
     * The amount of time the client should wait before polling for configuration updates again. See
     * RequiredMinimumPollIntervalInSeconds to set the desired poll interval.
     * </p>
     * 
     * @return The amount of time the client should wait before polling for configuration updates again. See
     *         RequiredMinimumPollIntervalInSeconds to set the desired poll interval.
     */
    public final Integer nextPollIntervalInSeconds() {
        return nextPollIntervalInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(nextPollConfigurationToken());
        hashCode = 31 * hashCode + Objects.hashCode(nextPollIntervalInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLatestConfigurationResponse)) {
            return false;
        }
        GetLatestConfigurationResponse other = (GetLatestConfigurationResponse) obj;
        return Objects.equals(configuration(), other.configuration()) && Objects.equals(contentType(), other.contentType())
                && Objects.equals(nextPollConfigurationToken(), other.nextPollConfigurationToken())
                && Objects.equals(nextPollIntervalInSeconds(), other.nextPollIntervalInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLatestConfigurationResponse")
                .add("Configuration", configuration() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ContentType", contentType()).add("NextPollConfigurationToken", nextPollConfigurationToken())
                .add("NextPollIntervalInSeconds", nextPollIntervalInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "NextPollConfigurationToken":
            return Optional.ofNullable(clazz.cast(nextPollConfigurationToken()));
        case "NextPollIntervalInSeconds":
            return Optional.ofNullable(clazz.cast(nextPollIntervalInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLatestConfigurationResponse, T> g) {
        return obj -> g.apply((GetLatestConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppConfigDataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetLatestConfigurationResponse> {
        /**
         * <p>
         * The data of the configuration. Note that this may be empty if the client already has the latest version of
         * configuration.
         * </p>
         * 
         * @param configuration
         *        The data of the configuration. Note that this may be empty if the client already has the latest
         *        version of configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(SdkBytes configuration);

        /**
         * <p>
         * A standard MIME type describing the format of the configuration content.
         * </p>
         * 
         * @param contentType
         *        A standard MIME type describing the format of the configuration content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The latest token describing the current state of the configuration session. This MUST be provided to the next
         * call to GetLatestConfiguration.
         * </p>
         * 
         * @param nextPollConfigurationToken
         *        The latest token describing the current state of the configuration session. This MUST be provided to
         *        the next call to GetLatestConfiguration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPollConfigurationToken(String nextPollConfigurationToken);

        /**
         * <p>
         * The amount of time the client should wait before polling for configuration updates again. See
         * RequiredMinimumPollIntervalInSeconds to set the desired poll interval.
         * </p>
         * 
         * @param nextPollIntervalInSeconds
         *        The amount of time the client should wait before polling for configuration updates again. See
         *        RequiredMinimumPollIntervalInSeconds to set the desired poll interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPollIntervalInSeconds(Integer nextPollIntervalInSeconds);
    }

    static final class BuilderImpl extends AppConfigDataResponse.BuilderImpl implements Builder {
        private SdkBytes configuration;

        private String contentType;

        private String nextPollConfigurationToken;

        private Integer nextPollIntervalInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLatestConfigurationResponse model) {
            super(model);
            configuration(model.configuration);
            contentType(model.contentType);
            nextPollConfigurationToken(model.nextPollConfigurationToken);
            nextPollIntervalInSeconds(model.nextPollIntervalInSeconds);
        }

        public final ByteBuffer getConfiguration() {
            return configuration == null ? null : configuration.asByteBuffer();
        }

        public final void setConfiguration(ByteBuffer configuration) {
            configuration(configuration == null ? null : SdkBytes.fromByteBuffer(configuration));
        }

        @Override
        @Transient
        public final Builder configuration(SdkBytes configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        @Transient
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getNextPollConfigurationToken() {
            return nextPollConfigurationToken;
        }

        public final void setNextPollConfigurationToken(String nextPollConfigurationToken) {
            this.nextPollConfigurationToken = nextPollConfigurationToken;
        }

        @Override
        @Transient
        public final Builder nextPollConfigurationToken(String nextPollConfigurationToken) {
            this.nextPollConfigurationToken = nextPollConfigurationToken;
            return this;
        }

        public final Integer getNextPollIntervalInSeconds() {
            return nextPollIntervalInSeconds;
        }

        public final void setNextPollIntervalInSeconds(Integer nextPollIntervalInSeconds) {
            this.nextPollIntervalInSeconds = nextPollIntervalInSeconds;
        }

        @Override
        @Transient
        public final Builder nextPollIntervalInSeconds(Integer nextPollIntervalInSeconds) {
            this.nextPollIntervalInSeconds = nextPollIntervalInSeconds;
            return this;
        }

        @Override
        public GetLatestConfigurationResponse build() {
            return new GetLatestConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
