/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfigdata.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response parameters for the StartConfigurationSession API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartConfigurationSessionResponse extends AppConfigDataResponse implements
        ToCopyableBuilder<StartConfigurationSessionResponse.Builder, StartConfigurationSessionResponse> {
    private static final SdkField<String> INITIAL_CONFIGURATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitialConfigurationToken").getter(getter(StartConfigurationSessionResponse::initialConfigurationToken))
            .setter(setter(Builder::initialConfigurationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialConfigurationToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INITIAL_CONFIGURATION_TOKEN_FIELD));

    private final String initialConfigurationToken;

    private StartConfigurationSessionResponse(BuilderImpl builder) {
        super(builder);
        this.initialConfigurationToken = builder.initialConfigurationToken;
    }

    /**
     * <p>
     * Token encapsulating state about the configuration session. Provide this token to the GetLatestConfiguration API
     * to retrieve configuration data.
     * </p>
     * <important>
     * <p>
     * This token should only be used once in your first call to GetLatestConfiguration. You MUST use the new token in
     * the GetConfiguration response (NextPollConfigurationToken) in each subsequent call to GetLatestConfiguration.
     * </p>
     * </important>
     * 
     * @return Token encapsulating state about the configuration session. Provide this token to the
     *         GetLatestConfiguration API to retrieve configuration data.</p> <important>
     *         <p>
     *         This token should only be used once in your first call to GetLatestConfiguration. You MUST use the new
     *         token in the GetConfiguration response (NextPollConfigurationToken) in each subsequent call to
     *         GetLatestConfiguration.
     *         </p>
     */
    public final String initialConfigurationToken() {
        return initialConfigurationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(initialConfigurationToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartConfigurationSessionResponse)) {
            return false;
        }
        StartConfigurationSessionResponse other = (StartConfigurationSessionResponse) obj;
        return Objects.equals(initialConfigurationToken(), other.initialConfigurationToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartConfigurationSessionResponse")
                .add("InitialConfigurationToken", initialConfigurationToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InitialConfigurationToken":
            return Optional.ofNullable(clazz.cast(initialConfigurationToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartConfigurationSessionResponse, T> g) {
        return obj -> g.apply((StartConfigurationSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppConfigDataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartConfigurationSessionResponse> {
        /**
         * <p>
         * Token encapsulating state about the configuration session. Provide this token to the GetLatestConfiguration
         * API to retrieve configuration data.
         * </p>
         * <important>
         * <p>
         * This token should only be used once in your first call to GetLatestConfiguration. You MUST use the new token
         * in the GetConfiguration response (NextPollConfigurationToken) in each subsequent call to
         * GetLatestConfiguration.
         * </p>
         * </important>
         * 
         * @param initialConfigurationToken
         *        Token encapsulating state about the configuration session. Provide this token to the
         *        GetLatestConfiguration API to retrieve configuration data.</p> <important>
         *        <p>
         *        This token should only be used once in your first call to GetLatestConfiguration. You MUST use the new
         *        token in the GetConfiguration response (NextPollConfigurationToken) in each subsequent call to
         *        GetLatestConfiguration.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialConfigurationToken(String initialConfigurationToken);
    }

    static final class BuilderImpl extends AppConfigDataResponse.BuilderImpl implements Builder {
        private String initialConfigurationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartConfigurationSessionResponse model) {
            super(model);
            initialConfigurationToken(model.initialConfigurationToken);
        }

        public final String getInitialConfigurationToken() {
            return initialConfigurationToken;
        }

        public final void setInitialConfigurationToken(String initialConfigurationToken) {
            this.initialConfigurationToken = initialConfigurationToken;
        }

        @Override
        @Transient
        public final Builder initialConfigurationToken(String initialConfigurationToken) {
            this.initialConfigurationToken = initialConfigurationToken;
            return this;
        }

        @Override
        public StartConfigurationSessionResponse build() {
            return new StartConfigurationSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
