/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfigdata.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about the input that failed to satisfy the constraints specified by a call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BadRequestDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<BadRequestDetails.Builder, BadRequestDetails> {
    private static final SdkField<Map<String, InvalidParameterDetail>> INVALID_PARAMETERS_FIELD = SdkField
            .<Map<String, InvalidParameterDetail>> builder(MarshallingType.MAP)
            .memberName("InvalidParameters")
            .getter(getter(BadRequestDetails::invalidParameters))
            .setter(setter(Builder::invalidParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<InvalidParameterDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(InvalidParameterDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVALID_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, InvalidParameterDetail> invalidParameters;

    private BadRequestDetails(BuilderImpl builder) {
        this.invalidParameters = builder.invalidParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the InvalidParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInvalidParameters() {
        return invalidParameters != null && !(invalidParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more specified parameters are not valid for the call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInvalidParameters} method.
     * </p>
     * 
     * @return One or more specified parameters are not valid for the call.
     */
    public final Map<String, InvalidParameterDetail> invalidParameters() {
        return invalidParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInvalidParameters() ? invalidParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BadRequestDetails)) {
            return false;
        }
        BadRequestDetails other = (BadRequestDetails) obj;
        return hasInvalidParameters() == other.hasInvalidParameters()
                && Objects.equals(invalidParameters(), other.invalidParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BadRequestDetails")
                .add("InvalidParameters", hasInvalidParameters() ? invalidParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvalidParameters":
            return Optional.ofNullable(clazz.cast(invalidParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BadRequestDetails, T> g) {
        return obj -> g.apply((BadRequestDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BadRequestDetails> {
        /**
         * <p>
         * One or more specified parameters are not valid for the call.
         * </p>
         * 
         * @param invalidParameters
         *        One or more specified parameters are not valid for the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidParameters(Map<String, InvalidParameterDetail> invalidParameters);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, InvalidParameterDetail> invalidParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BadRequestDetails model) {
            invalidParameters(model.invalidParameters);
        }

        public final Map<String, InvalidParameterDetail.Builder> getInvalidParameters() {
            Map<String, InvalidParameterDetail.Builder> result = InvalidParameterMapCopier.copyToBuilder(this.invalidParameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setInvalidParameters(Map<String, InvalidParameterDetail.BuilderImpl> invalidParameters) {
            this.invalidParameters = InvalidParameterMapCopier.copyFromBuilder(invalidParameters);
        }

        @Override
        @Transient
        public final Builder invalidParameters(Map<String, InvalidParameterDetail> invalidParameters) {
            this.invalidParameters = InvalidParameterMapCopier.copy(invalidParameters);
            return this;
        }

        @Override
        public BadRequestDetails build() {
            return new BadRequestDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
