/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfigdata.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an invalid parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvalidParameterDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<InvalidParameterDetail.Builder, InvalidParameterDetail> {
    private static final SdkField<String> PROBLEM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Problem")
            .getter(getter(InvalidParameterDetail::problemAsString)).setter(setter(Builder::problem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Problem").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROBLEM_FIELD));

    private static final long serialVersionUID = 1L;

    private final String problem;

    private InvalidParameterDetail(BuilderImpl builder) {
        this.problem = builder.problem;
    }

    /**
     * <p>
     * The reason the parameter is invalid.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #problem} will
     * return {@link InvalidParameterProblem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #problemAsString}.
     * </p>
     * 
     * @return The reason the parameter is invalid.
     * @see InvalidParameterProblem
     */
    public final InvalidParameterProblem problem() {
        return InvalidParameterProblem.fromValue(problem);
    }

    /**
     * <p>
     * The reason the parameter is invalid.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #problem} will
     * return {@link InvalidParameterProblem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #problemAsString}.
     * </p>
     * 
     * @return The reason the parameter is invalid.
     * @see InvalidParameterProblem
     */
    public final String problemAsString() {
        return problem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(problemAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvalidParameterDetail)) {
            return false;
        }
        InvalidParameterDetail other = (InvalidParameterDetail) obj;
        return Objects.equals(problemAsString(), other.problemAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvalidParameterDetail").add("Problem", problemAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Problem":
            return Optional.ofNullable(clazz.cast(problemAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvalidParameterDetail, T> g) {
        return obj -> g.apply((InvalidParameterDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvalidParameterDetail> {
        /**
         * <p>
         * The reason the parameter is invalid.
         * </p>
         * 
         * @param problem
         *        The reason the parameter is invalid.
         * @see InvalidParameterProblem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvalidParameterProblem
         */
        Builder problem(String problem);

        /**
         * <p>
         * The reason the parameter is invalid.
         * </p>
         * 
         * @param problem
         *        The reason the parameter is invalid.
         * @see InvalidParameterProblem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvalidParameterProblem
         */
        Builder problem(InvalidParameterProblem problem);
    }

    static final class BuilderImpl implements Builder {
        private String problem;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidParameterDetail model) {
            problem(model.problem);
        }

        public final String getProblem() {
            return problem;
        }

        public final void setProblem(String problem) {
            this.problem = problem;
        }

        @Override
        @Transient
        public final Builder problem(String problem) {
            this.problem = problem;
            return this;
        }

        @Override
        @Transient
        public final Builder problem(InvalidParameterProblem problem) {
            this.problem(problem == null ? null : problem.toString());
            return this;
        }

        @Override
        public InvalidParameterDetail build() {
            return new InvalidParameterDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
