/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfigdata;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.appconfigdata.model.GetLatestConfigurationRequest;
import software.amazon.awssdk.services.appconfigdata.model.GetLatestConfigurationResponse;
import software.amazon.awssdk.services.appconfigdata.model.StartConfigurationSessionRequest;
import software.amazon.awssdk.services.appconfigdata.model.StartConfigurationSessionResponse;

/**
 * Service client for accessing AWS AppConfig Data asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Use the AppConfigData API, a capability of AWS AppConfig, to retrieve deployed configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AppConfigDataAsyncClient extends SdkClient {
    String SERVICE_NAME = "appconfig";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "appconfigdata";

    /**
     * Create a {@link AppConfigDataAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AppConfigDataAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AppConfigDataAsyncClient}.
     */
    static AppConfigDataAsyncClientBuilder builder() {
        return new DefaultAppConfigDataAsyncClientBuilder();
    }

    /**
     * <p>
     * Retrieves the latest deployed configuration. This API may return empty Configuration data if the client already
     * has the latest version. See StartConfigurationSession to obtain an InitialConfigurationToken to call this API.
     * </p>
     * <important>
     * <p>
     * Each call to GetLatestConfiguration returns a new ConfigurationToken (NextPollConfigurationToken in the
     * response). This new token MUST be provided to the next call to GetLatestConfiguration when polling for
     * configuration updates.
     * </p>
     * <p>
     * To avoid excess charges, we recommend that you include the <code>ClientConfigurationVersion</code> value with
     * every call to <code>GetConfiguration</code>. This value must be saved on your client. Subsequent calls to
     * <code>GetConfiguration</code> must pass this value by using the <code>ClientConfigurationVersion</code>
     * parameter.
     * </p>
     * </important>
     *
     * @param getLatestConfigurationRequest
     *        Request parameters for the GetLatestConfiguration API
     * @return A Java Future containing the result of the GetLatestConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException There was an internal failure in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigDataAsyncClient.GetLatestConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfigdata-2021-11-11/GetLatestConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLatestConfigurationResponse> getLatestConfiguration(
            GetLatestConfigurationRequest getLatestConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the latest deployed configuration. This API may return empty Configuration data if the client already
     * has the latest version. See StartConfigurationSession to obtain an InitialConfigurationToken to call this API.
     * </p>
     * <important>
     * <p>
     * Each call to GetLatestConfiguration returns a new ConfigurationToken (NextPollConfigurationToken in the
     * response). This new token MUST be provided to the next call to GetLatestConfiguration when polling for
     * configuration updates.
     * </p>
     * <p>
     * To avoid excess charges, we recommend that you include the <code>ClientConfigurationVersion</code> value with
     * every call to <code>GetConfiguration</code>. This value must be saved on your client. Subsequent calls to
     * <code>GetConfiguration</code> must pass this value by using the <code>ClientConfigurationVersion</code>
     * parameter.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLatestConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link GetLatestConfigurationRequest#builder()}
     * </p>
     *
     * @param getLatestConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetLatestConfigurationRequest.Builder} to create a
     *        request. Request parameters for the GetLatestConfiguration API
     * @return A Java Future containing the result of the GetLatestConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException There was an internal failure in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigDataAsyncClient.GetLatestConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfigdata-2021-11-11/GetLatestConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLatestConfigurationResponse> getLatestConfiguration(
            Consumer<GetLatestConfigurationRequest.Builder> getLatestConfigurationRequest) {
        return getLatestConfiguration(GetLatestConfigurationRequest.builder().applyMutation(getLatestConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Starts a configuration session used to retrieve a deployed configuration. See the GetLatestConfiguration API for
     * more details.
     * </p>
     *
     * @param startConfigurationSessionRequest
     *        Request parameters for the StartConfigurationSession API.
     * @return A Java Future containing the result of the StartConfigurationSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException There was an internal failure in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigDataAsyncClient.StartConfigurationSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfigdata-2021-11-11/StartConfigurationSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartConfigurationSessionResponse> startConfigurationSession(
            StartConfigurationSessionRequest startConfigurationSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a configuration session used to retrieve a deployed configuration. See the GetLatestConfiguration API for
     * more details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartConfigurationSessionRequest.Builder} avoiding
     * the need to create one manually via {@link StartConfigurationSessionRequest#builder()}
     * </p>
     *
     * @param startConfigurationSessionRequest
     *        A {@link Consumer} that will call methods on {@link StartConfigurationSessionRequest.Builder} to create a
     *        request. Request parameters for the StartConfigurationSession API.
     * @return A Java Future containing the result of the StartConfigurationSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>BadRequestException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException There was an internal failure in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppConfigDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppConfigDataAsyncClient.StartConfigurationSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appconfigdata-2021-11-11/StartConfigurationSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartConfigurationSessionResponse> startConfigurationSession(
            Consumer<StartConfigurationSessionRequest.Builder> startConfigurationSessionRequest) {
        return startConfigurationSession(StartConfigurationSessionRequest.builder()
                .applyMutation(startConfigurationSessionRequest).build());
    }
}
