/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfigdata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLatestConfigurationRequest extends AppConfigDataRequest implements
        ToCopyableBuilder<GetLatestConfigurationRequest.Builder, GetLatestConfigurationRequest> {
    private static final SdkField<String> CONFIGURATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationToken").getter(getter(GetLatestConfigurationRequest::configurationToken))
            .setter(setter(Builder::configurationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("configuration_token").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("configuration_token", CONFIGURATION_TOKEN_FIELD);
                }
            });

    private final String configurationToken;

    private GetLatestConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.configurationToken = builder.configurationToken;
    }

    /**
     * <p>
     * Token describing the current state of the configuration session. To obtain a token, first call the
     * <a>StartConfigurationSession</a> API. Note that every call to <code>GetLatestConfiguration</code> will return a
     * new <code>ConfigurationToken</code> (<code>NextPollConfigurationToken</code> in the response) and <i>must</i> be
     * provided to subsequent <code>GetLatestConfiguration</code> API calls.
     * </p>
     * <important>
     * <p>
     * This token should only be used once. To support long poll use cases, the token is valid for up to 24 hours. If a
     * <code>GetLatestConfiguration</code> call uses an expired token, the system returns
     * <code>BadRequestException</code>.
     * </p>
     * </important>
     * 
     * @return Token describing the current state of the configuration session. To obtain a token, first call the
     *         <a>StartConfigurationSession</a> API. Note that every call to <code>GetLatestConfiguration</code> will
     *         return a new <code>ConfigurationToken</code> (<code>NextPollConfigurationToken</code> in the response)
     *         and <i>must</i> be provided to subsequent <code>GetLatestConfiguration</code> API calls.</p> <important>
     *         <p>
     *         This token should only be used once. To support long poll use cases, the token is valid for up to 24
     *         hours. If a <code>GetLatestConfiguration</code> call uses an expired token, the system returns
     *         <code>BadRequestException</code>.
     *         </p>
     */
    public final String configurationToken() {
        return configurationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLatestConfigurationRequest)) {
            return false;
        }
        GetLatestConfigurationRequest other = (GetLatestConfigurationRequest) obj;
        return Objects.equals(configurationToken(), other.configurationToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLatestConfigurationRequest").add("ConfigurationToken", configurationToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationToken":
            return Optional.ofNullable(clazz.cast(configurationToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetLatestConfigurationRequest, T> g) {
        return obj -> g.apply((GetLatestConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppConfigDataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetLatestConfigurationRequest> {
        /**
         * <p>
         * Token describing the current state of the configuration session. To obtain a token, first call the
         * <a>StartConfigurationSession</a> API. Note that every call to <code>GetLatestConfiguration</code> will return
         * a new <code>ConfigurationToken</code> (<code>NextPollConfigurationToken</code> in the response) and
         * <i>must</i> be provided to subsequent <code>GetLatestConfiguration</code> API calls.
         * </p>
         * <important>
         * <p>
         * This token should only be used once. To support long poll use cases, the token is valid for up to 24 hours.
         * If a <code>GetLatestConfiguration</code> call uses an expired token, the system returns
         * <code>BadRequestException</code>.
         * </p>
         * </important>
         * 
         * @param configurationToken
         *        Token describing the current state of the configuration session. To obtain a token, first call the
         *        <a>StartConfigurationSession</a> API. Note that every call to <code>GetLatestConfiguration</code> will
         *        return a new <code>ConfigurationToken</code> (<code>NextPollConfigurationToken</code> in the response)
         *        and <i>must</i> be provided to subsequent <code>GetLatestConfiguration</code> API calls.</p>
         *        <important>
         *        <p>
         *        This token should only be used once. To support long poll use cases, the token is valid for up to 24
         *        hours. If a <code>GetLatestConfiguration</code> call uses an expired token, the system returns
         *        <code>BadRequestException</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationToken(String configurationToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppConfigDataRequest.BuilderImpl implements Builder {
        private String configurationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLatestConfigurationRequest model) {
            super(model);
            configurationToken(model.configurationToken);
        }

        public final String getConfigurationToken() {
            return configurationToken;
        }

        public final void setConfigurationToken(String configurationToken) {
            this.configurationToken = configurationToken;
        }

        @Override
        public final Builder configurationToken(String configurationToken) {
            this.configurationToken = configurationToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLatestConfigurationRequest build() {
            return new GetLatestConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
