/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfigdata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartConfigurationSessionRequest extends AppConfigDataRequest implements
        ToCopyableBuilder<StartConfigurationSessionRequest.Builder, StartConfigurationSessionRequest> {
    private static final SdkField<String> APPLICATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationIdentifier").getter(getter(StartConfigurationSessionRequest::applicationIdentifier))
            .setter(setter(Builder::applicationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationIdentifier").build())
            .build();

    private static final SdkField<String> ENVIRONMENT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentIdentifier").getter(getter(StartConfigurationSessionRequest::environmentIdentifier))
            .setter(setter(Builder::environmentIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentIdentifier").build())
            .build();

    private static final SdkField<String> CONFIGURATION_PROFILE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationProfileIdentifier")
            .getter(getter(StartConfigurationSessionRequest::configurationProfileIdentifier))
            .setter(setter(Builder::configurationProfileIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationProfileIdentifier")
                    .build()).build();

    private static final SdkField<Integer> REQUIRED_MINIMUM_POLL_INTERVAL_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("RequiredMinimumPollIntervalInSeconds")
            .getter(getter(StartConfigurationSessionRequest::requiredMinimumPollIntervalInSeconds))
            .setter(setter(Builder::requiredMinimumPollIntervalInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("RequiredMinimumPollIntervalInSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(APPLICATION_IDENTIFIER_FIELD, ENVIRONMENT_IDENTIFIER_FIELD, CONFIGURATION_PROFILE_IDENTIFIER_FIELD,
                    REQUIRED_MINIMUM_POLL_INTERVAL_IN_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationIdentifier;

    private final String environmentIdentifier;

    private final String configurationProfileIdentifier;

    private final Integer requiredMinimumPollIntervalInSeconds;

    private StartConfigurationSessionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationIdentifier = builder.applicationIdentifier;
        this.environmentIdentifier = builder.environmentIdentifier;
        this.configurationProfileIdentifier = builder.configurationProfileIdentifier;
        this.requiredMinimumPollIntervalInSeconds = builder.requiredMinimumPollIntervalInSeconds;
    }

    /**
     * <p>
     * The application ID or the application name.
     * </p>
     * 
     * @return The application ID or the application name.
     */
    public final String applicationIdentifier() {
        return applicationIdentifier;
    }

    /**
     * <p>
     * The environment ID or the environment name.
     * </p>
     * 
     * @return The environment ID or the environment name.
     */
    public final String environmentIdentifier() {
        return environmentIdentifier;
    }

    /**
     * <p>
     * The configuration profile ID or the configuration profile name.
     * </p>
     * 
     * @return The configuration profile ID or the configuration profile name.
     */
    public final String configurationProfileIdentifier() {
        return configurationProfileIdentifier;
    }

    /**
     * <p>
     * Sets a constraint on a session. If you specify a value of, for example, 60 seconds, then the client that
     * established the session can't call <a>GetLatestConfiguration</a> more frequently than every 60 seconds.
     * </p>
     * 
     * @return Sets a constraint on a session. If you specify a value of, for example, 60 seconds, then the client that
     *         established the session can't call <a>GetLatestConfiguration</a> more frequently than every 60 seconds.
     */
    public final Integer requiredMinimumPollIntervalInSeconds() {
        return requiredMinimumPollIntervalInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(environmentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(configurationProfileIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(requiredMinimumPollIntervalInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartConfigurationSessionRequest)) {
            return false;
        }
        StartConfigurationSessionRequest other = (StartConfigurationSessionRequest) obj;
        return Objects.equals(applicationIdentifier(), other.applicationIdentifier())
                && Objects.equals(environmentIdentifier(), other.environmentIdentifier())
                && Objects.equals(configurationProfileIdentifier(), other.configurationProfileIdentifier())
                && Objects.equals(requiredMinimumPollIntervalInSeconds(), other.requiredMinimumPollIntervalInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartConfigurationSessionRequest").add("ApplicationIdentifier", applicationIdentifier())
                .add("EnvironmentIdentifier", environmentIdentifier())
                .add("ConfigurationProfileIdentifier", configurationProfileIdentifier())
                .add("RequiredMinimumPollIntervalInSeconds", requiredMinimumPollIntervalInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationIdentifier":
            return Optional.ofNullable(clazz.cast(applicationIdentifier()));
        case "EnvironmentIdentifier":
            return Optional.ofNullable(clazz.cast(environmentIdentifier()));
        case "ConfigurationProfileIdentifier":
            return Optional.ofNullable(clazz.cast(configurationProfileIdentifier()));
        case "RequiredMinimumPollIntervalInSeconds":
            return Optional.ofNullable(clazz.cast(requiredMinimumPollIntervalInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationIdentifier", APPLICATION_IDENTIFIER_FIELD);
        map.put("EnvironmentIdentifier", ENVIRONMENT_IDENTIFIER_FIELD);
        map.put("ConfigurationProfileIdentifier", CONFIGURATION_PROFILE_IDENTIFIER_FIELD);
        map.put("RequiredMinimumPollIntervalInSeconds", REQUIRED_MINIMUM_POLL_INTERVAL_IN_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartConfigurationSessionRequest, T> g) {
        return obj -> g.apply((StartConfigurationSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppConfigDataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartConfigurationSessionRequest> {
        /**
         * <p>
         * The application ID or the application name.
         * </p>
         * 
         * @param applicationIdentifier
         *        The application ID or the application name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationIdentifier(String applicationIdentifier);

        /**
         * <p>
         * The environment ID or the environment name.
         * </p>
         * 
         * @param environmentIdentifier
         *        The environment ID or the environment name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentIdentifier(String environmentIdentifier);

        /**
         * <p>
         * The configuration profile ID or the configuration profile name.
         * </p>
         * 
         * @param configurationProfileIdentifier
         *        The configuration profile ID or the configuration profile name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationProfileIdentifier(String configurationProfileIdentifier);

        /**
         * <p>
         * Sets a constraint on a session. If you specify a value of, for example, 60 seconds, then the client that
         * established the session can't call <a>GetLatestConfiguration</a> more frequently than every 60 seconds.
         * </p>
         * 
         * @param requiredMinimumPollIntervalInSeconds
         *        Sets a constraint on a session. If you specify a value of, for example, 60 seconds, then the client
         *        that established the session can't call <a>GetLatestConfiguration</a> more frequently than every 60
         *        seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredMinimumPollIntervalInSeconds(Integer requiredMinimumPollIntervalInSeconds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppConfigDataRequest.BuilderImpl implements Builder {
        private String applicationIdentifier;

        private String environmentIdentifier;

        private String configurationProfileIdentifier;

        private Integer requiredMinimumPollIntervalInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(StartConfigurationSessionRequest model) {
            super(model);
            applicationIdentifier(model.applicationIdentifier);
            environmentIdentifier(model.environmentIdentifier);
            configurationProfileIdentifier(model.configurationProfileIdentifier);
            requiredMinimumPollIntervalInSeconds(model.requiredMinimumPollIntervalInSeconds);
        }

        public final String getApplicationIdentifier() {
            return applicationIdentifier;
        }

        public final void setApplicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
        }

        @Override
        public final Builder applicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
            return this;
        }

        public final String getEnvironmentIdentifier() {
            return environmentIdentifier;
        }

        public final void setEnvironmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
        }

        @Override
        public final Builder environmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        public final String getConfigurationProfileIdentifier() {
            return configurationProfileIdentifier;
        }

        public final void setConfigurationProfileIdentifier(String configurationProfileIdentifier) {
            this.configurationProfileIdentifier = configurationProfileIdentifier;
        }

        @Override
        public final Builder configurationProfileIdentifier(String configurationProfileIdentifier) {
            this.configurationProfileIdentifier = configurationProfileIdentifier;
            return this;
        }

        public final Integer getRequiredMinimumPollIntervalInSeconds() {
            return requiredMinimumPollIntervalInSeconds;
        }

        public final void setRequiredMinimumPollIntervalInSeconds(Integer requiredMinimumPollIntervalInSeconds) {
            this.requiredMinimumPollIntervalInSeconds = requiredMinimumPollIntervalInSeconds;
        }

        @Override
        public final Builder requiredMinimumPollIntervalInSeconds(Integer requiredMinimumPollIntervalInSeconds) {
            this.requiredMinimumPollIntervalInSeconds = requiredMinimumPollIntervalInSeconds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartConfigurationSessionRequest build() {
            return new StartConfigurationSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
