/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appfabric.model.AppFabricResponse;
import software.amazon.awssdk.services.appfabric.model.UserAccessTaskItem;
import software.amazon.awssdk.services.appfabric.model.UserAccessTasksListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartUserAccessTasksResponse
extends AppFabricResponse
implements ToCopyableBuilder<Builder, StartUserAccessTasksResponse> {
    private static final SdkField<List<UserAccessTaskItem>> USER_ACCESS_TASKS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userAccessTasksList").getter(StartUserAccessTasksResponse.getter(StartUserAccessTasksResponse::userAccessTasksList)).setter(StartUserAccessTasksResponse.setter(Builder::userAccessTasksList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAccessTasksList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserAccessTaskItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ACCESS_TASKS_LIST_FIELD));
    private final List<UserAccessTaskItem> userAccessTasksList;

    private StartUserAccessTasksResponse(BuilderImpl builder) {
        super(builder);
        this.userAccessTasksList = builder.userAccessTasksList;
    }

    public final boolean hasUserAccessTasksList() {
        return this.userAccessTasksList != null && !(this.userAccessTasksList instanceof SdkAutoConstructList);
    }

    public final List<UserAccessTaskItem> userAccessTasksList() {
        return this.userAccessTasksList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserAccessTasksList() ? this.userAccessTasksList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartUserAccessTasksResponse)) {
            return false;
        }
        StartUserAccessTasksResponse other = (StartUserAccessTasksResponse)((Object)obj);
        return this.hasUserAccessTasksList() == other.hasUserAccessTasksList() && Objects.equals(this.userAccessTasksList(), other.userAccessTasksList());
    }

    public final String toString() {
        return ToString.builder((String)"StartUserAccessTasksResponse").add("UserAccessTasksList", this.hasUserAccessTasksList() ? this.userAccessTasksList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userAccessTasksList": {
                return Optional.ofNullable(clazz.cast(this.userAccessTasksList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartUserAccessTasksResponse, T> g) {
        return obj -> g.apply((StartUserAccessTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppFabricResponse.BuilderImpl
    implements Builder {
        private List<UserAccessTaskItem> userAccessTasksList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartUserAccessTasksResponse model) {
            super(model);
            this.userAccessTasksList(model.userAccessTasksList);
        }

        public final List<UserAccessTaskItem.Builder> getUserAccessTasksList() {
            List<UserAccessTaskItem.Builder> result = UserAccessTasksListCopier.copyToBuilder(this.userAccessTasksList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserAccessTasksList(Collection<UserAccessTaskItem.BuilderImpl> userAccessTasksList) {
            this.userAccessTasksList = UserAccessTasksListCopier.copyFromBuilder(userAccessTasksList);
        }

        @Override
        public final Builder userAccessTasksList(Collection<UserAccessTaskItem> userAccessTasksList) {
            this.userAccessTasksList = UserAccessTasksListCopier.copy(userAccessTasksList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAccessTasksList(UserAccessTaskItem ... userAccessTasksList) {
            this.userAccessTasksList(Arrays.asList(userAccessTasksList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAccessTasksList(Consumer<UserAccessTaskItem.Builder> ... userAccessTasksList) {
            this.userAccessTasksList(Stream.of(userAccessTasksList).map(c -> (UserAccessTaskItem)((UserAccessTaskItem.Builder)UserAccessTaskItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public StartUserAccessTasksResponse build() {
            return new StartUserAccessTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppFabricResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartUserAccessTasksResponse> {
        public Builder userAccessTasksList(Collection<UserAccessTaskItem> var1);

        public Builder userAccessTasksList(UserAccessTaskItem ... var1);

        public Builder userAccessTasksList(Consumer<UserAccessTaskItem.Builder> ... var1);
    }
}

