/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appfabric;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.appfabric.model.BatchGetUserAccessTasksRequest;
import software.amazon.awssdk.services.appfabric.model.BatchGetUserAccessTasksResponse;
import software.amazon.awssdk.services.appfabric.model.ConnectAppAuthorizationRequest;
import software.amazon.awssdk.services.appfabric.model.ConnectAppAuthorizationResponse;
import software.amazon.awssdk.services.appfabric.model.CreateAppAuthorizationRequest;
import software.amazon.awssdk.services.appfabric.model.CreateAppAuthorizationResponse;
import software.amazon.awssdk.services.appfabric.model.CreateAppBundleRequest;
import software.amazon.awssdk.services.appfabric.model.CreateAppBundleResponse;
import software.amazon.awssdk.services.appfabric.model.CreateIngestionDestinationRequest;
import software.amazon.awssdk.services.appfabric.model.CreateIngestionDestinationResponse;
import software.amazon.awssdk.services.appfabric.model.CreateIngestionRequest;
import software.amazon.awssdk.services.appfabric.model.CreateIngestionResponse;
import software.amazon.awssdk.services.appfabric.model.DeleteAppAuthorizationRequest;
import software.amazon.awssdk.services.appfabric.model.DeleteAppAuthorizationResponse;
import software.amazon.awssdk.services.appfabric.model.DeleteAppBundleRequest;
import software.amazon.awssdk.services.appfabric.model.DeleteAppBundleResponse;
import software.amazon.awssdk.services.appfabric.model.DeleteIngestionDestinationRequest;
import software.amazon.awssdk.services.appfabric.model.DeleteIngestionDestinationResponse;
import software.amazon.awssdk.services.appfabric.model.DeleteIngestionRequest;
import software.amazon.awssdk.services.appfabric.model.DeleteIngestionResponse;
import software.amazon.awssdk.services.appfabric.model.GetAppAuthorizationRequest;
import software.amazon.awssdk.services.appfabric.model.GetAppAuthorizationResponse;
import software.amazon.awssdk.services.appfabric.model.GetAppBundleRequest;
import software.amazon.awssdk.services.appfabric.model.GetAppBundleResponse;
import software.amazon.awssdk.services.appfabric.model.GetIngestionDestinationRequest;
import software.amazon.awssdk.services.appfabric.model.GetIngestionDestinationResponse;
import software.amazon.awssdk.services.appfabric.model.GetIngestionRequest;
import software.amazon.awssdk.services.appfabric.model.GetIngestionResponse;
import software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsRequest;
import software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsResponse;
import software.amazon.awssdk.services.appfabric.model.ListAppBundlesRequest;
import software.amazon.awssdk.services.appfabric.model.ListAppBundlesResponse;
import software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsRequest;
import software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsResponse;
import software.amazon.awssdk.services.appfabric.model.ListIngestionsRequest;
import software.amazon.awssdk.services.appfabric.model.ListIngestionsResponse;
import software.amazon.awssdk.services.appfabric.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.appfabric.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.appfabric.model.StartIngestionRequest;
import software.amazon.awssdk.services.appfabric.model.StartIngestionResponse;
import software.amazon.awssdk.services.appfabric.model.StartUserAccessTasksRequest;
import software.amazon.awssdk.services.appfabric.model.StartUserAccessTasksResponse;
import software.amazon.awssdk.services.appfabric.model.StopIngestionRequest;
import software.amazon.awssdk.services.appfabric.model.StopIngestionResponse;
import software.amazon.awssdk.services.appfabric.model.TagResourceRequest;
import software.amazon.awssdk.services.appfabric.model.TagResourceResponse;
import software.amazon.awssdk.services.appfabric.model.UntagResourceRequest;
import software.amazon.awssdk.services.appfabric.model.UntagResourceResponse;
import software.amazon.awssdk.services.appfabric.model.UpdateAppAuthorizationRequest;
import software.amazon.awssdk.services.appfabric.model.UpdateAppAuthorizationResponse;
import software.amazon.awssdk.services.appfabric.model.UpdateIngestionDestinationRequest;
import software.amazon.awssdk.services.appfabric.model.UpdateIngestionDestinationResponse;
import software.amazon.awssdk.services.appfabric.paginators.ListAppAuthorizationsPublisher;
import software.amazon.awssdk.services.appfabric.paginators.ListAppBundlesPublisher;
import software.amazon.awssdk.services.appfabric.paginators.ListIngestionDestinationsPublisher;
import software.amazon.awssdk.services.appfabric.paginators.ListIngestionsPublisher;

/**
 * Service client for accessing AppFabric asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@link SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * Amazon Web Services AppFabric quickly connects software as a service (SaaS) applications across your organization.
 * This allows IT and security teams to easily manage and secure applications using a standard schema, and employees can
 * complete everyday tasks faster using generative artificial intelligence (AI). You can use these APIs to complete
 * AppFabric tasks, such as setting up audit log ingestions or viewing user access. For more information about
 * AppFabric, including the required permissions to use the service, see the <a
 * href="https://docs.aws.amazon.com/appfabric/latest/adminguide/">Amazon Web Services AppFabric Administration
 * Guide</a>. For more information about using the Command Line Interface (CLI) to manage your AppFabric resources, see
 * the <a href="https://docs.aws.amazon.com/cli/latest/reference/appfabric/index.html">AppFabric section of the CLI
 * Reference</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AppFabricAsyncClient extends AwsClient {
    String SERVICE_NAME = "appfabric";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "appfabric";

    /**
     * <p>
     * Gets user access details in a batch request.
     * </p>
     * <p>
     * This action polls data from the tasks that are kicked off by the <code>StartUserAccessTasks</code> action.
     * </p>
     *
     * @param batchGetUserAccessTasksRequest
     * @return A Java Future containing the result of the BatchGetUserAccessTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.BatchGetUserAccessTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/BatchGetUserAccessTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetUserAccessTasksResponse> batchGetUserAccessTasks(
            BatchGetUserAccessTasksRequest batchGetUserAccessTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets user access details in a batch request.
     * </p>
     * <p>
     * This action polls data from the tasks that are kicked off by the <code>StartUserAccessTasks</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetUserAccessTasksRequest.Builder} avoiding
     * the need to create one manually via {@link BatchGetUserAccessTasksRequest#builder()}
     * </p>
     *
     * @param batchGetUserAccessTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.BatchGetUserAccessTasksRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchGetUserAccessTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.BatchGetUserAccessTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/BatchGetUserAccessTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetUserAccessTasksResponse> batchGetUserAccessTasks(
            Consumer<BatchGetUserAccessTasksRequest.Builder> batchGetUserAccessTasksRequest) {
        return batchGetUserAccessTasks(BatchGetUserAccessTasksRequest.builder().applyMutation(batchGetUserAccessTasksRequest)
                .build());
    }

    /**
     * <p>
     * Establishes a connection between Amazon Web Services AppFabric and an application, which allows AppFabric to call
     * the APIs of the application.
     * </p>
     *
     * @param connectAppAuthorizationRequest
     * @return A Java Future containing the result of the ConnectAppAuthorization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.ConnectAppAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ConnectAppAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ConnectAppAuthorizationResponse> connectAppAuthorization(
            ConnectAppAuthorizationRequest connectAppAuthorizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Establishes a connection between Amazon Web Services AppFabric and an application, which allows AppFabric to call
     * the APIs of the application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConnectAppAuthorizationRequest.Builder} avoiding
     * the need to create one manually via {@link ConnectAppAuthorizationRequest#builder()}
     * </p>
     *
     * @param connectAppAuthorizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.ConnectAppAuthorizationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ConnectAppAuthorization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.ConnectAppAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ConnectAppAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ConnectAppAuthorizationResponse> connectAppAuthorization(
            Consumer<ConnectAppAuthorizationRequest.Builder> connectAppAuthorizationRequest) {
        return connectAppAuthorization(ConnectAppAuthorizationRequest.builder().applyMutation(connectAppAuthorizationRequest)
                .build());
    }

    /**
     * <p>
     * Creates an app authorization within an app bundle, which allows AppFabric to connect to an application.
     * </p>
     *
     * @param createAppAuthorizationRequest
     * @return A Java Future containing the result of the CreateAppAuthorization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ConflictException The request has created a conflict. Check the request parameters and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.CreateAppAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/CreateAppAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAppAuthorizationResponse> createAppAuthorization(
            CreateAppAuthorizationRequest createAppAuthorizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an app authorization within an app bundle, which allows AppFabric to connect to an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAppAuthorizationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAppAuthorizationRequest#builder()}
     * </p>
     *
     * @param createAppAuthorizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.CreateAppAuthorizationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAppAuthorization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ConflictException The request has created a conflict. Check the request parameters and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.CreateAppAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/CreateAppAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAppAuthorizationResponse> createAppAuthorization(
            Consumer<CreateAppAuthorizationRequest.Builder> createAppAuthorizationRequest) {
        return createAppAuthorization(CreateAppAuthorizationRequest.builder().applyMutation(createAppAuthorizationRequest)
                .build());
    }

    /**
     * <p>
     * Creates an app bundle to collect data from an application using AppFabric.
     * </p>
     *
     * @param createAppBundleRequest
     * @return A Java Future containing the result of the CreateAppBundle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ConflictException The request has created a conflict. Check the request parameters and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.CreateAppBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/CreateAppBundle" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAppBundleResponse> createAppBundle(CreateAppBundleRequest createAppBundleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an app bundle to collect data from an application using AppFabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAppBundleRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAppBundleRequest#builder()}
     * </p>
     *
     * @param createAppBundleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.CreateAppBundleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAppBundle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ConflictException The request has created a conflict. Check the request parameters and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.CreateAppBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/CreateAppBundle" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAppBundleResponse> createAppBundle(
            Consumer<CreateAppBundleRequest.Builder> createAppBundleRequest) {
        return createAppBundle(CreateAppBundleRequest.builder().applyMutation(createAppBundleRequest).build());
    }

    /**
     * <p>
     * Creates a data ingestion for an application.
     * </p>
     *
     * @param createIngestionRequest
     * @return A Java Future containing the result of the CreateIngestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ConflictException The request has created a conflict. Check the request parameters and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.CreateIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/CreateIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIngestionResponse> createIngestion(CreateIngestionRequest createIngestionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data ingestion for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIngestionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateIngestionRequest#builder()}
     * </p>
     *
     * @param createIngestionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.CreateIngestionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateIngestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ConflictException The request has created a conflict. Check the request parameters and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.CreateIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/CreateIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIngestionResponse> createIngestion(
            Consumer<CreateIngestionRequest.Builder> createIngestionRequest) {
        return createIngestion(CreateIngestionRequest.builder().applyMutation(createIngestionRequest).build());
    }

    /**
     * <p>
     * Creates an ingestion destination, which specifies how an application's ingested data is processed by Amazon Web
     * Services AppFabric and where it's delivered.
     * </p>
     *
     * @param createIngestionDestinationRequest
     * @return A Java Future containing the result of the CreateIngestionDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ConflictException The request has created a conflict. Check the request parameters and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.CreateIngestionDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/CreateIngestionDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIngestionDestinationResponse> createIngestionDestination(
            CreateIngestionDestinationRequest createIngestionDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an ingestion destination, which specifies how an application's ingested data is processed by Amazon Web
     * Services AppFabric and where it's delivered.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIngestionDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateIngestionDestinationRequest#builder()}
     * </p>
     *
     * @param createIngestionDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.CreateIngestionDestinationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateIngestionDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ConflictException The request has created a conflict. Check the request parameters and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.CreateIngestionDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/CreateIngestionDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIngestionDestinationResponse> createIngestionDestination(
            Consumer<CreateIngestionDestinationRequest.Builder> createIngestionDestinationRequest) {
        return createIngestionDestination(CreateIngestionDestinationRequest.builder()
                .applyMutation(createIngestionDestinationRequest).build());
    }

    /**
     * <p>
     * Deletes an app authorization. You must delete the associated ingestion before you can delete an app
     * authorization.
     * </p>
     *
     * @param deleteAppAuthorizationRequest
     * @return A Java Future containing the result of the DeleteAppAuthorization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.DeleteAppAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteAppAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAppAuthorizationResponse> deleteAppAuthorization(
            DeleteAppAuthorizationRequest deleteAppAuthorizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an app authorization. You must delete the associated ingestion before you can delete an app
     * authorization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAppAuthorizationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAppAuthorizationRequest#builder()}
     * </p>
     *
     * @param deleteAppAuthorizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.DeleteAppAuthorizationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAppAuthorization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.DeleteAppAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteAppAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAppAuthorizationResponse> deleteAppAuthorization(
            Consumer<DeleteAppAuthorizationRequest.Builder> deleteAppAuthorizationRequest) {
        return deleteAppAuthorization(DeleteAppAuthorizationRequest.builder().applyMutation(deleteAppAuthorizationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an app bundle. You must delete all associated app authorizations before you can delete an app bundle.
     * </p>
     *
     * @param deleteAppBundleRequest
     * @return A Java Future containing the result of the DeleteAppBundle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ConflictException The request has created a conflict. Check the request parameters and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.DeleteAppBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteAppBundle" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAppBundleResponse> deleteAppBundle(DeleteAppBundleRequest deleteAppBundleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an app bundle. You must delete all associated app authorizations before you can delete an app bundle.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAppBundleRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAppBundleRequest#builder()}
     * </p>
     *
     * @param deleteAppBundleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.DeleteAppBundleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAppBundle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ConflictException The request has created a conflict. Check the request parameters and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.DeleteAppBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteAppBundle" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAppBundleResponse> deleteAppBundle(
            Consumer<DeleteAppBundleRequest.Builder> deleteAppBundleRequest) {
        return deleteAppBundle(DeleteAppBundleRequest.builder().applyMutation(deleteAppBundleRequest).build());
    }

    /**
     * <p>
     * Deletes an ingestion. You must stop (disable) the ingestion and you must delete all associated ingestion
     * destinations before you can delete an app ingestion.
     * </p>
     *
     * @param deleteIngestionRequest
     * @return A Java Future containing the result of the DeleteIngestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.DeleteIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIngestionResponse> deleteIngestion(DeleteIngestionRequest deleteIngestionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an ingestion. You must stop (disable) the ingestion and you must delete all associated ingestion
     * destinations before you can delete an app ingestion.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIngestionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteIngestionRequest#builder()}
     * </p>
     *
     * @param deleteIngestionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.DeleteIngestionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteIngestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.DeleteIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIngestionResponse> deleteIngestion(
            Consumer<DeleteIngestionRequest.Builder> deleteIngestionRequest) {
        return deleteIngestion(DeleteIngestionRequest.builder().applyMutation(deleteIngestionRequest).build());
    }

    /**
     * <p>
     * Deletes an ingestion destination.
     * </p>
     * <p>
     * This deletes the association between an ingestion and it's destination. It doesn't delete previously ingested
     * data or the storage destination, such as the Amazon S3 bucket where the data is delivered. If the ingestion
     * destination is deleted while the associated ingestion is enabled, the ingestion will fail and is eventually
     * disabled.
     * </p>
     *
     * @param deleteIngestionDestinationRequest
     * @return A Java Future containing the result of the DeleteIngestionDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.DeleteIngestionDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteIngestionDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIngestionDestinationResponse> deleteIngestionDestination(
            DeleteIngestionDestinationRequest deleteIngestionDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an ingestion destination.
     * </p>
     * <p>
     * This deletes the association between an ingestion and it's destination. It doesn't delete previously ingested
     * data or the storage destination, such as the Amazon S3 bucket where the data is delivered. If the ingestion
     * destination is deleted while the associated ingestion is enabled, the ingestion will fail and is eventually
     * disabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIngestionDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteIngestionDestinationRequest#builder()}
     * </p>
     *
     * @param deleteIngestionDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.DeleteIngestionDestinationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteIngestionDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.DeleteIngestionDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteIngestionDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIngestionDestinationResponse> deleteIngestionDestination(
            Consumer<DeleteIngestionDestinationRequest.Builder> deleteIngestionDestinationRequest) {
        return deleteIngestionDestination(DeleteIngestionDestinationRequest.builder()
                .applyMutation(deleteIngestionDestinationRequest).build());
    }

    /**
     * <p>
     * Returns information about an app authorization.
     * </p>
     *
     * @param getAppAuthorizationRequest
     * @return A Java Future containing the result of the GetAppAuthorization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.GetAppAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/GetAppAuthorization" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAppAuthorizationResponse> getAppAuthorization(
            GetAppAuthorizationRequest getAppAuthorizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an app authorization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAppAuthorizationRequest.Builder} avoiding the
     * need to create one manually via {@link GetAppAuthorizationRequest#builder()}
     * </p>
     *
     * @param getAppAuthorizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.GetAppAuthorizationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAppAuthorization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.GetAppAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/GetAppAuthorization" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAppAuthorizationResponse> getAppAuthorization(
            Consumer<GetAppAuthorizationRequest.Builder> getAppAuthorizationRequest) {
        return getAppAuthorization(GetAppAuthorizationRequest.builder().applyMutation(getAppAuthorizationRequest).build());
    }

    /**
     * <p>
     * Returns information about an app bundle.
     * </p>
     *
     * @param getAppBundleRequest
     * @return A Java Future containing the result of the GetAppBundle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.GetAppBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/GetAppBundle" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAppBundleResponse> getAppBundle(GetAppBundleRequest getAppBundleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an app bundle.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAppBundleRequest.Builder} avoiding the need to
     * create one manually via {@link GetAppBundleRequest#builder()}
     * </p>
     *
     * @param getAppBundleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.GetAppBundleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAppBundle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.GetAppBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/GetAppBundle" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAppBundleResponse> getAppBundle(Consumer<GetAppBundleRequest.Builder> getAppBundleRequest) {
        return getAppBundle(GetAppBundleRequest.builder().applyMutation(getAppBundleRequest).build());
    }

    /**
     * <p>
     * Returns information about an ingestion.
     * </p>
     *
     * @param getIngestionRequest
     * @return A Java Future containing the result of the GetIngestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.GetIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/GetIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetIngestionResponse> getIngestion(GetIngestionRequest getIngestionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an ingestion.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIngestionRequest.Builder} avoiding the need to
     * create one manually via {@link GetIngestionRequest#builder()}
     * </p>
     *
     * @param getIngestionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.GetIngestionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetIngestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.GetIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/GetIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetIngestionResponse> getIngestion(Consumer<GetIngestionRequest.Builder> getIngestionRequest) {
        return getIngestion(GetIngestionRequest.builder().applyMutation(getIngestionRequest).build());
    }

    /**
     * <p>
     * Returns information about an ingestion destination.
     * </p>
     *
     * @param getIngestionDestinationRequest
     * @return A Java Future containing the result of the GetIngestionDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.GetIngestionDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/GetIngestionDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIngestionDestinationResponse> getIngestionDestination(
            GetIngestionDestinationRequest getIngestionDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an ingestion destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIngestionDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link GetIngestionDestinationRequest#builder()}
     * </p>
     *
     * @param getIngestionDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.GetIngestionDestinationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetIngestionDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.GetIngestionDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/GetIngestionDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIngestionDestinationResponse> getIngestionDestination(
            Consumer<GetIngestionDestinationRequest.Builder> getIngestionDestinationRequest) {
        return getIngestionDestination(GetIngestionDestinationRequest.builder().applyMutation(getIngestionDestinationRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of all app authorizations configured for an app bundle.
     * </p>
     *
     * @param listAppAuthorizationsRequest
     * @return A Java Future containing the result of the ListAppAuthorizations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.ListAppAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListAppAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAppAuthorizationsResponse> listAppAuthorizations(
            ListAppAuthorizationsRequest listAppAuthorizationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all app authorizations configured for an app bundle.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppAuthorizationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAppAuthorizationsRequest#builder()}
     * </p>
     *
     * @param listAppAuthorizationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAppAuthorizations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.ListAppAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListAppAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAppAuthorizationsResponse> listAppAuthorizations(
            Consumer<ListAppAuthorizationsRequest.Builder> listAppAuthorizationsRequest) {
        return listAppAuthorizations(ListAppAuthorizationsRequest.builder().applyMutation(listAppAuthorizationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAppAuthorizations(software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListAppAuthorizationsPublisher publisher = client.listAppAuthorizationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListAppAuthorizationsPublisher publisher = client.listAppAuthorizationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppAuthorizations(software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAppAuthorizationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.ListAppAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListAppAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppAuthorizationsPublisher listAppAuthorizationsPaginator(
            ListAppAuthorizationsRequest listAppAuthorizationsRequest) {
        return new ListAppAuthorizationsPublisher(this, listAppAuthorizationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAppAuthorizations(software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListAppAuthorizationsPublisher publisher = client.listAppAuthorizationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListAppAuthorizationsPublisher publisher = client.listAppAuthorizationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppAuthorizations(software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppAuthorizationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAppAuthorizationsRequest#builder()}
     * </p>
     *
     * @param listAppAuthorizationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.ListAppAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListAppAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppAuthorizationsPublisher listAppAuthorizationsPaginator(
            Consumer<ListAppAuthorizationsRequest.Builder> listAppAuthorizationsRequest) {
        return listAppAuthorizationsPaginator(ListAppAuthorizationsRequest.builder().applyMutation(listAppAuthorizationsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of app bundles.
     * </p>
     *
     * @param listAppBundlesRequest
     * @return A Java Future containing the result of the ListAppBundles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.ListAppBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListAppBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAppBundlesResponse> listAppBundles(ListAppBundlesRequest listAppBundlesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of app bundles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppBundlesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAppBundlesRequest#builder()}
     * </p>
     *
     * @param listAppBundlesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.ListAppBundlesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAppBundles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.ListAppBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListAppBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAppBundlesResponse> listAppBundles(Consumer<ListAppBundlesRequest.Builder> listAppBundlesRequest) {
        return listAppBundles(ListAppBundlesRequest.builder().applyMutation(listAppBundlesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAppBundles(software.amazon.awssdk.services.appfabric.model.ListAppBundlesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListAppBundlesPublisher publisher = client.listAppBundlesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListAppBundlesPublisher publisher = client.listAppBundlesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appfabric.model.ListAppBundlesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appfabric.model.ListAppBundlesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppBundles(software.amazon.awssdk.services.appfabric.model.ListAppBundlesRequest)} operation.</b>
     * </p>
     *
     * @param listAppBundlesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.ListAppBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListAppBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppBundlesPublisher listAppBundlesPaginator(ListAppBundlesRequest listAppBundlesRequest) {
        return new ListAppBundlesPublisher(this, listAppBundlesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAppBundles(software.amazon.awssdk.services.appfabric.model.ListAppBundlesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListAppBundlesPublisher publisher = client.listAppBundlesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListAppBundlesPublisher publisher = client.listAppBundlesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appfabric.model.ListAppBundlesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appfabric.model.ListAppBundlesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppBundles(software.amazon.awssdk.services.appfabric.model.ListAppBundlesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppBundlesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAppBundlesRequest#builder()}
     * </p>
     *
     * @param listAppBundlesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.ListAppBundlesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.ListAppBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListAppBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppBundlesPublisher listAppBundlesPaginator(Consumer<ListAppBundlesRequest.Builder> listAppBundlesRequest) {
        return listAppBundlesPaginator(ListAppBundlesRequest.builder().applyMutation(listAppBundlesRequest).build());
    }

    /**
     * <p>
     * Returns a list of all ingestion destinations configured for an ingestion.
     * </p>
     *
     * @param listIngestionDestinationsRequest
     * @return A Java Future containing the result of the ListIngestionDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.ListIngestionDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListIngestionDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIngestionDestinationsResponse> listIngestionDestinations(
            ListIngestionDestinationsRequest listIngestionDestinationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all ingestion destinations configured for an ingestion.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIngestionDestinationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListIngestionDestinationsRequest#builder()}
     * </p>
     *
     * @param listIngestionDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListIngestionDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.ListIngestionDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListIngestionDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIngestionDestinationsResponse> listIngestionDestinations(
            Consumer<ListIngestionDestinationsRequest.Builder> listIngestionDestinationsRequest) {
        return listIngestionDestinations(ListIngestionDestinationsRequest.builder()
                .applyMutation(listIngestionDestinationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIngestionDestinations(software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListIngestionDestinationsPublisher publisher = client.listIngestionDestinationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListIngestionDestinationsPublisher publisher = client.listIngestionDestinationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIngestionDestinations(software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIngestionDestinationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.ListIngestionDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListIngestionDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIngestionDestinationsPublisher listIngestionDestinationsPaginator(
            ListIngestionDestinationsRequest listIngestionDestinationsRequest) {
        return new ListIngestionDestinationsPublisher(this, listIngestionDestinationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIngestionDestinations(software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListIngestionDestinationsPublisher publisher = client.listIngestionDestinationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListIngestionDestinationsPublisher publisher = client.listIngestionDestinationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIngestionDestinations(software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIngestionDestinationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListIngestionDestinationsRequest#builder()}
     * </p>
     *
     * @param listIngestionDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.ListIngestionDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListIngestionDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIngestionDestinationsPublisher listIngestionDestinationsPaginator(
            Consumer<ListIngestionDestinationsRequest.Builder> listIngestionDestinationsRequest) {
        return listIngestionDestinationsPaginator(ListIngestionDestinationsRequest.builder()
                .applyMutation(listIngestionDestinationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all ingestions configured for an app bundle.
     * </p>
     *
     * @param listIngestionsRequest
     * @return A Java Future containing the result of the ListIngestions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.ListIngestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListIngestions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIngestionsResponse> listIngestions(ListIngestionsRequest listIngestionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all ingestions configured for an app bundle.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIngestionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListIngestionsRequest#builder()}
     * </p>
     *
     * @param listIngestionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.ListIngestionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListIngestions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.ListIngestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListIngestions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIngestionsResponse> listIngestions(Consumer<ListIngestionsRequest.Builder> listIngestionsRequest) {
        return listIngestions(ListIngestionsRequest.builder().applyMutation(listIngestionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIngestions(software.amazon.awssdk.services.appfabric.model.ListIngestionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListIngestionsPublisher publisher = client.listIngestionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListIngestionsPublisher publisher = client.listIngestionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appfabric.model.ListIngestionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appfabric.model.ListIngestionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIngestions(software.amazon.awssdk.services.appfabric.model.ListIngestionsRequest)} operation.</b>
     * </p>
     *
     * @param listIngestionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.ListIngestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListIngestions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIngestionsPublisher listIngestionsPaginator(ListIngestionsRequest listIngestionsRequest) {
        return new ListIngestionsPublisher(this, listIngestionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIngestions(software.amazon.awssdk.services.appfabric.model.ListIngestionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListIngestionsPublisher publisher = client.listIngestionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListIngestionsPublisher publisher = client.listIngestionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appfabric.model.ListIngestionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appfabric.model.ListIngestionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIngestions(software.amazon.awssdk.services.appfabric.model.ListIngestionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIngestionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListIngestionsRequest#builder()}
     * </p>
     *
     * @param listIngestionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.ListIngestionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.ListIngestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListIngestions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIngestionsPublisher listIngestionsPaginator(Consumer<ListIngestionsRequest.Builder> listIngestionsRequest) {
        return listIngestionsPaginator(ListIngestionsRequest.builder().applyMutation(listIngestionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Starts (enables) an ingestion, which collects data from an application.
     * </p>
     *
     * @param startIngestionRequest
     * @return A Java Future containing the result of the StartIngestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ConflictException The request has created a conflict. Check the request parameters and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.StartIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/StartIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartIngestionResponse> startIngestion(StartIngestionRequest startIngestionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts (enables) an ingestion, which collects data from an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartIngestionRequest.Builder} avoiding the need to
     * create one manually via {@link StartIngestionRequest#builder()}
     * </p>
     *
     * @param startIngestionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.StartIngestionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartIngestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ConflictException The request has created a conflict. Check the request parameters and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.StartIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/StartIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartIngestionResponse> startIngestion(Consumer<StartIngestionRequest.Builder> startIngestionRequest) {
        return startIngestion(StartIngestionRequest.builder().applyMutation(startIngestionRequest).build());
    }

    /**
     * <p>
     * Starts the tasks to search user access status for a specific email address.
     * </p>
     * <p>
     * The tasks are stopped when the user access status data is found. The tasks are terminated when the API calls to
     * the application time out.
     * </p>
     *
     * @param startUserAccessTasksRequest
     * @return A Java Future containing the result of the StartUserAccessTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.StartUserAccessTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/StartUserAccessTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartUserAccessTasksResponse> startUserAccessTasks(
            StartUserAccessTasksRequest startUserAccessTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the tasks to search user access status for a specific email address.
     * </p>
     * <p>
     * The tasks are stopped when the user access status data is found. The tasks are terminated when the API calls to
     * the application time out.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartUserAccessTasksRequest.Builder} avoiding the
     * need to create one manually via {@link StartUserAccessTasksRequest#builder()}
     * </p>
     *
     * @param startUserAccessTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.StartUserAccessTasksRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartUserAccessTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.StartUserAccessTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/StartUserAccessTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartUserAccessTasksResponse> startUserAccessTasks(
            Consumer<StartUserAccessTasksRequest.Builder> startUserAccessTasksRequest) {
        return startUserAccessTasks(StartUserAccessTasksRequest.builder().applyMutation(startUserAccessTasksRequest).build());
    }

    /**
     * <p>
     * Stops (disables) an ingestion.
     * </p>
     *
     * @param stopIngestionRequest
     * @return A Java Future containing the result of the StopIngestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ConflictException The request has created a conflict. Check the request parameters and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.StopIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/StopIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopIngestionResponse> stopIngestion(StopIngestionRequest stopIngestionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops (disables) an ingestion.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopIngestionRequest.Builder} avoiding the need to
     * create one manually via {@link StopIngestionRequest#builder()}
     * </p>
     *
     * @param stopIngestionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.StopIngestionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopIngestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ConflictException The request has created a conflict. Check the request parameters and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.StopIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/StopIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopIngestionResponse> stopIngestion(Consumer<StopIngestionRequest.Builder> stopIngestionRequest) {
        return stopIngestion(StopIngestionRequest.builder().applyMutation(stopIngestionRequest).build());
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag or tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag or tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an app authorization within an app bundle, which allows AppFabric to connect to an application.
     * </p>
     * <p>
     * If the app authorization was in a <code>connected</code> state, updating the app authorization will set it back
     * to a <code>PendingConnect</code> state.
     * </p>
     *
     * @param updateAppAuthorizationRequest
     * @return A Java Future containing the result of the UpdateAppAuthorization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.UpdateAppAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/UpdateAppAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAppAuthorizationResponse> updateAppAuthorization(
            UpdateAppAuthorizationRequest updateAppAuthorizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an app authorization within an app bundle, which allows AppFabric to connect to an application.
     * </p>
     * <p>
     * If the app authorization was in a <code>connected</code> state, updating the app authorization will set it back
     * to a <code>PendingConnect</code> state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAppAuthorizationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAppAuthorizationRequest#builder()}
     * </p>
     *
     * @param updateAppAuthorizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.UpdateAppAuthorizationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateAppAuthorization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.UpdateAppAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/UpdateAppAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAppAuthorizationResponse> updateAppAuthorization(
            Consumer<UpdateAppAuthorizationRequest.Builder> updateAppAuthorizationRequest) {
        return updateAppAuthorization(UpdateAppAuthorizationRequest.builder().applyMutation(updateAppAuthorizationRequest)
                .build());
    }

    /**
     * <p>
     * Updates an ingestion destination, which specifies how an application's ingested data is processed by Amazon Web
     * Services AppFabric and where it's delivered.
     * </p>
     *
     * @param updateIngestionDestinationRequest
     * @return A Java Future containing the result of the UpdateIngestionDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ConflictException The request has created a conflict. Check the request parameters and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.UpdateIngestionDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/UpdateIngestionDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateIngestionDestinationResponse> updateIngestionDestination(
            UpdateIngestionDestinationRequest updateIngestionDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an ingestion destination, which specifies how an application's ingested data is processed by Amazon Web
     * Services AppFabric and where it's delivered.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIngestionDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateIngestionDestinationRequest#builder()}
     * </p>
     *
     * @param updateIngestionDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.UpdateIngestionDestinationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateIngestionDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request rate exceeds the limit.</li>
     *         <li>ConflictException The request has created a conflict. Check the request parameters and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppFabricAsyncClient.UpdateIngestionDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/UpdateIngestionDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateIngestionDestinationResponse> updateIngestionDestination(
            Consumer<UpdateIngestionDestinationRequest.Builder> updateIngestionDestinationRequest) {
        return updateIngestionDestination(UpdateIngestionDestinationRequest.builder()
                .applyMutation(updateIngestionDestinationRequest).build());
    }

    @Override
    default AppFabricServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link AppFabricAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AppFabricAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AppFabricAsyncClient}.
     */
    static AppFabricAsyncClientBuilder builder() {
        return new DefaultAppFabricAsyncClientBuilder();
    }
}
