/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an app bundle.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppBundle implements SdkPojo, Serializable, ToCopyableBuilder<AppBundle.Builder, AppBundle> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(AppBundle::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CUSTOMER_MANAGED_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerManagedKeyArn").getter(getter(AppBundle::customerManagedKeyArn))
            .setter(setter(Builder::customerManagedKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedKeyArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CUSTOMER_MANAGED_KEY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String customerManagedKeyArn;

    private AppBundle(BuilderImpl builder) {
        this.arn = builder.arn;
        this.customerManagedKeyArn = builder.customerManagedKeyArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the app bundle.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the app bundle.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used to encrypt the application data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used to encrypt the application
     *         data.
     */
    public final String customerManagedKeyArn() {
        return customerManagedKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(customerManagedKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppBundle)) {
            return false;
        }
        AppBundle other = (AppBundle) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(customerManagedKeyArn(), other.customerManagedKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppBundle").add("Arn", arn()).add("CustomerManagedKeyArn", customerManagedKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "customerManagedKeyArn":
            return Optional.ofNullable(clazz.cast(customerManagedKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("customerManagedKeyArn", CUSTOMER_MANAGED_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppBundle, T> g) {
        return obj -> g.apply((AppBundle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppBundle> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the app bundle.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the app bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used to encrypt the application data.
         * </p>
         * 
         * @param customerManagedKeyArn
         *        The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used to encrypt the application
         *        data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerManagedKeyArn(String customerManagedKeyArn);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String customerManagedKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AppBundle model) {
            arn(model.arn);
            customerManagedKeyArn(model.customerManagedKeyArn);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCustomerManagedKeyArn() {
            return customerManagedKeyArn;
        }

        public final void setCustomerManagedKeyArn(String customerManagedKeyArn) {
            this.customerManagedKeyArn = customerManagedKeyArn;
        }

        @Override
        public final Builder customerManagedKeyArn(String customerManagedKeyArn) {
            this.customerManagedKeyArn = customerManagedKeyArn;
            return this;
        }

        @Override
        public AppBundle build() {
            return new AppBundle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
