/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an audit log processing configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuditLogProcessingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AuditLogProcessingConfiguration.Builder, AuditLogProcessingConfiguration> {
    private static final SdkField<String> SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("schema")
            .getter(getter(AuditLogProcessingConfiguration::schemaAsString)).setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(AuditLogProcessingConfiguration::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_FIELD, FORMAT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String schema;

    private final String format;

    private AuditLogProcessingConfiguration(BuilderImpl builder) {
        this.schema = builder.schema;
        this.format = builder.format;
    }

    /**
     * <p>
     * The event schema in which the audit logs need to be formatted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #schema} will
     * return {@link Schema#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #schemaAsString}.
     * </p>
     * 
     * @return The event schema in which the audit logs need to be formatted.
     * @see Schema
     */
    public final Schema schema() {
        return Schema.fromValue(schema);
    }

    /**
     * <p>
     * The event schema in which the audit logs need to be formatted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #schema} will
     * return {@link Schema#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #schemaAsString}.
     * </p>
     * 
     * @return The event schema in which the audit logs need to be formatted.
     * @see Schema
     */
    public final String schemaAsString() {
        return schema;
    }

    /**
     * <p>
     * The format in which the audit logs need to be formatted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format in which the audit logs need to be formatted.
     * @see Format
     */
    public final Format format() {
        return Format.fromValue(format);
    }

    /**
     * <p>
     * The format in which the audit logs need to be formatted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format in which the audit logs need to be formatted.
     * @see Format
     */
    public final String formatAsString() {
        return format;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schemaAsString());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditLogProcessingConfiguration)) {
            return false;
        }
        AuditLogProcessingConfiguration other = (AuditLogProcessingConfiguration) obj;
        return Objects.equals(schemaAsString(), other.schemaAsString())
                && Objects.equals(formatAsString(), other.formatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuditLogProcessingConfiguration").add("Schema", schemaAsString())
                .add("Format", formatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "schema":
            return Optional.ofNullable(clazz.cast(schemaAsString()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("schema", SCHEMA_FIELD);
        map.put("format", FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuditLogProcessingConfiguration, T> g) {
        return obj -> g.apply((AuditLogProcessingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuditLogProcessingConfiguration> {
        /**
         * <p>
         * The event schema in which the audit logs need to be formatted.
         * </p>
         * 
         * @param schema
         *        The event schema in which the audit logs need to be formatted.
         * @see Schema
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Schema
         */
        Builder schema(String schema);

        /**
         * <p>
         * The event schema in which the audit logs need to be formatted.
         * </p>
         * 
         * @param schema
         *        The event schema in which the audit logs need to be formatted.
         * @see Schema
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Schema
         */
        Builder schema(Schema schema);

        /**
         * <p>
         * The format in which the audit logs need to be formatted.
         * </p>
         * 
         * @param format
         *        The format in which the audit logs need to be formatted.
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(String format);

        /**
         * <p>
         * The format in which the audit logs need to be formatted.
         * </p>
         * 
         * @param format
         *        The format in which the audit logs need to be formatted.
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(Format format);
    }

    static final class BuilderImpl implements Builder {
        private String schema;

        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditLogProcessingConfiguration model) {
            schema(model.schema);
            format(model.format);
        }

        public final String getSchema() {
            return schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public final Builder schema(Schema schema) {
            this.schema(schema == null ? null : schema.toString());
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        @Override
        public AuditLogProcessingConfiguration build() {
            return new AuditLogProcessingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
