/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetUserAccessTasksResponse extends AppFabricResponse implements
        ToCopyableBuilder<BatchGetUserAccessTasksResponse.Builder, BatchGetUserAccessTasksResponse> {
    private static final SdkField<List<UserAccessResultItem>> USER_ACCESS_RESULTS_LIST_FIELD = SdkField
            .<List<UserAccessResultItem>> builder(MarshallingType.LIST)
            .memberName("userAccessResultsList")
            .getter(getter(BatchGetUserAccessTasksResponse::userAccessResultsList))
            .setter(setter(Builder::userAccessResultsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAccessResultsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserAccessResultItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserAccessResultItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(USER_ACCESS_RESULTS_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<UserAccessResultItem> userAccessResultsList;

    private BatchGetUserAccessTasksResponse(BuilderImpl builder) {
        super(builder);
        this.userAccessResultsList = builder.userAccessResultsList;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserAccessResultsList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUserAccessResultsList() {
        return userAccessResultsList != null && !(userAccessResultsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a list of user access results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserAccessResultsList} method.
     * </p>
     * 
     * @return Contains a list of user access results.
     */
    public final List<UserAccessResultItem> userAccessResultsList() {
        return userAccessResultsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUserAccessResultsList() ? userAccessResultsList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetUserAccessTasksResponse)) {
            return false;
        }
        BatchGetUserAccessTasksResponse other = (BatchGetUserAccessTasksResponse) obj;
        return hasUserAccessResultsList() == other.hasUserAccessResultsList()
                && Objects.equals(userAccessResultsList(), other.userAccessResultsList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetUserAccessTasksResponse")
                .add("UserAccessResultsList", hasUserAccessResultsList() ? userAccessResultsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userAccessResultsList":
            return Optional.ofNullable(clazz.cast(userAccessResultsList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("userAccessResultsList", USER_ACCESS_RESULTS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetUserAccessTasksResponse, T> g) {
        return obj -> g.apply((BatchGetUserAccessTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppFabricResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetUserAccessTasksResponse> {
        /**
         * <p>
         * Contains a list of user access results.
         * </p>
         * 
         * @param userAccessResultsList
         *        Contains a list of user access results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAccessResultsList(Collection<UserAccessResultItem> userAccessResultsList);

        /**
         * <p>
         * Contains a list of user access results.
         * </p>
         * 
         * @param userAccessResultsList
         *        Contains a list of user access results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAccessResultsList(UserAccessResultItem... userAccessResultsList);

        /**
         * <p>
         * Contains a list of user access results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appfabric.model.UserAccessResultItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.appfabric.model.UserAccessResultItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appfabric.model.UserAccessResultItem.Builder#build()} is called
         * immediately and its result is passed to {@link #userAccessResultsList(List<UserAccessResultItem>)}.
         * 
         * @param userAccessResultsList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appfabric.model.UserAccessResultItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userAccessResultsList(java.util.Collection<UserAccessResultItem>)
         */
        Builder userAccessResultsList(Consumer<UserAccessResultItem.Builder>... userAccessResultsList);
    }

    static final class BuilderImpl extends AppFabricResponse.BuilderImpl implements Builder {
        private List<UserAccessResultItem> userAccessResultsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetUserAccessTasksResponse model) {
            super(model);
            userAccessResultsList(model.userAccessResultsList);
        }

        public final List<UserAccessResultItem.Builder> getUserAccessResultsList() {
            List<UserAccessResultItem.Builder> result = UserAccessResultsListCopier.copyToBuilder(this.userAccessResultsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserAccessResultsList(Collection<UserAccessResultItem.BuilderImpl> userAccessResultsList) {
            this.userAccessResultsList = UserAccessResultsListCopier.copyFromBuilder(userAccessResultsList);
        }

        @Override
        public final Builder userAccessResultsList(Collection<UserAccessResultItem> userAccessResultsList) {
            this.userAccessResultsList = UserAccessResultsListCopier.copy(userAccessResultsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAccessResultsList(UserAccessResultItem... userAccessResultsList) {
            userAccessResultsList(Arrays.asList(userAccessResultsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAccessResultsList(Consumer<UserAccessResultItem.Builder>... userAccessResultsList) {
            userAccessResultsList(Stream.of(userAccessResultsList)
                    .map(c -> UserAccessResultItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetUserAccessTasksResponse build() {
            return new BatchGetUserAccessTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
