/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectAppAuthorizationRequest extends AppFabricRequest implements
        ToCopyableBuilder<ConnectAppAuthorizationRequest.Builder, ConnectAppAuthorizationRequest> {
    private static final SdkField<String> APP_BUNDLE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appBundleIdentifier").getter(getter(ConnectAppAuthorizationRequest::appBundleIdentifier))
            .setter(setter(Builder::appBundleIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appBundleIdentifier").build()).build();

    private static final SdkField<String> APP_AUTHORIZATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appAuthorizationIdentifier").getter(getter(ConnectAppAuthorizationRequest::appAuthorizationIdentifier))
            .setter(setter(Builder::appAuthorizationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appAuthorizationIdentifier").build())
            .build();

    private static final SdkField<AuthRequest> AUTH_REQUEST_FIELD = SdkField.<AuthRequest> builder(MarshallingType.SDK_POJO)
            .memberName("authRequest").getter(getter(ConnectAppAuthorizationRequest::authRequest))
            .setter(setter(Builder::authRequest)).constructor(AuthRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authRequest").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BUNDLE_IDENTIFIER_FIELD,
            APP_AUTHORIZATION_IDENTIFIER_FIELD, AUTH_REQUEST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appBundleIdentifier;

    private final String appAuthorizationIdentifier;

    private final AuthRequest authRequest;

    private ConnectAppAuthorizationRequest(BuilderImpl builder) {
        super(builder);
        this.appBundleIdentifier = builder.appBundleIdentifier;
        this.appAuthorizationIdentifier = builder.appAuthorizationIdentifier;
        this.authRequest = builder.authRequest;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle that contains the app
     * authorization to use for the request.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle that contains the
     *         app authorization to use for the request.
     */
    public final String appBundleIdentifier() {
        return appBundleIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use for the
     * request.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use for
     *         the request.
     */
    public final String appAuthorizationIdentifier() {
        return appAuthorizationIdentifier;
    }

    /**
     * <p>
     * Contains OAuth2 authorization information.
     * </p>
     * <p>
     * This is required if the app authorization for the request is configured with an OAuth2 (<code>oauth2</code>)
     * authorization type.
     * </p>
     * 
     * @return Contains OAuth2 authorization information.</p>
     *         <p>
     *         This is required if the app authorization for the request is configured with an OAuth2 (
     *         <code>oauth2</code>) authorization type.
     */
    public final AuthRequest authRequest() {
        return authRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appBundleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(appAuthorizationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(authRequest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectAppAuthorizationRequest)) {
            return false;
        }
        ConnectAppAuthorizationRequest other = (ConnectAppAuthorizationRequest) obj;
        return Objects.equals(appBundleIdentifier(), other.appBundleIdentifier())
                && Objects.equals(appAuthorizationIdentifier(), other.appAuthorizationIdentifier())
                && Objects.equals(authRequest(), other.authRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectAppAuthorizationRequest").add("AppBundleIdentifier", appBundleIdentifier())
                .add("AppAuthorizationIdentifier", appAuthorizationIdentifier()).add("AuthRequest", authRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appBundleIdentifier":
            return Optional.ofNullable(clazz.cast(appBundleIdentifier()));
        case "appAuthorizationIdentifier":
            return Optional.ofNullable(clazz.cast(appAuthorizationIdentifier()));
        case "authRequest":
            return Optional.ofNullable(clazz.cast(authRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appBundleIdentifier", APP_BUNDLE_IDENTIFIER_FIELD);
        map.put("appAuthorizationIdentifier", APP_AUTHORIZATION_IDENTIFIER_FIELD);
        map.put("authRequest", AUTH_REQUEST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectAppAuthorizationRequest, T> g) {
        return obj -> g.apply((ConnectAppAuthorizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppFabricRequest.Builder, SdkPojo, CopyableBuilder<Builder, ConnectAppAuthorizationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle that contains the app
         * authorization to use for the request.
         * </p>
         * 
         * @param appBundleIdentifier
         *        The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle that contains
         *        the app authorization to use for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appBundleIdentifier(String appBundleIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use for the
         * request.
         * </p>
         * 
         * @param appAuthorizationIdentifier
         *        The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use
         *        for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appAuthorizationIdentifier(String appAuthorizationIdentifier);

        /**
         * <p>
         * Contains OAuth2 authorization information.
         * </p>
         * <p>
         * This is required if the app authorization for the request is configured with an OAuth2 (<code>oauth2</code>)
         * authorization type.
         * </p>
         * 
         * @param authRequest
         *        Contains OAuth2 authorization information.</p>
         *        <p>
         *        This is required if the app authorization for the request is configured with an OAuth2 (
         *        <code>oauth2</code>) authorization type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authRequest(AuthRequest authRequest);

        /**
         * <p>
         * Contains OAuth2 authorization information.
         * </p>
         * <p>
         * This is required if the app authorization for the request is configured with an OAuth2 (<code>oauth2</code>)
         * authorization type.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthRequest.Builder} avoiding the need to
         * create one manually via {@link AuthRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthRequest.Builder#build()} is called immediately and its result
         * is passed to {@link #authRequest(AuthRequest)}.
         * 
         * @param authRequest
         *        a consumer that will call methods on {@link AuthRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authRequest(AuthRequest)
         */
        default Builder authRequest(Consumer<AuthRequest.Builder> authRequest) {
            return authRequest(AuthRequest.builder().applyMutation(authRequest).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppFabricRequest.BuilderImpl implements Builder {
        private String appBundleIdentifier;

        private String appAuthorizationIdentifier;

        private AuthRequest authRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectAppAuthorizationRequest model) {
            super(model);
            appBundleIdentifier(model.appBundleIdentifier);
            appAuthorizationIdentifier(model.appAuthorizationIdentifier);
            authRequest(model.authRequest);
        }

        public final String getAppBundleIdentifier() {
            return appBundleIdentifier;
        }

        public final void setAppBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
        }

        @Override
        public final Builder appBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
            return this;
        }

        public final String getAppAuthorizationIdentifier() {
            return appAuthorizationIdentifier;
        }

        public final void setAppAuthorizationIdentifier(String appAuthorizationIdentifier) {
            this.appAuthorizationIdentifier = appAuthorizationIdentifier;
        }

        @Override
        public final Builder appAuthorizationIdentifier(String appAuthorizationIdentifier) {
            this.appAuthorizationIdentifier = appAuthorizationIdentifier;
            return this;
        }

        public final AuthRequest.Builder getAuthRequest() {
            return authRequest != null ? authRequest.toBuilder() : null;
        }

        public final void setAuthRequest(AuthRequest.BuilderImpl authRequest) {
            this.authRequest = authRequest != null ? authRequest.build() : null;
        }

        @Override
        public final Builder authRequest(AuthRequest authRequest) {
            this.authRequest = authRequest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConnectAppAuthorizationRequest build() {
            return new ConnectAppAuthorizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
