/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIngestionResponse extends AppFabricResponse implements
        ToCopyableBuilder<CreateIngestionResponse.Builder, CreateIngestionResponse> {
    private static final SdkField<Ingestion> INGESTION_FIELD = SdkField.<Ingestion> builder(MarshallingType.SDK_POJO)
            .memberName("ingestion").getter(getter(CreateIngestionResponse::ingestion)).setter(setter(Builder::ingestion))
            .constructor(Ingestion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INGESTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Ingestion ingestion;

    private CreateIngestionResponse(BuilderImpl builder) {
        super(builder);
        this.ingestion = builder.ingestion;
    }

    /**
     * <p>
     * Contains information about an ingestion.
     * </p>
     * 
     * @return Contains information about an ingestion.
     */
    public final Ingestion ingestion() {
        return ingestion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ingestion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIngestionResponse)) {
            return false;
        }
        CreateIngestionResponse other = (CreateIngestionResponse) obj;
        return Objects.equals(ingestion(), other.ingestion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIngestionResponse").add("Ingestion", ingestion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ingestion":
            return Optional.ofNullable(clazz.cast(ingestion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ingestion", INGESTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIngestionResponse, T> g) {
        return obj -> g.apply((CreateIngestionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppFabricResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateIngestionResponse> {
        /**
         * <p>
         * Contains information about an ingestion.
         * </p>
         * 
         * @param ingestion
         *        Contains information about an ingestion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestion(Ingestion ingestion);

        /**
         * <p>
         * Contains information about an ingestion.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ingestion.Builder} avoiding the need to
         * create one manually via {@link Ingestion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ingestion.Builder#build()} is called immediately and its result
         * is passed to {@link #ingestion(Ingestion)}.
         * 
         * @param ingestion
         *        a consumer that will call methods on {@link Ingestion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingestion(Ingestion)
         */
        default Builder ingestion(Consumer<Ingestion.Builder> ingestion) {
            return ingestion(Ingestion.builder().applyMutation(ingestion).build());
        }
    }

    static final class BuilderImpl extends AppFabricResponse.BuilderImpl implements Builder {
        private Ingestion ingestion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIngestionResponse model) {
            super(model);
            ingestion(model.ingestion);
        }

        public final Ingestion.Builder getIngestion() {
            return ingestion != null ? ingestion.toBuilder() : null;
        }

        public final void setIngestion(Ingestion.BuilderImpl ingestion) {
            this.ingestion = ingestion != null ? ingestion.build() : null;
        }

        @Override
        public final Builder ingestion(Ingestion ingestion) {
            this.ingestion = ingestion;
            return this;
        }

        @Override
        public CreateIngestionResponse build() {
            return new CreateIngestionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
