/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an audit log destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Destination implements SdkPojo, Serializable, ToCopyableBuilder<Destination.Builder, Destination> {
    private static final SdkField<S3Bucket> S3_BUCKET_FIELD = SdkField.<S3Bucket> builder(MarshallingType.SDK_POJO)
            .memberName("s3Bucket").getter(getter(Destination::s3Bucket)).setter(setter(Builder::s3Bucket))
            .constructor(S3Bucket::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()).build();

    private static final SdkField<FirehoseStream> FIREHOSE_STREAM_FIELD = SdkField
            .<FirehoseStream> builder(MarshallingType.SDK_POJO).memberName("firehoseStream")
            .getter(getter(Destination::firehoseStream)).setter(setter(Builder::firehoseStream))
            .constructor(FirehoseStream::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firehoseStream").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_FIELD,
            FIREHOSE_STREAM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3Bucket s3Bucket;

    private final FirehoseStream firehoseStream;

    private final Type type;

    private Destination(BuilderImpl builder) {
        this.s3Bucket = builder.s3Bucket;
        this.firehoseStream = builder.firehoseStream;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains information about an Amazon S3 bucket.
     * </p>
     * 
     * @return Contains information about an Amazon S3 bucket.
     */
    public final S3Bucket s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * Contains information about an Amazon Kinesis Data Firehose delivery stream.
     * </p>
     * 
     * @return Contains information about an Amazon Kinesis Data Firehose delivery stream.
     */
    public final FirehoseStream firehoseStream() {
        return firehoseStream;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(firehoseStream());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination) obj;
        return Objects.equals(s3Bucket(), other.s3Bucket()) && Objects.equals(firehoseStream(), other.firehoseStream());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Destination").add("S3Bucket", s3Bucket()).add("FirehoseStream", firehoseStream()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "firehoseStream":
            return Optional.ofNullable(clazz.cast(firehoseStream()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #s3Bucket()} initialized to the given value.
     *
     * <p>
     * Contains information about an Amazon S3 bucket.
     * </p>
     * 
     * @param s3Bucket
     *        Contains information about an Amazon S3 bucket.
     */
    public static Destination fromS3Bucket(S3Bucket s3Bucket) {
        return builder().s3Bucket(s3Bucket).build();
    }

    /**
     * Create an instance of this class with {@link #s3Bucket()} initialized to the given value.
     *
     * <p>
     * Contains information about an Amazon S3 bucket.
     * </p>
     * 
     * @param s3Bucket
     *        Contains information about an Amazon S3 bucket.
     */
    public static Destination fromS3Bucket(Consumer<S3Bucket.Builder> s3Bucket) {
        S3Bucket.Builder builder = S3Bucket.builder();
        s3Bucket.accept(builder);
        return fromS3Bucket(builder.build());
    }

    /**
     * Create an instance of this class with {@link #firehoseStream()} initialized to the given value.
     *
     * <p>
     * Contains information about an Amazon Kinesis Data Firehose delivery stream.
     * </p>
     * 
     * @param firehoseStream
     *        Contains information about an Amazon Kinesis Data Firehose delivery stream.
     */
    public static Destination fromFirehoseStream(FirehoseStream firehoseStream) {
        return builder().firehoseStream(firehoseStream).build();
    }

    /**
     * Create an instance of this class with {@link #firehoseStream()} initialized to the given value.
     *
     * <p>
     * Contains information about an Amazon Kinesis Data Firehose delivery stream.
     * </p>
     * 
     * @param firehoseStream
     *        Contains information about an Amazon Kinesis Data Firehose delivery stream.
     */
    public static Destination fromFirehoseStream(Consumer<FirehoseStream.Builder> firehoseStream) {
        FirehoseStream.Builder builder = FirehoseStream.builder();
        firehoseStream.accept(builder);
        return fromFirehoseStream(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3Bucket", S3_BUCKET_FIELD);
        map.put("firehoseStream", FIREHOSE_STREAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Destination, T> g) {
        return obj -> g.apply((Destination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Destination> {
        /**
         * <p>
         * Contains information about an Amazon S3 bucket.
         * </p>
         * 
         * @param s3Bucket
         *        Contains information about an Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(S3Bucket s3Bucket);

        /**
         * <p>
         * Contains information about an Amazon S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Bucket.Builder} avoiding the need to
         * create one manually via {@link S3Bucket#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Bucket.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Bucket(S3Bucket)}.
         * 
         * @param s3Bucket
         *        a consumer that will call methods on {@link S3Bucket.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Bucket(S3Bucket)
         */
        default Builder s3Bucket(Consumer<S3Bucket.Builder> s3Bucket) {
            return s3Bucket(S3Bucket.builder().applyMutation(s3Bucket).build());
        }

        /**
         * <p>
         * Contains information about an Amazon Kinesis Data Firehose delivery stream.
         * </p>
         * 
         * @param firehoseStream
         *        Contains information about an Amazon Kinesis Data Firehose delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firehoseStream(FirehoseStream firehoseStream);

        /**
         * <p>
         * Contains information about an Amazon Kinesis Data Firehose delivery stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link FirehoseStream.Builder} avoiding the need
         * to create one manually via {@link FirehoseStream#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FirehoseStream.Builder#build()} is called immediately and its
         * result is passed to {@link #firehoseStream(FirehoseStream)}.
         * 
         * @param firehoseStream
         *        a consumer that will call methods on {@link FirehoseStream.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firehoseStream(FirehoseStream)
         */
        default Builder firehoseStream(Consumer<FirehoseStream.Builder> firehoseStream) {
            return firehoseStream(FirehoseStream.builder().applyMutation(firehoseStream).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3Bucket s3Bucket;

        private FirehoseStream firehoseStream;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Destination model) {
            s3Bucket(model.s3Bucket);
            firehoseStream(model.firehoseStream);
        }

        public final S3Bucket.Builder getS3Bucket() {
            return s3Bucket != null ? s3Bucket.toBuilder() : null;
        }

        public final void setS3Bucket(S3Bucket.BuilderImpl s3Bucket) {
            Object oldValue = this.s3Bucket;
            this.s3Bucket = s3Bucket != null ? s3Bucket.build() : null;
            handleUnionValueChange(Type.S3_BUCKET, oldValue, this.s3Bucket);
        }

        @Override
        public final Builder s3Bucket(S3Bucket s3Bucket) {
            Object oldValue = this.s3Bucket;
            this.s3Bucket = s3Bucket;
            handleUnionValueChange(Type.S3_BUCKET, oldValue, this.s3Bucket);
            return this;
        }

        public final FirehoseStream.Builder getFirehoseStream() {
            return firehoseStream != null ? firehoseStream.toBuilder() : null;
        }

        public final void setFirehoseStream(FirehoseStream.BuilderImpl firehoseStream) {
            Object oldValue = this.firehoseStream;
            this.firehoseStream = firehoseStream != null ? firehoseStream.build() : null;
            handleUnionValueChange(Type.FIREHOSE_STREAM, oldValue, this.firehoseStream);
        }

        @Override
        public final Builder firehoseStream(FirehoseStream firehoseStream) {
            Object oldValue = this.firehoseStream;
            this.firehoseStream = firehoseStream;
            handleUnionValueChange(Type.FIREHOSE_STREAM, oldValue, this.firehoseStream);
            return this;
        }

        @Override
        public Destination build() {
            return new Destination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Destination#type()
     */
    public enum Type {
        S3_BUCKET,

        FIREHOSE_STREAM,

        UNKNOWN_TO_SDK_VERSION
    }
}
