/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAppBundleResponse extends AppFabricResponse implements
        ToCopyableBuilder<GetAppBundleResponse.Builder, GetAppBundleResponse> {
    private static final SdkField<AppBundle> APP_BUNDLE_FIELD = SdkField.<AppBundle> builder(MarshallingType.SDK_POJO)
            .memberName("appBundle").getter(getter(GetAppBundleResponse::appBundle)).setter(setter(Builder::appBundle))
            .constructor(AppBundle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appBundle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BUNDLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AppBundle appBundle;

    private GetAppBundleResponse(BuilderImpl builder) {
        super(builder);
        this.appBundle = builder.appBundle;
    }

    /**
     * <p>
     * Contains information about an app bundle.
     * </p>
     * 
     * @return Contains information about an app bundle.
     */
    public final AppBundle appBundle() {
        return appBundle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appBundle());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAppBundleResponse)) {
            return false;
        }
        GetAppBundleResponse other = (GetAppBundleResponse) obj;
        return Objects.equals(appBundle(), other.appBundle());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAppBundleResponse").add("AppBundle", appBundle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appBundle":
            return Optional.ofNullable(clazz.cast(appBundle()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appBundle", APP_BUNDLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAppBundleResponse, T> g) {
        return obj -> g.apply((GetAppBundleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppFabricResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAppBundleResponse> {
        /**
         * <p>
         * Contains information about an app bundle.
         * </p>
         * 
         * @param appBundle
         *        Contains information about an app bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appBundle(AppBundle appBundle);

        /**
         * <p>
         * Contains information about an app bundle.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppBundle.Builder} avoiding the need to
         * create one manually via {@link AppBundle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppBundle.Builder#build()} is called immediately and its result
         * is passed to {@link #appBundle(AppBundle)}.
         * 
         * @param appBundle
         *        a consumer that will call methods on {@link AppBundle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appBundle(AppBundle)
         */
        default Builder appBundle(Consumer<AppBundle.Builder> appBundle) {
            return appBundle(AppBundle.builder().applyMutation(appBundle).build());
        }
    }

    static final class BuilderImpl extends AppFabricResponse.BuilderImpl implements Builder {
        private AppBundle appBundle;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAppBundleResponse model) {
            super(model);
            appBundle(model.appBundle);
        }

        public final AppBundle.Builder getAppBundle() {
            return appBundle != null ? appBundle.toBuilder() : null;
        }

        public final void setAppBundle(AppBundle.BuilderImpl appBundle) {
            this.appBundle = appBundle != null ? appBundle.build() : null;
        }

        @Override
        public final Builder appBundle(AppBundle appBundle) {
            this.appBundle = appBundle;
            return this;
        }

        @Override
        public GetAppBundleResponse build() {
            return new GetAppBundleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
