/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAppAuthorizationsResponse extends AppFabricResponse implements
        ToCopyableBuilder<ListAppAuthorizationsResponse.Builder, ListAppAuthorizationsResponse> {
    private static final SdkField<List<AppAuthorizationSummary>> APP_AUTHORIZATION_SUMMARY_LIST_FIELD = SdkField
            .<List<AppAuthorizationSummary>> builder(MarshallingType.LIST)
            .memberName("appAuthorizationSummaryList")
            .getter(getter(ListAppAuthorizationsResponse::appAuthorizationSummaryList))
            .setter(setter(Builder::appAuthorizationSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appAuthorizationSummaryList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AppAuthorizationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AppAuthorizationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAppAuthorizationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APP_AUTHORIZATION_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AppAuthorizationSummary> appAuthorizationSummaryList;

    private final String nextToken;

    private ListAppAuthorizationsResponse(BuilderImpl builder) {
        super(builder);
        this.appAuthorizationSummaryList = builder.appAuthorizationSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AppAuthorizationSummaryList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAppAuthorizationSummaryList() {
        return appAuthorizationSummaryList != null && !(appAuthorizationSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a list of app authorization summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAppAuthorizationSummaryList} method.
     * </p>
     * 
     * @return Contains a list of app authorization summaries.
     */
    public final List<AppAuthorizationSummary> appAuthorizationSummaryList() {
        return appAuthorizationSummaryList;
    }

    /**
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken error</i>.
     * </p>
     * 
     * @return If <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after
     *         24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken error</i>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAppAuthorizationSummaryList() ? appAuthorizationSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppAuthorizationsResponse)) {
            return false;
        }
        ListAppAuthorizationsResponse other = (ListAppAuthorizationsResponse) obj;
        return hasAppAuthorizationSummaryList() == other.hasAppAuthorizationSummaryList()
                && Objects.equals(appAuthorizationSummaryList(), other.appAuthorizationSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAppAuthorizationsResponse")
                .add("AppAuthorizationSummaryList", hasAppAuthorizationSummaryList() ? appAuthorizationSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appAuthorizationSummaryList":
            return Optional.ofNullable(clazz.cast(appAuthorizationSummaryList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appAuthorizationSummaryList", APP_AUTHORIZATION_SUMMARY_LIST_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAppAuthorizationsResponse, T> g) {
        return obj -> g.apply((ListAppAuthorizationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppFabricResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAppAuthorizationsResponse> {
        /**
         * <p>
         * Contains a list of app authorization summaries.
         * </p>
         * 
         * @param appAuthorizationSummaryList
         *        Contains a list of app authorization summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appAuthorizationSummaryList(Collection<AppAuthorizationSummary> appAuthorizationSummaryList);

        /**
         * <p>
         * Contains a list of app authorization summaries.
         * </p>
         * 
         * @param appAuthorizationSummaryList
         *        Contains a list of app authorization summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appAuthorizationSummaryList(AppAuthorizationSummary... appAuthorizationSummaryList);

        /**
         * <p>
         * Contains a list of app authorization summaries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appfabric.model.AppAuthorizationSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.appfabric.model.AppAuthorizationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appfabric.model.AppAuthorizationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #appAuthorizationSummaryList(List<AppAuthorizationSummary>)}.
         * 
         * @param appAuthorizationSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appfabric.model.AppAuthorizationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appAuthorizationSummaryList(java.util.Collection<AppAuthorizationSummary>)
         */
        Builder appAuthorizationSummaryList(Consumer<AppAuthorizationSummary.Builder>... appAuthorizationSummaryList);

        /**
         * <p>
         * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code>
         * is a unique pagination token for each page. Make the call again using the returned token to retrieve the next
         * page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired
         * pagination token will return an <i>HTTP 400 InvalidToken error</i>.
         * </p>
         * 
         * @param nextToken
         *        If <code>nextToken</code> is returned, there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token
         *        expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken
         *        error</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppFabricResponse.BuilderImpl implements Builder {
        private List<AppAuthorizationSummary> appAuthorizationSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppAuthorizationsResponse model) {
            super(model);
            appAuthorizationSummaryList(model.appAuthorizationSummaryList);
            nextToken(model.nextToken);
        }

        public final List<AppAuthorizationSummary.Builder> getAppAuthorizationSummaryList() {
            List<AppAuthorizationSummary.Builder> result = AppAuthorizationSummaryListCopier
                    .copyToBuilder(this.appAuthorizationSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppAuthorizationSummaryList(
                Collection<AppAuthorizationSummary.BuilderImpl> appAuthorizationSummaryList) {
            this.appAuthorizationSummaryList = AppAuthorizationSummaryListCopier.copyFromBuilder(appAuthorizationSummaryList);
        }

        @Override
        public final Builder appAuthorizationSummaryList(Collection<AppAuthorizationSummary> appAuthorizationSummaryList) {
            this.appAuthorizationSummaryList = AppAuthorizationSummaryListCopier.copy(appAuthorizationSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appAuthorizationSummaryList(AppAuthorizationSummary... appAuthorizationSummaryList) {
            appAuthorizationSummaryList(Arrays.asList(appAuthorizationSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appAuthorizationSummaryList(Consumer<AppAuthorizationSummary.Builder>... appAuthorizationSummaryList) {
            appAuthorizationSummaryList(Stream.of(appAuthorizationSummaryList)
                    .map(c -> AppAuthorizationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAppAuthorizationsResponse build() {
            return new ListAppAuthorizationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
