/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAppAuthorizationRequest extends AppFabricRequest implements
        ToCopyableBuilder<UpdateAppAuthorizationRequest.Builder, UpdateAppAuthorizationRequest> {
    private static final SdkField<String> APP_BUNDLE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appBundleIdentifier").getter(getter(UpdateAppAuthorizationRequest::appBundleIdentifier))
            .setter(setter(Builder::appBundleIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appBundleIdentifier").build()).build();

    private static final SdkField<String> APP_AUTHORIZATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appAuthorizationIdentifier").getter(getter(UpdateAppAuthorizationRequest::appAuthorizationIdentifier))
            .setter(setter(Builder::appAuthorizationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appAuthorizationIdentifier").build())
            .build();

    private static final SdkField<Credential> CREDENTIAL_FIELD = SdkField.<Credential> builder(MarshallingType.SDK_POJO)
            .memberName("credential").getter(getter(UpdateAppAuthorizationRequest::credential))
            .setter(setter(Builder::credential)).constructor(Credential::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credential").build()).build();

    private static final SdkField<Tenant> TENANT_FIELD = SdkField.<Tenant> builder(MarshallingType.SDK_POJO).memberName("tenant")
            .getter(getter(UpdateAppAuthorizationRequest::tenant)).setter(setter(Builder::tenant)).constructor(Tenant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tenant").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BUNDLE_IDENTIFIER_FIELD,
            APP_AUTHORIZATION_IDENTIFIER_FIELD, CREDENTIAL_FIELD, TENANT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appBundleIdentifier;

    private final String appAuthorizationIdentifier;

    private final Credential credential;

    private final Tenant tenant;

    private UpdateAppAuthorizationRequest(BuilderImpl builder) {
        super(builder);
        this.appBundleIdentifier = builder.appBundleIdentifier;
        this.appAuthorizationIdentifier = builder.appAuthorizationIdentifier;
        this.credential = builder.credential;
        this.tenant = builder.tenant;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the
     *         request.
     */
    public final String appBundleIdentifier() {
        return appBundleIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use for the
     * request.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use for
     *         the request.
     */
    public final String appAuthorizationIdentifier() {
        return appAuthorizationIdentifier;
    }

    /**
     * <p>
     * Contains credentials for the application, such as an API key or OAuth2 client ID and secret.
     * </p>
     * <p>
     * Specify credentials that match the authorization type of the app authorization to update. For example, if the
     * authorization type of the app authorization is OAuth2 (<code>oauth2</code>), then you should provide only the
     * OAuth2 credentials.
     * </p>
     * 
     * @return Contains credentials for the application, such as an API key or OAuth2 client ID and secret.</p>
     *         <p>
     *         Specify credentials that match the authorization type of the app authorization to update. For example, if
     *         the authorization type of the app authorization is OAuth2 (<code>oauth2</code>), then you should provide
     *         only the OAuth2 credentials.
     */
    public final Credential credential() {
        return credential;
    }

    /**
     * <p>
     * Contains information about an application tenant, such as the application display name and identifier.
     * </p>
     * 
     * @return Contains information about an application tenant, such as the application display name and identifier.
     */
    public final Tenant tenant() {
        return tenant;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appBundleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(appAuthorizationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(credential());
        hashCode = 31 * hashCode + Objects.hashCode(tenant());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAppAuthorizationRequest)) {
            return false;
        }
        UpdateAppAuthorizationRequest other = (UpdateAppAuthorizationRequest) obj;
        return Objects.equals(appBundleIdentifier(), other.appBundleIdentifier())
                && Objects.equals(appAuthorizationIdentifier(), other.appAuthorizationIdentifier())
                && Objects.equals(credential(), other.credential()) && Objects.equals(tenant(), other.tenant());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAppAuthorizationRequest").add("AppBundleIdentifier", appBundleIdentifier())
                .add("AppAuthorizationIdentifier", appAuthorizationIdentifier()).add("Credential", credential())
                .add("Tenant", tenant()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appBundleIdentifier":
            return Optional.ofNullable(clazz.cast(appBundleIdentifier()));
        case "appAuthorizationIdentifier":
            return Optional.ofNullable(clazz.cast(appAuthorizationIdentifier()));
        case "credential":
            return Optional.ofNullable(clazz.cast(credential()));
        case "tenant":
            return Optional.ofNullable(clazz.cast(tenant()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appBundleIdentifier", APP_BUNDLE_IDENTIFIER_FIELD);
        map.put("appAuthorizationIdentifier", APP_AUTHORIZATION_IDENTIFIER_FIELD);
        map.put("credential", CREDENTIAL_FIELD);
        map.put("tenant", TENANT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAppAuthorizationRequest, T> g) {
        return obj -> g.apply((UpdateAppAuthorizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppFabricRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAppAuthorizationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the
         * request.
         * </p>
         * 
         * @param appBundleIdentifier
         *        The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appBundleIdentifier(String appBundleIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use for the
         * request.
         * </p>
         * 
         * @param appAuthorizationIdentifier
         *        The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use
         *        for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appAuthorizationIdentifier(String appAuthorizationIdentifier);

        /**
         * <p>
         * Contains credentials for the application, such as an API key or OAuth2 client ID and secret.
         * </p>
         * <p>
         * Specify credentials that match the authorization type of the app authorization to update. For example, if the
         * authorization type of the app authorization is OAuth2 (<code>oauth2</code>), then you should provide only the
         * OAuth2 credentials.
         * </p>
         * 
         * @param credential
         *        Contains credentials for the application, such as an API key or OAuth2 client ID and secret.</p>
         *        <p>
         *        Specify credentials that match the authorization type of the app authorization to update. For example,
         *        if the authorization type of the app authorization is OAuth2 (<code>oauth2</code>), then you should
         *        provide only the OAuth2 credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credential(Credential credential);

        /**
         * <p>
         * Contains credentials for the application, such as an API key or OAuth2 client ID and secret.
         * </p>
         * <p>
         * Specify credentials that match the authorization type of the app authorization to update. For example, if the
         * authorization type of the app authorization is OAuth2 (<code>oauth2</code>), then you should provide only the
         * OAuth2 credentials.
         * </p>
         * This is a convenience method that creates an instance of the {@link Credential.Builder} avoiding the need to
         * create one manually via {@link Credential#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Credential.Builder#build()} is called immediately and its result
         * is passed to {@link #credential(Credential)}.
         * 
         * @param credential
         *        a consumer that will call methods on {@link Credential.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credential(Credential)
         */
        default Builder credential(Consumer<Credential.Builder> credential) {
            return credential(Credential.builder().applyMutation(credential).build());
        }

        /**
         * <p>
         * Contains information about an application tenant, such as the application display name and identifier.
         * </p>
         * 
         * @param tenant
         *        Contains information about an application tenant, such as the application display name and identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenant(Tenant tenant);

        /**
         * <p>
         * Contains information about an application tenant, such as the application display name and identifier.
         * </p>
         * This is a convenience method that creates an instance of the {@link Tenant.Builder} avoiding the need to
         * create one manually via {@link Tenant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Tenant.Builder#build()} is called immediately and its result is
         * passed to {@link #tenant(Tenant)}.
         * 
         * @param tenant
         *        a consumer that will call methods on {@link Tenant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tenant(Tenant)
         */
        default Builder tenant(Consumer<Tenant.Builder> tenant) {
            return tenant(Tenant.builder().applyMutation(tenant).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppFabricRequest.BuilderImpl implements Builder {
        private String appBundleIdentifier;

        private String appAuthorizationIdentifier;

        private Credential credential;

        private Tenant tenant;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAppAuthorizationRequest model) {
            super(model);
            appBundleIdentifier(model.appBundleIdentifier);
            appAuthorizationIdentifier(model.appAuthorizationIdentifier);
            credential(model.credential);
            tenant(model.tenant);
        }

        public final String getAppBundleIdentifier() {
            return appBundleIdentifier;
        }

        public final void setAppBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
        }

        @Override
        public final Builder appBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
            return this;
        }

        public final String getAppAuthorizationIdentifier() {
            return appAuthorizationIdentifier;
        }

        public final void setAppAuthorizationIdentifier(String appAuthorizationIdentifier) {
            this.appAuthorizationIdentifier = appAuthorizationIdentifier;
        }

        @Override
        public final Builder appAuthorizationIdentifier(String appAuthorizationIdentifier) {
            this.appAuthorizationIdentifier = appAuthorizationIdentifier;
            return this;
        }

        public final Credential.Builder getCredential() {
            return credential != null ? credential.toBuilder() : null;
        }

        public final void setCredential(Credential.BuilderImpl credential) {
            this.credential = credential != null ? credential.build() : null;
        }

        @Override
        public final Builder credential(Credential credential) {
            this.credential = credential;
            return this;
        }

        public final Tenant.Builder getTenant() {
            return tenant != null ? tenant.toBuilder() : null;
        }

        public final void setTenant(Tenant.BuilderImpl tenant) {
            this.tenant = tenant != null ? tenant.build() : null;
        }

        @Override
        public final Builder tenant(Tenant tenant) {
            this.tenant = tenant;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAppAuthorizationRequest build() {
            return new UpdateAppAuthorizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
