/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIngestionDestinationRequest extends AppFabricRequest implements
        ToCopyableBuilder<UpdateIngestionDestinationRequest.Builder, UpdateIngestionDestinationRequest> {
    private static final SdkField<String> APP_BUNDLE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appBundleIdentifier").getter(getter(UpdateIngestionDestinationRequest::appBundleIdentifier))
            .setter(setter(Builder::appBundleIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appBundleIdentifier").build()).build();

    private static final SdkField<String> INGESTION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ingestionIdentifier").getter(getter(UpdateIngestionDestinationRequest::ingestionIdentifier))
            .setter(setter(Builder::ingestionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ingestionIdentifier").build()).build();

    private static final SdkField<String> INGESTION_DESTINATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ingestionDestinationIdentifier")
            .getter(getter(UpdateIngestionDestinationRequest::ingestionDestinationIdentifier))
            .setter(setter(Builder::ingestionDestinationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ingestionDestinationIdentifier")
                    .build()).build();

    private static final SdkField<DestinationConfiguration> DESTINATION_CONFIGURATION_FIELD = SdkField
            .<DestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("destinationConfiguration")
            .getter(getter(UpdateIngestionDestinationRequest::destinationConfiguration))
            .setter(setter(Builder::destinationConfiguration)).constructor(DestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BUNDLE_IDENTIFIER_FIELD,
            INGESTION_IDENTIFIER_FIELD, INGESTION_DESTINATION_IDENTIFIER_FIELD, DESTINATION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appBundleIdentifier;

    private final String ingestionIdentifier;

    private final String ingestionDestinationIdentifier;

    private final DestinationConfiguration destinationConfiguration;

    private UpdateIngestionDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.appBundleIdentifier = builder.appBundleIdentifier;
        this.ingestionIdentifier = builder.ingestionIdentifier;
        this.ingestionDestinationIdentifier = builder.ingestionDestinationIdentifier;
        this.destinationConfiguration = builder.destinationConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the
     *         request.
     */
    public final String appBundleIdentifier() {
        return appBundleIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the request.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the
     *         request.
     */
    public final String ingestionIdentifier() {
        return ingestionIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion destination to use for the
     * request.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion destination to use
     *         for the request.
     */
    public final String ingestionDestinationIdentifier() {
        return ingestionDestinationIdentifier;
    }

    /**
     * <p>
     * Contains information about the destination of ingested data.
     * </p>
     * 
     * @return Contains information about the destination of ingested data.
     */
    public final DestinationConfiguration destinationConfiguration() {
        return destinationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appBundleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionDestinationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(destinationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIngestionDestinationRequest)) {
            return false;
        }
        UpdateIngestionDestinationRequest other = (UpdateIngestionDestinationRequest) obj;
        return Objects.equals(appBundleIdentifier(), other.appBundleIdentifier())
                && Objects.equals(ingestionIdentifier(), other.ingestionIdentifier())
                && Objects.equals(ingestionDestinationIdentifier(), other.ingestionDestinationIdentifier())
                && Objects.equals(destinationConfiguration(), other.destinationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIngestionDestinationRequest").add("AppBundleIdentifier", appBundleIdentifier())
                .add("IngestionIdentifier", ingestionIdentifier())
                .add("IngestionDestinationIdentifier", ingestionDestinationIdentifier())
                .add("DestinationConfiguration", destinationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appBundleIdentifier":
            return Optional.ofNullable(clazz.cast(appBundleIdentifier()));
        case "ingestionIdentifier":
            return Optional.ofNullable(clazz.cast(ingestionIdentifier()));
        case "ingestionDestinationIdentifier":
            return Optional.ofNullable(clazz.cast(ingestionDestinationIdentifier()));
        case "destinationConfiguration":
            return Optional.ofNullable(clazz.cast(destinationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appBundleIdentifier", APP_BUNDLE_IDENTIFIER_FIELD);
        map.put("ingestionIdentifier", INGESTION_IDENTIFIER_FIELD);
        map.put("ingestionDestinationIdentifier", INGESTION_DESTINATION_IDENTIFIER_FIELD);
        map.put("destinationConfiguration", DESTINATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIngestionDestinationRequest, T> g) {
        return obj -> g.apply((UpdateIngestionDestinationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppFabricRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateIngestionDestinationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the
         * request.
         * </p>
         * 
         * @param appBundleIdentifier
         *        The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appBundleIdentifier(String appBundleIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the request.
         * </p>
         * 
         * @param ingestionIdentifier
         *        The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionIdentifier(String ingestionIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion destination to use for
         * the request.
         * </p>
         * 
         * @param ingestionDestinationIdentifier
         *        The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion destination to
         *        use for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionDestinationIdentifier(String ingestionDestinationIdentifier);

        /**
         * <p>
         * Contains information about the destination of ingested data.
         * </p>
         * 
         * @param destinationConfiguration
         *        Contains information about the destination of ingested data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfiguration(DestinationConfiguration destinationConfiguration);

        /**
         * <p>
         * Contains information about the destination of ingested data.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link DestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #destinationConfiguration(DestinationConfiguration)}.
         * 
         * @param destinationConfiguration
         *        a consumer that will call methods on {@link DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConfiguration(DestinationConfiguration)
         */
        default Builder destinationConfiguration(Consumer<DestinationConfiguration.Builder> destinationConfiguration) {
            return destinationConfiguration(DestinationConfiguration.builder().applyMutation(destinationConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppFabricRequest.BuilderImpl implements Builder {
        private String appBundleIdentifier;

        private String ingestionIdentifier;

        private String ingestionDestinationIdentifier;

        private DestinationConfiguration destinationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIngestionDestinationRequest model) {
            super(model);
            appBundleIdentifier(model.appBundleIdentifier);
            ingestionIdentifier(model.ingestionIdentifier);
            ingestionDestinationIdentifier(model.ingestionDestinationIdentifier);
            destinationConfiguration(model.destinationConfiguration);
        }

        public final String getAppBundleIdentifier() {
            return appBundleIdentifier;
        }

        public final void setAppBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
        }

        @Override
        public final Builder appBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
            return this;
        }

        public final String getIngestionIdentifier() {
            return ingestionIdentifier;
        }

        public final void setIngestionIdentifier(String ingestionIdentifier) {
            this.ingestionIdentifier = ingestionIdentifier;
        }

        @Override
        public final Builder ingestionIdentifier(String ingestionIdentifier) {
            this.ingestionIdentifier = ingestionIdentifier;
            return this;
        }

        public final String getIngestionDestinationIdentifier() {
            return ingestionDestinationIdentifier;
        }

        public final void setIngestionDestinationIdentifier(String ingestionDestinationIdentifier) {
            this.ingestionDestinationIdentifier = ingestionDestinationIdentifier;
        }

        @Override
        public final Builder ingestionDestinationIdentifier(String ingestionDestinationIdentifier) {
            this.ingestionDestinationIdentifier = ingestionDestinationIdentifier;
            return this;
        }

        public final DestinationConfiguration.Builder getDestinationConfiguration() {
            return destinationConfiguration != null ? destinationConfiguration.toBuilder() : null;
        }

        public final void setDestinationConfiguration(DestinationConfiguration.BuilderImpl destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration != null ? destinationConfiguration.build() : null;
        }

        @Override
        public final Builder destinationConfiguration(DestinationConfiguration destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIngestionDestinationRequest build() {
            return new UpdateIngestionDestinationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
