/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains authorization request information, which is required for Amazon Web Services AppFabric to get the OAuth2
 * access token for an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthRequest implements SdkPojo, Serializable, ToCopyableBuilder<AuthRequest.Builder, AuthRequest> {
    private static final SdkField<String> REDIRECT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("redirectUri").getter(getter(AuthRequest::redirectUri)).setter(setter(Builder::redirectUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redirectUri").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(AuthRequest::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(REDIRECT_URI_FIELD, CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String redirectUri;

    private final String code;

    private AuthRequest(BuilderImpl builder) {
        this.redirectUri = builder.redirectUri;
        this.code = builder.code;
    }

    /**
     * <p>
     * The redirect URL that is specified in the AuthURL and the application client.
     * </p>
     * 
     * @return The redirect URL that is specified in the AuthURL and the application client.
     */
    public final String redirectUri() {
        return redirectUri;
    }

    /**
     * <p>
     * The authorization code returned by the application after permission is granted in the application OAuth page
     * (after clicking on the AuthURL).
     * </p>
     * 
     * @return The authorization code returned by the application after permission is granted in the application OAuth
     *         page (after clicking on the AuthURL).
     */
    public final String code() {
        return code;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(redirectUri());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthRequest)) {
            return false;
        }
        AuthRequest other = (AuthRequest) obj;
        return Objects.equals(redirectUri(), other.redirectUri()) && Objects.equals(code(), other.code());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthRequest").add("RedirectUri", redirectUri())
                .add("Code", code() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "redirectUri":
            return Optional.ofNullable(clazz.cast(redirectUri()));
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("redirectUri", REDIRECT_URI_FIELD);
        map.put("code", CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthRequest, T> g) {
        return obj -> g.apply((AuthRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthRequest> {
        /**
         * <p>
         * The redirect URL that is specified in the AuthURL and the application client.
         * </p>
         * 
         * @param redirectUri
         *        The redirect URL that is specified in the AuthURL and the application client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectUri(String redirectUri);

        /**
         * <p>
         * The authorization code returned by the application after permission is granted in the application OAuth page
         * (after clicking on the AuthURL).
         * </p>
         * 
         * @param code
         *        The authorization code returned by the application after permission is granted in the application
         *        OAuth page (after clicking on the AuthURL).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);
    }

    static final class BuilderImpl implements Builder {
        private String redirectUri;

        private String code;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthRequest model) {
            redirectUri(model.redirectUri);
            code(model.code);
        }

        public final String getRedirectUri() {
            return redirectUri;
        }

        public final void setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        @Override
        public final Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public AuthRequest build() {
            return new AuthRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
