/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAppAuthorizationRequest extends AppFabricRequest implements
        ToCopyableBuilder<CreateAppAuthorizationRequest.Builder, CreateAppAuthorizationRequest> {
    private static final SdkField<String> APP_BUNDLE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appBundleIdentifier").getter(getter(CreateAppAuthorizationRequest::appBundleIdentifier))
            .setter(setter(Builder::appBundleIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appBundleIdentifier").build()).build();

    private static final SdkField<String> APP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("app")
            .getter(getter(CreateAppAuthorizationRequest::app)).setter(setter(Builder::app))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("app").build()).build();

    private static final SdkField<Credential> CREDENTIAL_FIELD = SdkField.<Credential> builder(MarshallingType.SDK_POJO)
            .memberName("credential").getter(getter(CreateAppAuthorizationRequest::credential))
            .setter(setter(Builder::credential)).constructor(Credential::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credential").build()).build();

    private static final SdkField<Tenant> TENANT_FIELD = SdkField.<Tenant> builder(MarshallingType.SDK_POJO).memberName("tenant")
            .getter(getter(CreateAppAuthorizationRequest::tenant)).setter(setter(Builder::tenant)).constructor(Tenant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tenant").build()).build();

    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authType").getter(getter(CreateAppAuthorizationRequest::authTypeAsString))
            .setter(setter(Builder::authType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateAppAuthorizationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateAppAuthorizationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BUNDLE_IDENTIFIER_FIELD,
            APP_FIELD, CREDENTIAL_FIELD, TENANT_FIELD, AUTH_TYPE_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appBundleIdentifier;

    private final String app;

    private final Credential credential;

    private final Tenant tenant;

    private final String authType;

    private final String clientToken;

    private final List<Tag> tags;

    private CreateAppAuthorizationRequest(BuilderImpl builder) {
        super(builder);
        this.appBundleIdentifier = builder.appBundleIdentifier;
        this.app = builder.app;
        this.credential = builder.credential;
        this.tenant = builder.tenant;
        this.authType = builder.authType;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the
     *         request.
     */
    public final String appBundleIdentifier() {
        return appBundleIdentifier;
    }

    /**
     * <p>
     * The name of the application.
     * </p>
     * <p>
     * Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SLACK</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ASANA</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JIRA</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>M365</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>M365AUDITLOGS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ZOOM</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ZENDESK</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OKTA</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GOOGLE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DROPBOX</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SMARTSHEET</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CISCO</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the application.</p>
     *         <p>
     *         Valid values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SLACK</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ASANA</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JIRA</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>M365</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>M365AUDITLOGS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ZOOM</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ZENDESK</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OKTA</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GOOGLE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DROPBOX</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SMARTSHEET</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CISCO</code>
     *         </p>
     *         </li>
     */
    public final String app() {
        return app;
    }

    /**
     * <p>
     * Contains credentials for the application, such as an API key or OAuth2 client ID and secret.
     * </p>
     * <p>
     * Specify credentials that match the authorization type for your request. For example, if the authorization type
     * for your request is OAuth2 (<code>oauth2</code>), then you should provide only the OAuth2 credentials.
     * </p>
     * 
     * @return Contains credentials for the application, such as an API key or OAuth2 client ID and secret.</p>
     *         <p>
     *         Specify credentials that match the authorization type for your request. For example, if the authorization
     *         type for your request is OAuth2 (<code>oauth2</code>), then you should provide only the OAuth2
     *         credentials.
     */
    public final Credential credential() {
        return credential;
    }

    /**
     * <p>
     * Contains information about an application tenant, such as the application display name and identifier.
     * </p>
     * 
     * @return Contains information about an application tenant, such as the application display name and identifier.
     */
    public final Tenant tenant() {
        return tenant;
    }

    /**
     * <p>
     * The authorization type for the app authorization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The authorization type for the app authorization.
     * @see AuthType
     */
    public final AuthType authType() {
        return AuthType.fromValue(authType);
    }

    /**
     * <p>
     * The authorization type for the app authorization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The authorization type for the app authorization.
     * @see AuthType
     */
    public final String authTypeAsString() {
        return authType;
    }

    /**
     * <p>
     * Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This
     * lets you safely retry the request without accidentally performing the same operation a second time. Passing the
     * same value to a later call to an operation requires that you also pass the same value for all other parameters.
     * We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of
     * value</a>.
     * </p>
     * <p>
     * If you don't provide this value, then Amazon Web Services generates a random one for you.
     * </p>
     * <p>
     * If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry fails
     * with an <code>IdempotentParameterMismatch</code> error.
     * </p>
     * 
     * @return Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         This lets you safely retry the request without accidentally performing the same operation a second time.
     *         Passing the same value to a later call to an operation requires that you also pass the same value for all
     *         other parameters. We recommend that you use a <a
     *         href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value</a>.</p>
     *         <p>
     *         If you don't provide this value, then Amazon Web Services generates a random one for you.
     *         </p>
     *         <p>
     *         If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the
     *         retry fails with an <code>IdempotentParameterMismatch</code> error.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A map of the key-value pairs of the tag or tags to assign to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of the key-value pairs of the tag or tags to assign to the resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appBundleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(app());
        hashCode = 31 * hashCode + Objects.hashCode(credential());
        hashCode = 31 * hashCode + Objects.hashCode(tenant());
        hashCode = 31 * hashCode + Objects.hashCode(authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppAuthorizationRequest)) {
            return false;
        }
        CreateAppAuthorizationRequest other = (CreateAppAuthorizationRequest) obj;
        return Objects.equals(appBundleIdentifier(), other.appBundleIdentifier()) && Objects.equals(app(), other.app())
                && Objects.equals(credential(), other.credential()) && Objects.equals(tenant(), other.tenant())
                && Objects.equals(authTypeAsString(), other.authTypeAsString())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAppAuthorizationRequest").add("AppBundleIdentifier", appBundleIdentifier())
                .add("App", app()).add("Credential", credential()).add("Tenant", tenant()).add("AuthType", authTypeAsString())
                .add("ClientToken", clientToken()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appBundleIdentifier":
            return Optional.ofNullable(clazz.cast(appBundleIdentifier()));
        case "app":
            return Optional.ofNullable(clazz.cast(app()));
        case "credential":
            return Optional.ofNullable(clazz.cast(credential()));
        case "tenant":
            return Optional.ofNullable(clazz.cast(tenant()));
        case "authType":
            return Optional.ofNullable(clazz.cast(authTypeAsString()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appBundleIdentifier", APP_BUNDLE_IDENTIFIER_FIELD);
        map.put("app", APP_FIELD);
        map.put("credential", CREDENTIAL_FIELD);
        map.put("tenant", TENANT_FIELD);
        map.put("authType", AUTH_TYPE_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAppAuthorizationRequest, T> g) {
        return obj -> g.apply((CreateAppAuthorizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppFabricRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAppAuthorizationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the
         * request.
         * </p>
         * 
         * @param appBundleIdentifier
         *        The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appBundleIdentifier(String appBundleIdentifier);

        /**
         * <p>
         * The name of the application.
         * </p>
         * <p>
         * Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SLACK</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ASANA</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JIRA</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>M365</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>M365AUDITLOGS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ZOOM</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ZENDESK</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OKTA</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GOOGLE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DROPBOX</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SMARTSHEET</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CISCO</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param app
         *        The name of the application.</p>
         *        <p>
         *        Valid values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SLACK</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ASANA</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JIRA</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>M365</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>M365AUDITLOGS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ZOOM</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ZENDESK</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OKTA</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GOOGLE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DROPBOX</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SMARTSHEET</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CISCO</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder app(String app);

        /**
         * <p>
         * Contains credentials for the application, such as an API key or OAuth2 client ID and secret.
         * </p>
         * <p>
         * Specify credentials that match the authorization type for your request. For example, if the authorization
         * type for your request is OAuth2 (<code>oauth2</code>), then you should provide only the OAuth2 credentials.
         * </p>
         * 
         * @param credential
         *        Contains credentials for the application, such as an API key or OAuth2 client ID and secret.</p>
         *        <p>
         *        Specify credentials that match the authorization type for your request. For example, if the
         *        authorization type for your request is OAuth2 (<code>oauth2</code>), then you should provide only the
         *        OAuth2 credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credential(Credential credential);

        /**
         * <p>
         * Contains credentials for the application, such as an API key or OAuth2 client ID and secret.
         * </p>
         * <p>
         * Specify credentials that match the authorization type for your request. For example, if the authorization
         * type for your request is OAuth2 (<code>oauth2</code>), then you should provide only the OAuth2 credentials.
         * </p>
         * This is a convenience method that creates an instance of the {@link Credential.Builder} avoiding the need to
         * create one manually via {@link Credential#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Credential.Builder#build()} is called immediately and its result
         * is passed to {@link #credential(Credential)}.
         * 
         * @param credential
         *        a consumer that will call methods on {@link Credential.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credential(Credential)
         */
        default Builder credential(Consumer<Credential.Builder> credential) {
            return credential(Credential.builder().applyMutation(credential).build());
        }

        /**
         * <p>
         * Contains information about an application tenant, such as the application display name and identifier.
         * </p>
         * 
         * @param tenant
         *        Contains information about an application tenant, such as the application display name and identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenant(Tenant tenant);

        /**
         * <p>
         * Contains information about an application tenant, such as the application display name and identifier.
         * </p>
         * This is a convenience method that creates an instance of the {@link Tenant.Builder} avoiding the need to
         * create one manually via {@link Tenant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Tenant.Builder#build()} is called immediately and its result is
         * passed to {@link #tenant(Tenant)}.
         * 
         * @param tenant
         *        a consumer that will call methods on {@link Tenant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tenant(Tenant)
         */
        default Builder tenant(Consumer<Tenant.Builder> tenant) {
            return tenant(Tenant.builder().applyMutation(tenant).build());
        }

        /**
         * <p>
         * The authorization type for the app authorization.
         * </p>
         * 
         * @param authType
         *        The authorization type for the app authorization.
         * @see AuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthType
         */
        Builder authType(String authType);

        /**
         * <p>
         * The authorization type for the app authorization.
         * </p>
         * 
         * @param authType
         *        The authorization type for the app authorization.
         * @see AuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthType
         */
        Builder authType(AuthType authType);

        /**
         * <p>
         * Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This
         * lets you safely retry the request without accidentally performing the same operation a second time. Passing
         * the same value to a later call to an operation requires that you also pass the same value for all other
         * parameters. We recommend that you use a <a
         * href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value</a>.
         * </p>
         * <p>
         * If you don't provide this value, then Amazon Web Services generates a random one for you.
         * </p>
         * <p>
         * If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry
         * fails with an <code>IdempotentParameterMismatch</code> error.
         * </p>
         * 
         * @param clientToken
         *        Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the
         *        request. This lets you safely retry the request without accidentally performing the same operation a
         *        second time. Passing the same value to a later call to an operation requires that you also pass the
         *        same value for all other parameters. We recommend that you use a <a
         *        href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value</a>.</p>
         *        <p>
         *        If you don't provide this value, then Amazon Web Services generates a random one for you.
         *        </p>
         *        <p>
         *        If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the
         *        retry fails with an <code>IdempotentParameterMismatch</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A map of the key-value pairs of the tag or tags to assign to the resource.
         * </p>
         * 
         * @param tags
         *        A map of the key-value pairs of the tag or tags to assign to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A map of the key-value pairs of the tag or tags to assign to the resource.
         * </p>
         * 
         * @param tags
         *        A map of the key-value pairs of the tag or tags to assign to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A map of the key-value pairs of the tag or tags to assign to the resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appfabric.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.appfabric.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appfabric.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appfabric.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppFabricRequest.BuilderImpl implements Builder {
        private String appBundleIdentifier;

        private String app;

        private Credential credential;

        private Tenant tenant;

        private String authType;

        private String clientToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppAuthorizationRequest model) {
            super(model);
            appBundleIdentifier(model.appBundleIdentifier);
            app(model.app);
            credential(model.credential);
            tenant(model.tenant);
            authType(model.authType);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getAppBundleIdentifier() {
            return appBundleIdentifier;
        }

        public final void setAppBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
        }

        @Override
        public final Builder appBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
            return this;
        }

        public final String getApp() {
            return app;
        }

        public final void setApp(String app) {
            this.app = app;
        }

        @Override
        public final Builder app(String app) {
            this.app = app;
            return this;
        }

        public final Credential.Builder getCredential() {
            return credential != null ? credential.toBuilder() : null;
        }

        public final void setCredential(Credential.BuilderImpl credential) {
            this.credential = credential != null ? credential.build() : null;
        }

        @Override
        public final Builder credential(Credential credential) {
            this.credential = credential;
            return this;
        }

        public final Tenant.Builder getTenant() {
            return tenant != null ? tenant.toBuilder() : null;
        }

        public final void setTenant(Tenant.BuilderImpl tenant) {
            this.tenant = tenant != null ? tenant.build() : null;
        }

        @Override
        public final Builder tenant(Tenant tenant) {
            this.tenant = tenant;
            return this;
        }

        public final String getAuthType() {
            return authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAppAuthorizationRequest build() {
            return new CreateAppAuthorizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
