/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appfabric.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an ingestion.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ingestion implements SdkPojo, Serializable, ToCopyableBuilder<Ingestion.Builder, Ingestion> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Ingestion::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> APP_BUNDLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appBundleArn").getter(getter(Ingestion::appBundleArn)).setter(setter(Builder::appBundleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appBundleArn").build()).build();

    private static final SdkField<String> APP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("app")
            .getter(getter(Ingestion::app)).setter(setter(Builder::app))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("app").build()).build();

    private static final SdkField<String> TENANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tenantId").getter(getter(Ingestion::tenantId)).setter(setter(Builder::tenantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tenantId").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(Ingestion::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(Ingestion::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(Ingestion::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> INGESTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ingestionType").getter(getter(Ingestion::ingestionTypeAsString)).setter(setter(Builder::ingestionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            APP_BUNDLE_ARN_FIELD, APP_FIELD, TENANT_ID_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, STATE_FIELD,
            INGESTION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String appBundleArn;

    private final String app;

    private final String tenantId;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String state;

    private final String ingestionType;

    private Ingestion(BuilderImpl builder) {
        this.arn = builder.arn;
        this.appBundleArn = builder.appBundleArn;
        this.app = builder.app;
        this.tenantId = builder.tenantId;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.state = builder.state;
        this.ingestionType = builder.ingestionType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the ingestion.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the ingestion.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the app bundle for the ingestion.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the app bundle for the ingestion.
     */
    public final String appBundleArn() {
        return appBundleArn;
    }

    /**
     * <p>
     * The name of the application.
     * </p>
     * 
     * @return The name of the application.
     */
    public final String app() {
        return app;
    }

    /**
     * <p>
     * The ID of the application tenant.
     * </p>
     * 
     * @return The ID of the application tenant.
     */
    public final String tenantId() {
        return tenantId;
    }

    /**
     * <p>
     * The timestamp of when the ingestion was created.
     * </p>
     * 
     * @return The timestamp of when the ingestion was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp of when the ingestion was last updated.
     * </p>
     * 
     * @return The timestamp of when the ingestion was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The status of the ingestion.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link IngestionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The status of the ingestion.
     * @see IngestionState
     */
    public final IngestionState state() {
        return IngestionState.fromValue(state);
    }

    /**
     * <p>
     * The status of the ingestion.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link IngestionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The status of the ingestion.
     * @see IngestionState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The type of the ingestion.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ingestionType}
     * will return {@link IngestionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ingestionTypeAsString}.
     * </p>
     * 
     * @return The type of the ingestion.
     * @see IngestionType
     */
    public final IngestionType ingestionType() {
        return IngestionType.fromValue(ingestionType);
    }

    /**
     * <p>
     * The type of the ingestion.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ingestionType}
     * will return {@link IngestionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ingestionTypeAsString}.
     * </p>
     * 
     * @return The type of the ingestion.
     * @see IngestionType
     */
    public final String ingestionTypeAsString() {
        return ingestionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(appBundleArn());
        hashCode = 31 * hashCode + Objects.hashCode(app());
        hashCode = 31 * hashCode + Objects.hashCode(tenantId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ingestion)) {
            return false;
        }
        Ingestion other = (Ingestion) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(appBundleArn(), other.appBundleArn())
                && Objects.equals(app(), other.app()) && Objects.equals(tenantId(), other.tenantId())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(ingestionTypeAsString(), other.ingestionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ingestion").add("Arn", arn()).add("AppBundleArn", appBundleArn()).add("App", app())
                .add("TenantId", tenantId()).add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt())
                .add("State", stateAsString()).add("IngestionType", ingestionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "appBundleArn":
            return Optional.ofNullable(clazz.cast(appBundleArn()));
        case "app":
            return Optional.ofNullable(clazz.cast(app()));
        case "tenantId":
            return Optional.ofNullable(clazz.cast(tenantId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "ingestionType":
            return Optional.ofNullable(clazz.cast(ingestionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("appBundleArn", APP_BUNDLE_ARN_FIELD);
        map.put("app", APP_FIELD);
        map.put("tenantId", TENANT_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("state", STATE_FIELD);
        map.put("ingestionType", INGESTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Ingestion, T> g) {
        return obj -> g.apply((Ingestion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ingestion> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the ingestion.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the ingestion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the app bundle for the ingestion.
         * </p>
         * 
         * @param appBundleArn
         *        The Amazon Resource Name (ARN) of the app bundle for the ingestion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appBundleArn(String appBundleArn);

        /**
         * <p>
         * The name of the application.
         * </p>
         * 
         * @param app
         *        The name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder app(String app);

        /**
         * <p>
         * The ID of the application tenant.
         * </p>
         * 
         * @param tenantId
         *        The ID of the application tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantId(String tenantId);

        /**
         * <p>
         * The timestamp of when the ingestion was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the ingestion was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp of when the ingestion was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when the ingestion was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The status of the ingestion.
         * </p>
         * 
         * @param state
         *        The status of the ingestion.
         * @see IngestionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionState
         */
        Builder state(String state);

        /**
         * <p>
         * The status of the ingestion.
         * </p>
         * 
         * @param state
         *        The status of the ingestion.
         * @see IngestionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionState
         */
        Builder state(IngestionState state);

        /**
         * <p>
         * The type of the ingestion.
         * </p>
         * 
         * @param ingestionType
         *        The type of the ingestion.
         * @see IngestionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionType
         */
        Builder ingestionType(String ingestionType);

        /**
         * <p>
         * The type of the ingestion.
         * </p>
         * 
         * @param ingestionType
         *        The type of the ingestion.
         * @see IngestionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionType
         */
        Builder ingestionType(IngestionType ingestionType);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String appBundleArn;

        private String app;

        private String tenantId;

        private Instant createdAt;

        private Instant updatedAt;

        private String state;

        private String ingestionType;

        private BuilderImpl() {
        }

        private BuilderImpl(Ingestion model) {
            arn(model.arn);
            appBundleArn(model.appBundleArn);
            app(model.app);
            tenantId(model.tenantId);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            state(model.state);
            ingestionType(model.ingestionType);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAppBundleArn() {
            return appBundleArn;
        }

        public final void setAppBundleArn(String appBundleArn) {
            this.appBundleArn = appBundleArn;
        }

        @Override
        public final Builder appBundleArn(String appBundleArn) {
            this.appBundleArn = appBundleArn;
            return this;
        }

        public final String getApp() {
            return app;
        }

        public final void setApp(String app) {
            this.app = app;
        }

        @Override
        public final Builder app(String app) {
            this.app = app;
            return this;
        }

        public final String getTenantId() {
            return tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(IngestionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getIngestionType() {
            return ingestionType;
        }

        public final void setIngestionType(String ingestionType) {
            this.ingestionType = ingestionType;
        }

        @Override
        public final Builder ingestionType(String ingestionType) {
            this.ingestionType = ingestionType;
            return this;
        }

        @Override
        public final Builder ingestionType(IngestionType ingestionType) {
            this.ingestionType(ingestionType == null ? null : ingestionType.toString());
            return this;
        }

        @Override
        public Ingestion build() {
            return new Ingestion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
