/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appfabric.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an ingestion destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IngestionDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<IngestionDestination.Builder, IngestionDestination> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(IngestionDestination::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> INGESTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ingestionArn").getter(getter(IngestionDestination::ingestionArn)).setter(setter(Builder::ingestionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestionArn").build()).build();

    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField
            .<ProcessingConfiguration> builder(MarshallingType.SDK_POJO).memberName("processingConfiguration")
            .getter(getter(IngestionDestination::processingConfiguration)).setter(setter(Builder::processingConfiguration))
            .constructor(ProcessingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processingConfiguration").build())
            .build();

    private static final SdkField<DestinationConfiguration> DESTINATION_CONFIGURATION_FIELD = SdkField
            .<DestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("destinationConfiguration")
            .getter(getter(IngestionDestination::destinationConfiguration)).setter(setter(Builder::destinationConfiguration))
            .constructor(DestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfiguration").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(IngestionDestination::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(IngestionDestination::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(IngestionDestination::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(IngestionDestination::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            INGESTION_ARN_FIELD, PROCESSING_CONFIGURATION_FIELD, DESTINATION_CONFIGURATION_FIELD, STATUS_FIELD,
            STATUS_REASON_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String ingestionArn;

    private final ProcessingConfiguration processingConfiguration;

    private final DestinationConfiguration destinationConfiguration;

    private final String status;

    private final String statusReason;

    private final Instant createdAt;

    private final Instant updatedAt;

    private IngestionDestination(BuilderImpl builder) {
        this.arn = builder.arn;
        this.ingestionArn = builder.ingestionArn;
        this.processingConfiguration = builder.processingConfiguration;
        this.destinationConfiguration = builder.destinationConfiguration;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the ingestion destination.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the ingestion destination.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the ingestion.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the ingestion.
     */
    public final String ingestionArn() {
        return ingestionArn;
    }

    /**
     * <p>
     * Contains information about how ingested data is processed.
     * </p>
     * 
     * @return Contains information about how ingested data is processed.
     */
    public final ProcessingConfiguration processingConfiguration() {
        return processingConfiguration;
    }

    /**
     * <p>
     * Contains information about the destination of ingested data.
     * </p>
     * 
     * @return Contains information about the destination of ingested data.
     */
    public final DestinationConfiguration destinationConfiguration() {
        return destinationConfiguration;
    }

    /**
     * <p>
     * The state of the ingestion destination.
     * </p>
     * <p>
     * The following states are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Active</code>: The ingestion destination is active and is ready to be used.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code>: The ingestion destination has failed. If the ingestion destination is in this state, you
     * should verify the ingestion destination configuration and try again.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IngestionDestinationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the ingestion destination.</p>
     *         <p>
     *         The following states are possible:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Active</code>: The ingestion destination is active and is ready to be used.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code>: The ingestion destination has failed. If the ingestion destination is in this state,
     *         you should verify the ingestion destination configuration and try again.
     *         </p>
     *         </li>
     * @see IngestionDestinationStatus
     */
    public final IngestionDestinationStatus status() {
        return IngestionDestinationStatus.fromValue(status);
    }

    /**
     * <p>
     * The state of the ingestion destination.
     * </p>
     * <p>
     * The following states are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Active</code>: The ingestion destination is active and is ready to be used.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code>: The ingestion destination has failed. If the ingestion destination is in this state, you
     * should verify the ingestion destination configuration and try again.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IngestionDestinationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the ingestion destination.</p>
     *         <p>
     *         The following states are possible:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Active</code>: The ingestion destination is active and is ready to be used.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code>: The ingestion destination has failed. If the ingestion destination is in this state,
     *         you should verify the ingestion destination configuration and try again.
     *         </p>
     *         </li>
     * @see IngestionDestinationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the current status of the ingestion destination.
     * </p>
     * <p>
     * Only present when the <code>status</code> of ingestion destination is <code>Failed</code>.
     * </p>
     * 
     * @return The reason for the current status of the ingestion destination.</p>
     *         <p>
     *         Only present when the <code>status</code> of ingestion destination is <code>Failed</code>.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The timestamp of when the ingestion destination was created.
     * </p>
     * 
     * @return The timestamp of when the ingestion destination was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp of when the ingestion destination was last updated.
     * </p>
     * 
     * @return The timestamp of when the ingestion destination was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionArn());
        hashCode = 31 * hashCode + Objects.hashCode(processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(destinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestionDestination)) {
            return false;
        }
        IngestionDestination other = (IngestionDestination) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(ingestionArn(), other.ingestionArn())
                && Objects.equals(processingConfiguration(), other.processingConfiguration())
                && Objects.equals(destinationConfiguration(), other.destinationConfiguration())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IngestionDestination").add("Arn", arn()).add("IngestionArn", ingestionArn())
                .add("ProcessingConfiguration", processingConfiguration())
                .add("DestinationConfiguration", destinationConfiguration()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ingestionArn":
            return Optional.ofNullable(clazz.cast(ingestionArn()));
        case "processingConfiguration":
            return Optional.ofNullable(clazz.cast(processingConfiguration()));
        case "destinationConfiguration":
            return Optional.ofNullable(clazz.cast(destinationConfiguration()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("ingestionArn", INGESTION_ARN_FIELD);
        map.put("processingConfiguration", PROCESSING_CONFIGURATION_FIELD);
        map.put("destinationConfiguration", DESTINATION_CONFIGURATION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngestionDestination, T> g) {
        return obj -> g.apply((IngestionDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IngestionDestination> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the ingestion destination.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the ingestion destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the ingestion.
         * </p>
         * 
         * @param ingestionArn
         *        The Amazon Resource Name (ARN) of the ingestion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionArn(String ingestionArn);

        /**
         * <p>
         * Contains information about how ingested data is processed.
         * </p>
         * 
         * @param processingConfiguration
         *        Contains information about how ingested data is processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingConfiguration(ProcessingConfiguration processingConfiguration);

        /**
         * <p>
         * Contains information about how ingested data is processed.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProcessingConfiguration.Builder} avoiding
         * the need to create one manually via {@link ProcessingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProcessingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #processingConfiguration(ProcessingConfiguration)}.
         * 
         * @param processingConfiguration
         *        a consumer that will call methods on {@link ProcessingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingConfiguration(ProcessingConfiguration)
         */
        default Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return processingConfiguration(ProcessingConfiguration.builder().applyMutation(processingConfiguration).build());
        }

        /**
         * <p>
         * Contains information about the destination of ingested data.
         * </p>
         * 
         * @param destinationConfiguration
         *        Contains information about the destination of ingested data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfiguration(DestinationConfiguration destinationConfiguration);

        /**
         * <p>
         * Contains information about the destination of ingested data.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link DestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #destinationConfiguration(DestinationConfiguration)}.
         * 
         * @param destinationConfiguration
         *        a consumer that will call methods on {@link DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConfiguration(DestinationConfiguration)
         */
        default Builder destinationConfiguration(Consumer<DestinationConfiguration.Builder> destinationConfiguration) {
            return destinationConfiguration(DestinationConfiguration.builder().applyMutation(destinationConfiguration).build());
        }

        /**
         * <p>
         * The state of the ingestion destination.
         * </p>
         * <p>
         * The following states are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Active</code>: The ingestion destination is active and is ready to be used.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code>: The ingestion destination has failed. If the ingestion destination is in this state, you
         * should verify the ingestion destination configuration and try again.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The state of the ingestion destination.</p>
         *        <p>
         *        The following states are possible:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Active</code>: The ingestion destination is active and is ready to be used.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code>: The ingestion destination has failed. If the ingestion destination is in this
         *        state, you should verify the ingestion destination configuration and try again.
         *        </p>
         *        </li>
         * @see IngestionDestinationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionDestinationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The state of the ingestion destination.
         * </p>
         * <p>
         * The following states are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Active</code>: The ingestion destination is active and is ready to be used.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code>: The ingestion destination has failed. If the ingestion destination is in this state, you
         * should verify the ingestion destination configuration and try again.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The state of the ingestion destination.</p>
         *        <p>
         *        The following states are possible:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Active</code>: The ingestion destination is active and is ready to be used.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code>: The ingestion destination has failed. If the ingestion destination is in this
         *        state, you should verify the ingestion destination configuration and try again.
         *        </p>
         *        </li>
         * @see IngestionDestinationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionDestinationStatus
         */
        Builder status(IngestionDestinationStatus status);

        /**
         * <p>
         * The reason for the current status of the ingestion destination.
         * </p>
         * <p>
         * Only present when the <code>status</code> of ingestion destination is <code>Failed</code>.
         * </p>
         * 
         * @param statusReason
         *        The reason for the current status of the ingestion destination.</p>
         *        <p>
         *        Only present when the <code>status</code> of ingestion destination is <code>Failed</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The timestamp of when the ingestion destination was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the ingestion destination was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp of when the ingestion destination was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when the ingestion destination was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String ingestionArn;

        private ProcessingConfiguration processingConfiguration;

        private DestinationConfiguration destinationConfiguration;

        private String status;

        private String statusReason;

        private Instant createdAt;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(IngestionDestination model) {
            arn(model.arn);
            ingestionArn(model.ingestionArn);
            processingConfiguration(model.processingConfiguration);
            destinationConfiguration(model.destinationConfiguration);
            status(model.status);
            statusReason(model.statusReason);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getIngestionArn() {
            return ingestionArn;
        }

        public final void setIngestionArn(String ingestionArn) {
            this.ingestionArn = ingestionArn;
        }

        @Override
        public final Builder ingestionArn(String ingestionArn) {
            this.ingestionArn = ingestionArn;
            return this;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return processingConfiguration != null ? processingConfiguration.toBuilder() : null;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final DestinationConfiguration.Builder getDestinationConfiguration() {
            return destinationConfiguration != null ? destinationConfiguration.toBuilder() : null;
        }

        public final void setDestinationConfiguration(DestinationConfiguration.BuilderImpl destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration != null ? destinationConfiguration.build() : null;
        }

        @Override
        public final Builder destinationConfiguration(DestinationConfiguration destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IngestionDestinationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public IngestionDestination build() {
            return new IngestionDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
