/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartIngestionRequest extends AppFabricRequest implements
        ToCopyableBuilder<StartIngestionRequest.Builder, StartIngestionRequest> {
    private static final SdkField<String> INGESTION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ingestionIdentifier").getter(getter(StartIngestionRequest::ingestionIdentifier))
            .setter(setter(Builder::ingestionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ingestionIdentifier").build()).build();

    private static final SdkField<String> APP_BUNDLE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appBundleIdentifier").getter(getter(StartIngestionRequest::appBundleIdentifier))
            .setter(setter(Builder::appBundleIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appBundleIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INGESTION_IDENTIFIER_FIELD,
            APP_BUNDLE_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String ingestionIdentifier;

    private final String appBundleIdentifier;

    private StartIngestionRequest(BuilderImpl builder) {
        super(builder);
        this.ingestionIdentifier = builder.ingestionIdentifier;
        this.appBundleIdentifier = builder.appBundleIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the request.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the
     *         request.
     */
    public final String ingestionIdentifier() {
        return ingestionIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the
     *         request.
     */
    public final String appBundleIdentifier() {
        return appBundleIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ingestionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(appBundleIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartIngestionRequest)) {
            return false;
        }
        StartIngestionRequest other = (StartIngestionRequest) obj;
        return Objects.equals(ingestionIdentifier(), other.ingestionIdentifier())
                && Objects.equals(appBundleIdentifier(), other.appBundleIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartIngestionRequest").add("IngestionIdentifier", ingestionIdentifier())
                .add("AppBundleIdentifier", appBundleIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ingestionIdentifier":
            return Optional.ofNullable(clazz.cast(ingestionIdentifier()));
        case "appBundleIdentifier":
            return Optional.ofNullable(clazz.cast(appBundleIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ingestionIdentifier", INGESTION_IDENTIFIER_FIELD);
        map.put("appBundleIdentifier", APP_BUNDLE_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartIngestionRequest, T> g) {
        return obj -> g.apply((StartIngestionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppFabricRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartIngestionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the request.
         * </p>
         * 
         * @param ingestionIdentifier
         *        The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionIdentifier(String ingestionIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the
         * request.
         * </p>
         * 
         * @param appBundleIdentifier
         *        The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appBundleIdentifier(String appBundleIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppFabricRequest.BuilderImpl implements Builder {
        private String ingestionIdentifier;

        private String appBundleIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(StartIngestionRequest model) {
            super(model);
            ingestionIdentifier(model.ingestionIdentifier);
            appBundleIdentifier(model.appBundleIdentifier);
        }

        public final String getIngestionIdentifier() {
            return ingestionIdentifier;
        }

        public final void setIngestionIdentifier(String ingestionIdentifier) {
            this.ingestionIdentifier = ingestionIdentifier;
        }

        @Override
        public final Builder ingestionIdentifier(String ingestionIdentifier) {
            this.ingestionIdentifier = ingestionIdentifier;
            return this;
        }

        public final String getAppBundleIdentifier() {
            return appBundleIdentifier;
        }

        public final void setAppBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
        }

        @Override
        public final Builder appBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartIngestionRequest build() {
            return new StartIngestionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
