/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an application tenant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Tenant implements SdkPojo, Serializable, ToCopyableBuilder<Tenant.Builder, Tenant> {
    private static final SdkField<String> TENANT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tenantIdentifier").getter(getter(Tenant::tenantIdentifier)).setter(setter(Builder::tenantIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tenantIdentifier").build()).build();

    private static final SdkField<String> TENANT_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tenantDisplayName").getter(getter(Tenant::tenantDisplayName)).setter(setter(Builder::tenantDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tenantDisplayName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANT_IDENTIFIER_FIELD,
            TENANT_DISPLAY_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tenantIdentifier;

    private final String tenantDisplayName;

    private Tenant(BuilderImpl builder) {
        this.tenantIdentifier = builder.tenantIdentifier;
        this.tenantDisplayName = builder.tenantDisplayName;
    }

    /**
     * <p>
     * The ID of the application tenant.
     * </p>
     * 
     * @return The ID of the application tenant.
     */
    public final String tenantIdentifier() {
        return tenantIdentifier;
    }

    /**
     * <p>
     * The display name of the tenant.
     * </p>
     * 
     * @return The display name of the tenant.
     */
    public final String tenantDisplayName() {
        return tenantDisplayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tenantIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(tenantDisplayName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tenant)) {
            return false;
        }
        Tenant other = (Tenant) obj;
        return Objects.equals(tenantIdentifier(), other.tenantIdentifier())
                && Objects.equals(tenantDisplayName(), other.tenantDisplayName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Tenant").add("TenantIdentifier", tenantIdentifier())
                .add("TenantDisplayName", tenantDisplayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tenantIdentifier":
            return Optional.ofNullable(clazz.cast(tenantIdentifier()));
        case "tenantDisplayName":
            return Optional.ofNullable(clazz.cast(tenantDisplayName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tenantIdentifier", TENANT_IDENTIFIER_FIELD);
        map.put("tenantDisplayName", TENANT_DISPLAY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Tenant, T> g) {
        return obj -> g.apply((Tenant) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Tenant> {
        /**
         * <p>
         * The ID of the application tenant.
         * </p>
         * 
         * @param tenantIdentifier
         *        The ID of the application tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantIdentifier(String tenantIdentifier);

        /**
         * <p>
         * The display name of the tenant.
         * </p>
         * 
         * @param tenantDisplayName
         *        The display name of the tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantDisplayName(String tenantDisplayName);
    }

    static final class BuilderImpl implements Builder {
        private String tenantIdentifier;

        private String tenantDisplayName;

        private BuilderImpl() {
        }

        private BuilderImpl(Tenant model) {
            tenantIdentifier(model.tenantIdentifier);
            tenantDisplayName(model.tenantDisplayName);
        }

        public final String getTenantIdentifier() {
            return tenantIdentifier;
        }

        public final void setTenantIdentifier(String tenantIdentifier) {
            this.tenantIdentifier = tenantIdentifier;
        }

        @Override
        public final Builder tenantIdentifier(String tenantIdentifier) {
            this.tenantIdentifier = tenantIdentifier;
            return this;
        }

        public final String getTenantDisplayName() {
            return tenantDisplayName;
        }

        public final void setTenantDisplayName(String tenantDisplayName) {
            this.tenantDisplayName = tenantDisplayName;
        }

        @Override
        public final Builder tenantDisplayName(String tenantDisplayName) {
            this.tenantDisplayName = tenantDisplayName;
            return this;
        }

        @Override
        public Tenant build() {
            return new Tenant(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
