/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a user access task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserAccessTaskItem implements SdkPojo, Serializable,
        ToCopyableBuilder<UserAccessTaskItem.Builder, UserAccessTaskItem> {
    private static final SdkField<String> APP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("app")
            .getter(getter(UserAccessTaskItem::app)).setter(setter(Builder::app))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("app").build()).build();

    private static final SdkField<String> TENANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tenantId").getter(getter(UserAccessTaskItem::tenantId)).setter(setter(Builder::tenantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tenantId").build()).build();

    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(UserAccessTaskItem::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final SdkField<TaskError> ERROR_FIELD = SdkField.<TaskError> builder(MarshallingType.SDK_POJO)
            .memberName("error").getter(getter(UserAccessTaskItem::error)).setter(setter(Builder::error))
            .constructor(TaskError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_FIELD, TENANT_ID_FIELD,
            TASK_ID_FIELD, ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String app;

    private final String tenantId;

    private final String taskId;

    private final TaskError error;

    private UserAccessTaskItem(BuilderImpl builder) {
        this.app = builder.app;
        this.tenantId = builder.tenantId;
        this.taskId = builder.taskId;
        this.error = builder.error;
    }

    /**
     * <p>
     * The name of the application.
     * </p>
     * 
     * @return The name of the application.
     */
    public final String app() {
        return app;
    }

    /**
     * <p>
     * The ID of the application tenant.
     * </p>
     * 
     * @return The ID of the application tenant.
     */
    public final String tenantId() {
        return tenantId;
    }

    /**
     * <p>
     * The unique ID of the task.
     * </p>
     * 
     * @return The unique ID of the task.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * Error from the task, if any.
     * </p>
     * 
     * @return Error from the task, if any.
     */
    public final TaskError error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(app());
        hashCode = 31 * hashCode + Objects.hashCode(tenantId());
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserAccessTaskItem)) {
            return false;
        }
        UserAccessTaskItem other = (UserAccessTaskItem) obj;
        return Objects.equals(app(), other.app()) && Objects.equals(tenantId(), other.tenantId())
                && Objects.equals(taskId(), other.taskId()) && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserAccessTaskItem").add("App", app()).add("TenantId", tenantId()).add("TaskId", taskId())
                .add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "app":
            return Optional.ofNullable(clazz.cast(app()));
        case "tenantId":
            return Optional.ofNullable(clazz.cast(tenantId()));
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("app", APP_FIELD);
        map.put("tenantId", TENANT_ID_FIELD);
        map.put("taskId", TASK_ID_FIELD);
        map.put("error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserAccessTaskItem, T> g) {
        return obj -> g.apply((UserAccessTaskItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserAccessTaskItem> {
        /**
         * <p>
         * The name of the application.
         * </p>
         * 
         * @param app
         *        The name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder app(String app);

        /**
         * <p>
         * The ID of the application tenant.
         * </p>
         * 
         * @param tenantId
         *        The ID of the application tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantId(String tenantId);

        /**
         * <p>
         * The unique ID of the task.
         * </p>
         * 
         * @param taskId
         *        The unique ID of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * Error from the task, if any.
         * </p>
         * 
         * @param error
         *        Error from the task, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(TaskError error);

        /**
         * <p>
         * Error from the task, if any.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskError.Builder} avoiding the need to
         * create one manually via {@link TaskError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskError.Builder#build()} is called immediately and its result
         * is passed to {@link #error(TaskError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link TaskError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(TaskError)
         */
        default Builder error(Consumer<TaskError.Builder> error) {
            return error(TaskError.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String app;

        private String tenantId;

        private String taskId;

        private TaskError error;

        private BuilderImpl() {
        }

        private BuilderImpl(UserAccessTaskItem model) {
            app(model.app);
            tenantId(model.tenantId);
            taskId(model.taskId);
            error(model.error);
        }

        public final String getApp() {
            return app;
        }

        public final void setApp(String app) {
            this.app = app;
        }

        @Override
        public final Builder app(String app) {
            this.app = app;
            return this;
        }

        public final String getTenantId() {
            return tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final TaskError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(TaskError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(TaskError error) {
            this.error = error;
            return this;
        }

        @Override
        public UserAccessTaskItem build() {
            return new UserAccessTaskItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
