/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.appflow.model.AppflowException;
import software.amazon.awssdk.services.appflow.model.ConflictException;
import software.amazon.awssdk.services.appflow.model.ConnectorAuthenticationException;
import software.amazon.awssdk.services.appflow.model.ConnectorServerException;
import software.amazon.awssdk.services.appflow.model.CreateConnectorProfileRequest;
import software.amazon.awssdk.services.appflow.model.CreateConnectorProfileResponse;
import software.amazon.awssdk.services.appflow.model.CreateFlowRequest;
import software.amazon.awssdk.services.appflow.model.CreateFlowResponse;
import software.amazon.awssdk.services.appflow.model.DeleteConnectorProfileRequest;
import software.amazon.awssdk.services.appflow.model.DeleteConnectorProfileResponse;
import software.amazon.awssdk.services.appflow.model.DeleteFlowRequest;
import software.amazon.awssdk.services.appflow.model.DeleteFlowResponse;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorEntityRequest;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorEntityResponse;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesRequest;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesResponse;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorsRequest;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorsResponse;
import software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsRequest;
import software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsResponse;
import software.amazon.awssdk.services.appflow.model.DescribeFlowRequest;
import software.amazon.awssdk.services.appflow.model.DescribeFlowResponse;
import software.amazon.awssdk.services.appflow.model.InternalServerException;
import software.amazon.awssdk.services.appflow.model.ListConnectorEntitiesRequest;
import software.amazon.awssdk.services.appflow.model.ListConnectorEntitiesResponse;
import software.amazon.awssdk.services.appflow.model.ListFlowsRequest;
import software.amazon.awssdk.services.appflow.model.ListFlowsResponse;
import software.amazon.awssdk.services.appflow.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.appflow.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.appflow.model.ResourceNotFoundException;
import software.amazon.awssdk.services.appflow.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.appflow.model.StartFlowRequest;
import software.amazon.awssdk.services.appflow.model.StartFlowResponse;
import software.amazon.awssdk.services.appflow.model.StopFlowRequest;
import software.amazon.awssdk.services.appflow.model.StopFlowResponse;
import software.amazon.awssdk.services.appflow.model.TagResourceRequest;
import software.amazon.awssdk.services.appflow.model.TagResourceResponse;
import software.amazon.awssdk.services.appflow.model.UntagResourceRequest;
import software.amazon.awssdk.services.appflow.model.UntagResourceResponse;
import software.amazon.awssdk.services.appflow.model.UpdateConnectorProfileRequest;
import software.amazon.awssdk.services.appflow.model.UpdateConnectorProfileResponse;
import software.amazon.awssdk.services.appflow.model.UpdateFlowRequest;
import software.amazon.awssdk.services.appflow.model.UpdateFlowResponse;
import software.amazon.awssdk.services.appflow.model.ValidationException;
import software.amazon.awssdk.services.appflow.paginators.DescribeConnectorProfilesIterable;
import software.amazon.awssdk.services.appflow.paginators.DescribeConnectorsIterable;
import software.amazon.awssdk.services.appflow.paginators.DescribeFlowExecutionRecordsIterable;
import software.amazon.awssdk.services.appflow.paginators.ListFlowsIterable;

/**
 * Service client for accessing Amazon Appflow. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Welcome to the Amazon AppFlow API reference. This guide is for developers who need detailed information about the
 * Amazon AppFlow API operations, data types, and errors.
 * </p>
 * <p>
 * Amazon AppFlow is a fully managed integration service that enables you to securely transfer data between software as
 * a service (SaaS) applications like Salesforce, Marketo, Slack, and ServiceNow, and AWS services like Amazon S3 and
 * Amazon Redshift.
 * </p>
 * <p>
 * Use the following links to get started on the Amazon AppFlow API:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/appflow/1.0/APIReference/API_Operations.html">Actions</a>: An alphabetical list
 * of all Amazon AppFlow API operations.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/appflow/1.0/APIReference/API_Types.html">Data types</a>: An alphabetical list of
 * all Amazon AppFlow data types.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/appflow/1.0/APIReference/CommonParameters.html">Common parameters</a>:
 * Parameters that all Query operations can use.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/appflow/1.0/APIReference/CommonErrors.html">Common errors</a>: Client and server
 * errors that all operations can return.
 * </p>
 * </li>
 * </ul>
 * <p>
 * If you're new to Amazon AppFlow, we recommend that you review the <a
 * href="https://docs.aws.amazon.com/appflow/latest/userguide/what-is-appflow.html">Amazon AppFlow User Guide</a>.
 * </p>
 * <p>
 * Amazon AppFlow API users can use vendor-specific mechanisms for OAuth, and include applicable OAuth attributes (such
 * as <code>auth-code</code> and <code>redirecturi</code>) with the connector-specific
 * <code>ConnectorProfileProperties</code> when creating a new connector profile using Amazon AppFlow API operations.
 * For example, Salesforce users can refer to the <a
 * href="https://help.salesforce.com/articleView?id=remoteaccess_authenticate.htm"> <i>Authorize Apps with OAuth</i>
 * </a> documentation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AppflowClient extends SdkClient {
    String SERVICE_NAME = "appflow";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "appflow";

    /**
     * Create a {@link AppflowClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AppflowClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AppflowClient}.
     */
    static AppflowClientBuilder builder() {
        return new DefaultAppflowClientBuilder();
    }

    /**
     * <p>
     * Creates a new connector profile associated with your AWS account. There is a soft quota of 100 connector profiles
     * per AWS account. If you need more connector profiles than this quota allows, you can submit a request to the
     * Amazon AppFlow team through the Amazon AppFlow support channel.
     * </p>
     *
     * @param createConnectorProfileRequest
     * @return Result of the CreateConnectorProfile operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a flow with the given name already exists
     *         within the account. Check for conflicting resource names and try again.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota (such as the number of flows) to be exceeded.
     * @throws ConnectorAuthenticationException
     *         An error occurred when authenticating with the connector endpoint.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.CreateConnectorProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/CreateConnectorProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConnectorProfileResponse createConnectorProfile(CreateConnectorProfileRequest createConnectorProfileRequest)
            throws ValidationException, ConflictException, ServiceQuotaExceededException, ConnectorAuthenticationException,
            InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new connector profile associated with your AWS account. There is a soft quota of 100 connector profiles
     * per AWS account. If you need more connector profiles than this quota allows, you can submit a request to the
     * Amazon AppFlow team through the Amazon AppFlow support channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectorProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateConnectorProfileRequest#builder()}
     * </p>
     *
     * @param createConnectorProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateConnectorProfileRequest.Builder} to create a
     *        request.
     * @return Result of the CreateConnectorProfile operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a flow with the given name already exists
     *         within the account. Check for conflicting resource names and try again.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota (such as the number of flows) to be exceeded.
     * @throws ConnectorAuthenticationException
     *         An error occurred when authenticating with the connector endpoint.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.CreateConnectorProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/CreateConnectorProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConnectorProfileResponse createConnectorProfile(
            Consumer<CreateConnectorProfileRequest.Builder> createConnectorProfileRequest) throws ValidationException,
            ConflictException, ServiceQuotaExceededException, ConnectorAuthenticationException, InternalServerException,
            AwsServiceException, SdkClientException, AppflowException {
        return createConnectorProfile(CreateConnectorProfileRequest.builder().applyMutation(createConnectorProfileRequest)
                .build());
    }

    /**
     * <p>
     * Enables your application to create a new flow using Amazon AppFlow. You must create a connector profile before
     * calling this API. Please note that the Request Syntax below shows syntax for multiple destinations, however, you
     * can only transfer data to one item in this list at a time. Amazon AppFlow does not currently support flows to
     * multiple destinations at once.
     * </p>
     *
     * @param createFlowRequest
     * @return Result of the CreateFlow operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota (such as the number of flows) to be exceeded.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a flow with the given name already exists
     *         within the account. Check for conflicting resource names and try again.
     * @throws ConnectorAuthenticationException
     *         An error occurred when authenticating with the connector endpoint.
     * @throws ConnectorServerException
     *         An error occurred when retrieving data from the connector endpoint.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.CreateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/CreateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFlowResponse createFlow(CreateFlowRequest createFlowRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, ConflictException,
            ConnectorAuthenticationException, ConnectorServerException, AwsServiceException, SdkClientException, AppflowException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables your application to create a new flow using Amazon AppFlow. You must create a connector profile before
     * calling this API. Please note that the Request Syntax below shows syntax for multiple destinations, however, you
     * can only transfer data to one item in this list at a time. Amazon AppFlow does not currently support flows to
     * multiple destinations at once.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFlowRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFlowRequest#builder()}
     * </p>
     *
     * @param createFlowRequest
     *        A {@link Consumer} that will call methods on {@link CreateFlowRequest.Builder} to create a request.
     * @return Result of the CreateFlow operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota (such as the number of flows) to be exceeded.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a flow with the given name already exists
     *         within the account. Check for conflicting resource names and try again.
     * @throws ConnectorAuthenticationException
     *         An error occurred when authenticating with the connector endpoint.
     * @throws ConnectorServerException
     *         An error occurred when retrieving data from the connector endpoint.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.CreateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/CreateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFlowResponse createFlow(Consumer<CreateFlowRequest.Builder> createFlowRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, ConflictException,
            ConnectorAuthenticationException, ConnectorServerException, AwsServiceException, SdkClientException, AppflowException {
        return createFlow(CreateFlowRequest.builder().applyMutation(createFlowRequest).build());
    }

    /**
     * <p>
     * Enables you to delete an existing connector profile.
     * </p>
     *
     * @param deleteConnectorProfileRequest
     * @return Result of the DeleteConnectorProfile operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a flow with the given name already exists
     *         within the account. Check for conflicting resource names and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.DeleteConnectorProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DeleteConnectorProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectorProfileResponse deleteConnectorProfile(DeleteConnectorProfileRequest deleteConnectorProfileRequest)
            throws ResourceNotFoundException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, AppflowException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to delete an existing connector profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectorProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteConnectorProfileRequest#builder()}
     * </p>
     *
     * @param deleteConnectorProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConnectorProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteConnectorProfile operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a flow with the given name already exists
     *         within the account. Check for conflicting resource names and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.DeleteConnectorProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DeleteConnectorProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectorProfileResponse deleteConnectorProfile(
            Consumer<DeleteConnectorProfileRequest.Builder> deleteConnectorProfileRequest) throws ResourceNotFoundException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        return deleteConnectorProfile(DeleteConnectorProfileRequest.builder().applyMutation(deleteConnectorProfileRequest)
                .build());
    }

    /**
     * <p>
     * Enables your application to delete an existing flow. Before deleting the flow, Amazon AppFlow validates the
     * request by checking the flow configuration and status. You can delete flows one at a time.
     * </p>
     *
     * @param deleteFlowRequest
     * @return Result of the DeleteFlow operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a flow with the given name already exists
     *         within the account. Check for conflicting resource names and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.DeleteFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DeleteFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFlowResponse deleteFlow(DeleteFlowRequest deleteFlowRequest) throws ResourceNotFoundException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables your application to delete an existing flow. Before deleting the flow, Amazon AppFlow validates the
     * request by checking the flow configuration and status. You can delete flows one at a time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFlowRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFlowRequest#builder()}
     * </p>
     *
     * @param deleteFlowRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFlowRequest.Builder} to create a request.
     * @return Result of the DeleteFlow operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a flow with the given name already exists
     *         within the account. Check for conflicting resource names and try again.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.DeleteFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DeleteFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFlowResponse deleteFlow(Consumer<DeleteFlowRequest.Builder> deleteFlowRequest)
            throws ResourceNotFoundException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, AppflowException {
        return deleteFlow(DeleteFlowRequest.builder().applyMutation(deleteFlowRequest).build());
    }

    /**
     * <p>
     * Provides details regarding the entity used with the connector, with a description of the data model for each
     * entity.
     * </p>
     *
     * @param describeConnectorEntityRequest
     * @return Result of the DescribeConnectorEntity operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws ConnectorAuthenticationException
     *         An error occurred when authenticating with the connector endpoint.
     * @throws ConnectorServerException
     *         An error occurred when retrieving data from the connector endpoint.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.DescribeConnectorEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectorEntity"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConnectorEntityResponse describeConnectorEntity(DescribeConnectorEntityRequest describeConnectorEntityRequest)
            throws ValidationException, ResourceNotFoundException, ConnectorAuthenticationException, ConnectorServerException,
            InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details regarding the entity used with the connector, with a description of the data model for each
     * entity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectorEntityRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeConnectorEntityRequest#builder()}
     * </p>
     *
     * @param describeConnectorEntityRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConnectorEntityRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeConnectorEntity operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws ConnectorAuthenticationException
     *         An error occurred when authenticating with the connector endpoint.
     * @throws ConnectorServerException
     *         An error occurred when retrieving data from the connector endpoint.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.DescribeConnectorEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectorEntity"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConnectorEntityResponse describeConnectorEntity(
            Consumer<DescribeConnectorEntityRequest.Builder> describeConnectorEntityRequest) throws ValidationException,
            ResourceNotFoundException, ConnectorAuthenticationException, ConnectorServerException, InternalServerException,
            AwsServiceException, SdkClientException, AppflowException {
        return describeConnectorEntity(DescribeConnectorEntityRequest.builder().applyMutation(describeConnectorEntityRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of <code>connector-profile</code> details matching the provided <code>connector-profile</code>
     * names and <code>connector-types</code>. Both input lists are optional, and you can use them to filter the result.
     * </p>
     * <p>
     * If no names or <code>connector-types</code> are provided, returns all connector profiles in a paginated form. If
     * there is no match, this operation returns an empty list.
     * </p>
     *
     * @param describeConnectorProfilesRequest
     * @return Result of the DescribeConnectorProfiles operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.DescribeConnectorProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectorProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConnectorProfilesResponse describeConnectorProfiles(
            DescribeConnectorProfilesRequest describeConnectorProfilesRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>connector-profile</code> details matching the provided <code>connector-profile</code>
     * names and <code>connector-types</code>. Both input lists are optional, and you can use them to filter the result.
     * </p>
     * <p>
     * If no names or <code>connector-types</code> are provided, returns all connector profiles in a paginated form. If
     * there is no match, this operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectorProfilesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeConnectorProfilesRequest#builder()}
     * </p>
     *
     * @param describeConnectorProfilesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConnectorProfilesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeConnectorProfiles operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.DescribeConnectorProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectorProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConnectorProfilesResponse describeConnectorProfiles(
            Consumer<DescribeConnectorProfilesRequest.Builder> describeConnectorProfilesRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        return describeConnectorProfiles(DescribeConnectorProfilesRequest.builder()
                .applyMutation(describeConnectorProfilesRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>connector-profile</code> details matching the provided <code>connector-profile</code>
     * names and <code>connector-types</code>. Both input lists are optional, and you can use them to filter the result.
     * </p>
     * <p>
     * If no names or <code>connector-types</code> are provided, returns all connector profiles in a paginated form. If
     * there is no match, this operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConnectorProfiles(software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.DescribeConnectorProfilesIterable responses = client.describeConnectorProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appflow.paginators.DescribeConnectorProfilesIterable responses = client
     *             .describeConnectorProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.DescribeConnectorProfilesIterable responses = client.describeConnectorProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConnectorProfiles(software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConnectorProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.DescribeConnectorProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectorProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConnectorProfilesIterable describeConnectorProfilesPaginator(
            DescribeConnectorProfilesRequest describeConnectorProfilesRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>connector-profile</code> details matching the provided <code>connector-profile</code>
     * names and <code>connector-types</code>. Both input lists are optional, and you can use them to filter the result.
     * </p>
     * <p>
     * If no names or <code>connector-types</code> are provided, returns all connector profiles in a paginated form. If
     * there is no match, this operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConnectorProfiles(software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.DescribeConnectorProfilesIterable responses = client.describeConnectorProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appflow.paginators.DescribeConnectorProfilesIterable responses = client
     *             .describeConnectorProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.DescribeConnectorProfilesIterable responses = client.describeConnectorProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConnectorProfiles(software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectorProfilesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeConnectorProfilesRequest#builder()}
     * </p>
     *
     * @param describeConnectorProfilesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConnectorProfilesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.DescribeConnectorProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectorProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConnectorProfilesIterable describeConnectorProfilesPaginator(
            Consumer<DescribeConnectorProfilesRequest.Builder> describeConnectorProfilesRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        return describeConnectorProfilesPaginator(DescribeConnectorProfilesRequest.builder()
                .applyMutation(describeConnectorProfilesRequest).build());
    }

    /**
     * <p>
     * Describes the connectors vended by Amazon AppFlow for specified connector types. If you don't specify a connector
     * type, this operation describes all connectors vended by Amazon AppFlow. If there are more connectors than can be
     * returned in one page, the response contains a <code>nextToken</code> object, which can be be passed in to the
     * next call to the <code>DescribeConnectors</code> API operation to retrieve the next page.
     * </p>
     *
     * @param describeConnectorsRequest
     * @return Result of the DescribeConnectors operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.DescribeConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectors" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeConnectorsResponse describeConnectors(DescribeConnectorsRequest describeConnectorsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the connectors vended by Amazon AppFlow for specified connector types. If you don't specify a connector
     * type, this operation describes all connectors vended by Amazon AppFlow. If there are more connectors than can be
     * returned in one page, the response contains a <code>nextToken</code> object, which can be be passed in to the
     * next call to the <code>DescribeConnectors</code> API operation to retrieve the next page.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectorsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConnectorsRequest#builder()}
     * </p>
     *
     * @param describeConnectorsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConnectorsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeConnectors operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.DescribeConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectors" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeConnectorsResponse describeConnectors(Consumer<DescribeConnectorsRequest.Builder> describeConnectorsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        return describeConnectors(DescribeConnectorsRequest.builder().applyMutation(describeConnectorsRequest).build());
    }

    /**
     * <p>
     * Describes the connectors vended by Amazon AppFlow for specified connector types. If you don't specify a connector
     * type, this operation describes all connectors vended by Amazon AppFlow. If there are more connectors than can be
     * returned in one page, the response contains a <code>nextToken</code> object, which can be be passed in to the
     * next call to the <code>DescribeConnectors</code> API operation to retrieve the next page.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConnectors(software.amazon.awssdk.services.appflow.model.DescribeConnectorsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.DescribeConnectorsIterable responses = client.describeConnectorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appflow.paginators.DescribeConnectorsIterable responses = client
     *             .describeConnectorsPaginator(request);
     *     for (software.amazon.awssdk.services.appflow.model.DescribeConnectorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.DescribeConnectorsIterable responses = client.describeConnectorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConnectors(software.amazon.awssdk.services.appflow.model.DescribeConnectorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConnectorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.DescribeConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectors" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeConnectorsIterable describeConnectorsPaginator(DescribeConnectorsRequest describeConnectorsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the connectors vended by Amazon AppFlow for specified connector types. If you don't specify a connector
     * type, this operation describes all connectors vended by Amazon AppFlow. If there are more connectors than can be
     * returned in one page, the response contains a <code>nextToken</code> object, which can be be passed in to the
     * next call to the <code>DescribeConnectors</code> API operation to retrieve the next page.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConnectors(software.amazon.awssdk.services.appflow.model.DescribeConnectorsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.DescribeConnectorsIterable responses = client.describeConnectorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appflow.paginators.DescribeConnectorsIterable responses = client
     *             .describeConnectorsPaginator(request);
     *     for (software.amazon.awssdk.services.appflow.model.DescribeConnectorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.DescribeConnectorsIterable responses = client.describeConnectorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConnectors(software.amazon.awssdk.services.appflow.model.DescribeConnectorsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectorsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConnectorsRequest#builder()}
     * </p>
     *
     * @param describeConnectorsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConnectorsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.DescribeConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectors" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeConnectorsIterable describeConnectorsPaginator(
            Consumer<DescribeConnectorsRequest.Builder> describeConnectorsRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        return describeConnectorsPaginator(DescribeConnectorsRequest.builder().applyMutation(describeConnectorsRequest).build());
    }

    /**
     * <p>
     * Provides a description of the specified flow.
     * </p>
     *
     * @param describeFlowRequest
     * @return Result of the DescribeFlow operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.DescribeFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeFlowResponse describeFlow(DescribeFlowRequest describeFlowRequest) throws ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a description of the specified flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFlowRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeFlowRequest#builder()}
     * </p>
     *
     * @param describeFlowRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFlowRequest.Builder} to create a request.
     * @return Result of the DescribeFlow operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.DescribeFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeFlowResponse describeFlow(Consumer<DescribeFlowRequest.Builder> describeFlowRequest)
            throws ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        return describeFlow(DescribeFlowRequest.builder().applyMutation(describeFlowRequest).build());
    }

    /**
     * <p>
     * Fetches the execution history of the flow.
     * </p>
     *
     * @param describeFlowExecutionRecordsRequest
     * @return Result of the DescribeFlowExecutionRecords operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.DescribeFlowExecutionRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeFlowExecutionRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFlowExecutionRecordsResponse describeFlowExecutionRecords(
            DescribeFlowExecutionRecordsRequest describeFlowExecutionRecordsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetches the execution history of the flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFlowExecutionRecordsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFlowExecutionRecordsRequest#builder()}
     * </p>
     *
     * @param describeFlowExecutionRecordsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFlowExecutionRecordsRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeFlowExecutionRecords operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.DescribeFlowExecutionRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeFlowExecutionRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFlowExecutionRecordsResponse describeFlowExecutionRecords(
            Consumer<DescribeFlowExecutionRecordsRequest.Builder> describeFlowExecutionRecordsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, AppflowException {
        return describeFlowExecutionRecords(DescribeFlowExecutionRecordsRequest.builder()
                .applyMutation(describeFlowExecutionRecordsRequest).build());
    }

    /**
     * <p>
     * Fetches the execution history of the flow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFlowExecutionRecords(software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.DescribeFlowExecutionRecordsIterable responses = client.describeFlowExecutionRecordsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appflow.paginators.DescribeFlowExecutionRecordsIterable responses = client
     *             .describeFlowExecutionRecordsPaginator(request);
     *     for (software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.DescribeFlowExecutionRecordsIterable responses = client.describeFlowExecutionRecordsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFlowExecutionRecords(software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFlowExecutionRecordsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.DescribeFlowExecutionRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeFlowExecutionRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFlowExecutionRecordsIterable describeFlowExecutionRecordsPaginator(
            DescribeFlowExecutionRecordsRequest describeFlowExecutionRecordsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetches the execution history of the flow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFlowExecutionRecords(software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.DescribeFlowExecutionRecordsIterable responses = client.describeFlowExecutionRecordsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appflow.paginators.DescribeFlowExecutionRecordsIterable responses = client
     *             .describeFlowExecutionRecordsPaginator(request);
     *     for (software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.DescribeFlowExecutionRecordsIterable responses = client.describeFlowExecutionRecordsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFlowExecutionRecords(software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFlowExecutionRecordsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFlowExecutionRecordsRequest#builder()}
     * </p>
     *
     * @param describeFlowExecutionRecordsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFlowExecutionRecordsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.DescribeFlowExecutionRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeFlowExecutionRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFlowExecutionRecordsIterable describeFlowExecutionRecordsPaginator(
            Consumer<DescribeFlowExecutionRecordsRequest.Builder> describeFlowExecutionRecordsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, AppflowException {
        return describeFlowExecutionRecordsPaginator(DescribeFlowExecutionRecordsRequest.builder()
                .applyMutation(describeFlowExecutionRecordsRequest).build());
    }

    /**
     * <p>
     * Returns the list of available connector entities supported by Amazon AppFlow. For example, you can query
     * Salesforce for <i>Account</i> and <i>Opportunity</i> entities, or query ServiceNow for the <i>Incident</i>
     * entity.
     * </p>
     *
     * @param listConnectorEntitiesRequest
     * @return Result of the ListConnectorEntities operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws ConnectorAuthenticationException
     *         An error occurred when authenticating with the connector endpoint.
     * @throws ConnectorServerException
     *         An error occurred when retrieving data from the connector endpoint.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.ListConnectorEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListConnectorEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConnectorEntitiesResponse listConnectorEntities(ListConnectorEntitiesRequest listConnectorEntitiesRequest)
            throws ValidationException, ResourceNotFoundException, ConnectorAuthenticationException, ConnectorServerException,
            InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of available connector entities supported by Amazon AppFlow. For example, you can query
     * Salesforce for <i>Account</i> and <i>Opportunity</i> entities, or query ServiceNow for the <i>Incident</i>
     * entity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorEntitiesRequest.Builder} avoiding the
     * need to create one manually via {@link ListConnectorEntitiesRequest#builder()}
     * </p>
     *
     * @param listConnectorEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link ListConnectorEntitiesRequest.Builder} to create a
     *        request.
     * @return Result of the ListConnectorEntities operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws ConnectorAuthenticationException
     *         An error occurred when authenticating with the connector endpoint.
     * @throws ConnectorServerException
     *         An error occurred when retrieving data from the connector endpoint.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.ListConnectorEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListConnectorEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConnectorEntitiesResponse listConnectorEntities(
            Consumer<ListConnectorEntitiesRequest.Builder> listConnectorEntitiesRequest) throws ValidationException,
            ResourceNotFoundException, ConnectorAuthenticationException, ConnectorServerException, InternalServerException,
            AwsServiceException, SdkClientException, AppflowException {
        return listConnectorEntities(ListConnectorEntitiesRequest.builder().applyMutation(listConnectorEntitiesRequest).build());
    }

    /**
     * <p>
     * Lists all of the flows associated with your account.
     * </p>
     *
     * @param listFlowsRequest
     * @return Result of the ListFlows operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.ListFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFlowsResponse listFlows(ListFlowsRequest listFlowsRequest) throws ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, AppflowException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the flows associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFlowsRequest#builder()}
     * </p>
     *
     * @param listFlowsRequest
     *        A {@link Consumer} that will call methods on {@link ListFlowsRequest.Builder} to create a request.
     * @return Result of the ListFlows operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.ListFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFlowsResponse listFlows(Consumer<ListFlowsRequest.Builder> listFlowsRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        return listFlows(ListFlowsRequest.builder().applyMutation(listFlowsRequest).build());
    }

    /**
     * <p>
     * Lists all of the flows associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFlows(software.amazon.awssdk.services.appflow.model.ListFlowsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.ListFlowsIterable responses = client.listFlowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appflow.paginators.ListFlowsIterable responses = client.listFlowsPaginator(request);
     *     for (software.amazon.awssdk.services.appflow.model.ListFlowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.ListFlowsIterable responses = client.listFlowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlows(software.amazon.awssdk.services.appflow.model.ListFlowsRequest)} operation.</b>
     * </p>
     *
     * @param listFlowsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.ListFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFlowsIterable listFlowsPaginator(ListFlowsRequest listFlowsRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the flows associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFlows(software.amazon.awssdk.services.appflow.model.ListFlowsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.ListFlowsIterable responses = client.listFlowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appflow.paginators.ListFlowsIterable responses = client.listFlowsPaginator(request);
     *     for (software.amazon.awssdk.services.appflow.model.ListFlowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.ListFlowsIterable responses = client.listFlowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlows(software.amazon.awssdk.services.appflow.model.ListFlowsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFlowsRequest#builder()}
     * </p>
     *
     * @param listFlowsRequest
     *        A {@link Consumer} that will call methods on {@link ListFlowsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.ListFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFlowsIterable listFlowsPaginator(Consumer<ListFlowsRequest.Builder> listFlowsRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        return listFlowsPaginator(ListFlowsRequest.builder().applyMutation(listFlowsRequest).build());
    }

    /**
     * <p>
     * Retrieves the tags that are associated with a specified flow.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AppflowException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the tags that are associated with a specified flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppflowException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Activates an existing flow. For on-demand flows, this operation runs the flow immediately. For schedule and
     * event-triggered flows, this operation activates the flow.
     * </p>
     *
     * @param startFlowRequest
     * @return Result of the StartFlow operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota (such as the number of flows) to be exceeded.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a flow with the given name already exists
     *         within the account. Check for conflicting resource names and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.StartFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/StartFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default StartFlowResponse startFlow(StartFlowRequest startFlowRequest) throws ResourceNotFoundException,
            InternalServerException, ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException,
            AppflowException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates an existing flow. For on-demand flows, this operation runs the flow immediately. For schedule and
     * event-triggered flows, this operation activates the flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFlowRequest.Builder} avoiding the need to
     * create one manually via {@link StartFlowRequest#builder()}
     * </p>
     *
     * @param startFlowRequest
     *        A {@link Consumer} that will call methods on {@link StartFlowRequest.Builder} to create a request.
     * @return Result of the StartFlow operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota (such as the number of flows) to be exceeded.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a flow with the given name already exists
     *         within the account. Check for conflicting resource names and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.StartFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/StartFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default StartFlowResponse startFlow(Consumer<StartFlowRequest.Builder> startFlowRequest) throws ResourceNotFoundException,
            InternalServerException, ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException,
            AppflowException {
        return startFlow(StartFlowRequest.builder().applyMutation(startFlowRequest).build());
    }

    /**
     * <p>
     * Deactivates the existing flow. For on-demand flows, this operation returns an
     * <code>unsupportedOperationException</code> error message. For schedule and event-triggered flows, this operation
     * deactivates the flow.
     * </p>
     *
     * @param stopFlowRequest
     * @return Result of the StopFlow operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a flow with the given name already exists
     *         within the account. Check for conflicting resource names and try again.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws UnsupportedOperationException
     *         The requested operation is not supported for the current flow.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.StopFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/StopFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default StopFlowResponse stopFlow(StopFlowRequest stopFlowRequest) throws ConflictException, ResourceNotFoundException,
            software.amazon.awssdk.services.appflow.model.UnsupportedOperationException, InternalServerException,
            AwsServiceException, SdkClientException, AppflowException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deactivates the existing flow. For on-demand flows, this operation returns an
     * <code>unsupportedOperationException</code> error message. For schedule and event-triggered flows, this operation
     * deactivates the flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopFlowRequest.Builder} avoiding the need to
     * create one manually via {@link StopFlowRequest#builder()}
     * </p>
     *
     * @param stopFlowRequest
     *        A {@link Consumer} that will call methods on {@link StopFlowRequest.Builder} to create a request.
     * @return Result of the StopFlow operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a flow with the given name already exists
     *         within the account. Check for conflicting resource names and try again.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws UnsupportedOperationException
     *         The requested operation is not supported for the current flow.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.StopFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/StopFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default StopFlowResponse stopFlow(Consumer<StopFlowRequest.Builder> stopFlowRequest) throws ConflictException,
            ResourceNotFoundException, software.amazon.awssdk.services.appflow.model.UnsupportedOperationException,
            InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        return stopFlow(StopFlowRequest.builder().applyMutation(stopFlowRequest).build());
    }

    /**
     * <p>
     * Applies a tag to the specified flow.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppflowException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a tag to the specified flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AppflowException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from the specified flow.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppflowException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from the specified flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AppflowException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a given connector profile associated with your account.
     * </p>
     *
     * @param updateConnectorProfileRequest
     * @return Result of the UpdateConnectorProfile operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a flow with the given name already exists
     *         within the account. Check for conflicting resource names and try again.
     * @throws ConnectorAuthenticationException
     *         An error occurred when authenticating with the connector endpoint.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.UpdateConnectorProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/UpdateConnectorProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConnectorProfileResponse updateConnectorProfile(UpdateConnectorProfileRequest updateConnectorProfileRequest)
            throws ValidationException, ResourceNotFoundException, ConflictException, ConnectorAuthenticationException,
            InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a given connector profile associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectorProfileRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateConnectorProfileRequest#builder()}
     * </p>
     *
     * @param updateConnectorProfileRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConnectorProfileRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateConnectorProfile operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a flow with the given name already exists
     *         within the account. Check for conflicting resource names and try again.
     * @throws ConnectorAuthenticationException
     *         An error occurred when authenticating with the connector endpoint.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.UpdateConnectorProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/UpdateConnectorProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConnectorProfileResponse updateConnectorProfile(
            Consumer<UpdateConnectorProfileRequest.Builder> updateConnectorProfileRequest) throws ValidationException,
            ResourceNotFoundException, ConflictException, ConnectorAuthenticationException, InternalServerException,
            AwsServiceException, SdkClientException, AppflowException {
        return updateConnectorProfile(UpdateConnectorProfileRequest.builder().applyMutation(updateConnectorProfileRequest)
                .build());
    }

    /**
     * <p>
     * Updates an existing flow.
     * </p>
     *
     * @param updateFlowRequest
     * @return Result of the UpdateFlow operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota (such as the number of flows) to be exceeded.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a flow with the given name already exists
     *         within the account. Check for conflicting resource names and try again.
     * @throws ConnectorAuthenticationException
     *         An error occurred when authenticating with the connector endpoint.
     * @throws ConnectorServerException
     *         An error occurred when retrieving data from the connector endpoint.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.UpdateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/UpdateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFlowResponse updateFlow(UpdateFlowRequest updateFlowRequest) throws ValidationException,
            ResourceNotFoundException, ServiceQuotaExceededException, ConflictException, ConnectorAuthenticationException,
            ConnectorServerException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFlowRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFlowRequest#builder()}
     * </p>
     *
     * @param updateFlowRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFlowRequest.Builder} to create a request.
     * @return Result of the UpdateFlow operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The resource specified in the request (such as the source or destination connector profile) is not found.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota (such as the number of flows) to be exceeded.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a flow with the given name already exists
     *         within the account. Check for conflicting resource names and try again.
     * @throws ConnectorAuthenticationException
     *         An error occurred when authenticating with the connector endpoint.
     * @throws ConnectorServerException
     *         An error occurred when retrieving data from the connector endpoint.
     * @throws InternalServerException
     *         An internal service error occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppflowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppflowClient.UpdateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/UpdateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFlowResponse updateFlow(Consumer<UpdateFlowRequest.Builder> updateFlowRequest) throws ValidationException,
            ResourceNotFoundException, ServiceQuotaExceededException, ConflictException, ConnectorAuthenticationException,
            ConnectorServerException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        return updateFlow(UpdateFlowRequest.builder().applyMutation(updateFlowRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
