/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties that are applied when Amazon Connect Customer Profiles is used as a destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomerProfilesDestinationProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomerProfilesDestinationProperties.Builder, CustomerProfilesDestinationProperties> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainName").getter(getter(CustomerProfilesDestinationProperties::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<String> OBJECT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("objectTypeName").getter(getter(CustomerProfilesDestinationProperties::objectTypeName))
            .setter(setter(Builder::objectTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectTypeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            OBJECT_TYPE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String domainName;

    private final String objectTypeName;

    private CustomerProfilesDestinationProperties(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.objectTypeName = builder.objectTypeName;
    }

    /**
     * <p>
     * The unique name of the Amazon Connect Customer Profiles domain.
     * </p>
     * 
     * @return The unique name of the Amazon Connect Customer Profiles domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The object specified in the Amazon Connect Customer Profiles flow destination.
     * </p>
     * 
     * @return The object specified in the Amazon Connect Customer Profiles flow destination.
     */
    public final String objectTypeName() {
        return objectTypeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(objectTypeName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerProfilesDestinationProperties)) {
            return false;
        }
        CustomerProfilesDestinationProperties other = (CustomerProfilesDestinationProperties) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(objectTypeName(), other.objectTypeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomerProfilesDestinationProperties").add("DomainName", domainName())
                .add("ObjectTypeName", objectTypeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "objectTypeName":
            return Optional.ofNullable(clazz.cast(objectTypeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomerProfilesDestinationProperties, T> g) {
        return obj -> g.apply((CustomerProfilesDestinationProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomerProfilesDestinationProperties> {
        /**
         * <p>
         * The unique name of the Amazon Connect Customer Profiles domain.
         * </p>
         * 
         * @param domainName
         *        The unique name of the Amazon Connect Customer Profiles domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The object specified in the Amazon Connect Customer Profiles flow destination.
         * </p>
         * 
         * @param objectTypeName
         *        The object specified in the Amazon Connect Customer Profiles flow destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectTypeName(String objectTypeName);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private String objectTypeName;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerProfilesDestinationProperties model) {
            domainName(model.domainName);
            objectTypeName(model.objectTypeName);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getObjectTypeName() {
            return objectTypeName;
        }

        @Override
        public final Builder objectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        public final void setObjectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
        }

        @Override
        public CustomerProfilesDestinationProperties build() {
            return new CustomerProfilesDestinationProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
