/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConnectorProfilesResponse extends AppflowResponse implements
        ToCopyableBuilder<DescribeConnectorProfilesResponse.Builder, DescribeConnectorProfilesResponse> {
    private static final SdkField<List<ConnectorProfile>> CONNECTOR_PROFILE_DETAILS_FIELD = SdkField
            .<List<ConnectorProfile>> builder(MarshallingType.LIST)
            .memberName("connectorProfileDetails")
            .getter(getter(DescribeConnectorProfilesResponse::connectorProfileDetails))
            .setter(setter(Builder::connectorProfileDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConnectorProfile> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConnectorProfile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeConnectorProfilesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONNECTOR_PROFILE_DETAILS_FIELD, NEXT_TOKEN_FIELD));

    private final List<ConnectorProfile> connectorProfileDetails;

    private final String nextToken;

    private DescribeConnectorProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.connectorProfileDetails = builder.connectorProfileDetails;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ConnectorProfileDetails property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasConnectorProfileDetails() {
        return connectorProfileDetails != null && !(connectorProfileDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns information about the connector profiles associated with the flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConnectorProfileDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns information about the connector profiles associated with the flow.
     */
    public final List<ConnectorProfile> connectorProfileDetails() {
        return connectorProfileDetails;
    }

    /**
     * <p>
     * The pagination token for the next page of data. If <code>nextToken=null</code>, this means that all records have
     * been fetched.
     * </p>
     * 
     * @return The pagination token for the next page of data. If <code>nextToken=null</code>, this means that all
     *         records have been fetched.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectorProfileDetails() ? connectorProfileDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectorProfilesResponse)) {
            return false;
        }
        DescribeConnectorProfilesResponse other = (DescribeConnectorProfilesResponse) obj;
        return hasConnectorProfileDetails() == other.hasConnectorProfileDetails()
                && Objects.equals(connectorProfileDetails(), other.connectorProfileDetails())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConnectorProfilesResponse")
                .add("ConnectorProfileDetails", hasConnectorProfileDetails() ? connectorProfileDetails() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorProfileDetails":
            return Optional.ofNullable(clazz.cast(connectorProfileDetails()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectorProfilesResponse, T> g) {
        return obj -> g.apply((DescribeConnectorProfilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppflowResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConnectorProfilesResponse> {
        /**
         * <p>
         * Returns information about the connector profiles associated with the flow.
         * </p>
         * 
         * @param connectorProfileDetails
         *        Returns information about the connector profiles associated with the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProfileDetails(Collection<ConnectorProfile> connectorProfileDetails);

        /**
         * <p>
         * Returns information about the connector profiles associated with the flow.
         * </p>
         * 
         * @param connectorProfileDetails
         *        Returns information about the connector profiles associated with the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProfileDetails(ConnectorProfile... connectorProfileDetails);

        /**
         * <p>
         * Returns information about the connector profiles associated with the flow.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConnectorProfile>.Builder} avoiding the
         * need to create one manually via {@link List<ConnectorProfile>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConnectorProfile>.Builder#build()} is called immediately and
         * its result is passed to {@link #connectorProfileDetails(List<ConnectorProfile>)}.
         * 
         * @param connectorProfileDetails
         *        a consumer that will call methods on {@link List<ConnectorProfile>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectorProfileDetails(List<ConnectorProfile>)
         */
        Builder connectorProfileDetails(Consumer<ConnectorProfile.Builder>... connectorProfileDetails);

        /**
         * <p>
         * The pagination token for the next page of data. If <code>nextToken=null</code>, this means that all records
         * have been fetched.
         * </p>
         * 
         * @param nextToken
         *        The pagination token for the next page of data. If <code>nextToken=null</code>, this means that all
         *        records have been fetched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppflowResponse.BuilderImpl implements Builder {
        private List<ConnectorProfile> connectorProfileDetails = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectorProfilesResponse model) {
            super(model);
            connectorProfileDetails(model.connectorProfileDetails);
            nextToken(model.nextToken);
        }

        public final List<ConnectorProfile.Builder> getConnectorProfileDetails() {
            List<ConnectorProfile.Builder> result = ConnectorProfileDetailListCopier.copyToBuilder(this.connectorProfileDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder connectorProfileDetails(Collection<ConnectorProfile> connectorProfileDetails) {
            this.connectorProfileDetails = ConnectorProfileDetailListCopier.copy(connectorProfileDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorProfileDetails(ConnectorProfile... connectorProfileDetails) {
            connectorProfileDetails(Arrays.asList(connectorProfileDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorProfileDetails(Consumer<ConnectorProfile.Builder>... connectorProfileDetails) {
            connectorProfileDetails(Stream.of(connectorProfileDetails)
                    .map(c -> ConnectorProfile.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConnectorProfileDetails(Collection<ConnectorProfile.BuilderImpl> connectorProfileDetails) {
            this.connectorProfileDetails = ConnectorProfileDetailListCopier.copyFromBuilder(connectorProfileDetails);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeConnectorProfilesResponse build() {
            return new DescribeConnectorProfilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
