/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConnectorsRequest extends AppflowRequest implements
        ToCopyableBuilder<DescribeConnectorsRequest.Builder, DescribeConnectorsRequest> {
    private static final SdkField<List<String>> CONNECTOR_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("connectorTypes")
            .getter(getter(DescribeConnectorsRequest::connectorTypesAsStrings))
            .setter(setter(Builder::connectorTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeConnectorsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_TYPES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> connectorTypes;

    private final String nextToken;

    private DescribeConnectorsRequest(BuilderImpl builder) {
        super(builder);
        this.connectorTypes = builder.connectorTypes;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The type of connector, such as Salesforce, Amplitude, and so on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConnectorTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The type of connector, such as Salesforce, Amplitude, and so on.
     */
    public final List<ConnectorType> connectorTypes() {
        return ConnectorTypeListCopier.copyStringToEnum(connectorTypes);
    }

    /**
     * Returns true if the ConnectorTypes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasConnectorTypes() {
        return connectorTypes != null && !(connectorTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of connector, such as Salesforce, Amplitude, and so on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConnectorTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The type of connector, such as Salesforce, Amplitude, and so on.
     */
    public final List<String> connectorTypesAsStrings() {
        return connectorTypes;
    }

    /**
     * <p>
     * The pagination token for the next page of data.
     * </p>
     * 
     * @return The pagination token for the next page of data.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectorTypes() ? connectorTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectorsRequest)) {
            return false;
        }
        DescribeConnectorsRequest other = (DescribeConnectorsRequest) obj;
        return hasConnectorTypes() == other.hasConnectorTypes()
                && Objects.equals(connectorTypesAsStrings(), other.connectorTypesAsStrings())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConnectorsRequest")
                .add("ConnectorTypes", hasConnectorTypes() ? connectorTypesAsStrings() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorTypes":
            return Optional.ofNullable(clazz.cast(connectorTypesAsStrings()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectorsRequest, T> g) {
        return obj -> g.apply((DescribeConnectorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppflowRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeConnectorsRequest> {
        /**
         * <p>
         * The type of connector, such as Salesforce, Amplitude, and so on.
         * </p>
         * 
         * @param connectorTypes
         *        The type of connector, such as Salesforce, Amplitude, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorTypesWithStrings(Collection<String> connectorTypes);

        /**
         * <p>
         * The type of connector, such as Salesforce, Amplitude, and so on.
         * </p>
         * 
         * @param connectorTypes
         *        The type of connector, such as Salesforce, Amplitude, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorTypesWithStrings(String... connectorTypes);

        /**
         * <p>
         * The type of connector, such as Salesforce, Amplitude, and so on.
         * </p>
         * 
         * @param connectorTypes
         *        The type of connector, such as Salesforce, Amplitude, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorTypes(Collection<ConnectorType> connectorTypes);

        /**
         * <p>
         * The type of connector, such as Salesforce, Amplitude, and so on.
         * </p>
         * 
         * @param connectorTypes
         *        The type of connector, such as Salesforce, Amplitude, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorTypes(ConnectorType... connectorTypes);

        /**
         * <p>
         * The pagination token for the next page of data.
         * </p>
         * 
         * @param nextToken
         *        The pagination token for the next page of data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppflowRequest.BuilderImpl implements Builder {
        private List<String> connectorTypes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectorsRequest model) {
            super(model);
            connectorTypesWithStrings(model.connectorTypes);
            nextToken(model.nextToken);
        }

        public final Collection<String> getConnectorTypes() {
            if (connectorTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return connectorTypes;
        }

        @Override
        public final Builder connectorTypesWithStrings(Collection<String> connectorTypes) {
            this.connectorTypes = ConnectorTypeListCopier.copy(connectorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorTypesWithStrings(String... connectorTypes) {
            connectorTypesWithStrings(Arrays.asList(connectorTypes));
            return this;
        }

        @Override
        public final Builder connectorTypes(Collection<ConnectorType> connectorTypes) {
            this.connectorTypes = ConnectorTypeListCopier.copyEnumToString(connectorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorTypes(ConnectorType... connectorTypes) {
            connectorTypes(Arrays.asList(connectorTypes));
            return this;
        }

        public final void setConnectorTypes(Collection<String> connectorTypes) {
            this.connectorTypes = ConnectorTypeListCopier.copy(connectorTypes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConnectorsRequest build() {
            return new DescribeConnectorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
