/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConnectorsResponse extends AppflowResponse implements
        ToCopyableBuilder<DescribeConnectorsResponse.Builder, DescribeConnectorsResponse> {
    private static final SdkField<Map<String, ConnectorConfiguration>> CONNECTOR_CONFIGURATIONS_FIELD = SdkField
            .<Map<String, ConnectorConfiguration>> builder(MarshallingType.MAP)
            .memberName("connectorConfigurations")
            .getter(getter(DescribeConnectorsResponse::connectorConfigurationsAsStrings))
            .setter(setter(Builder::connectorConfigurationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorConfigurations").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ConnectorConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConnectorConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeConnectorsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONNECTOR_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));

    private final Map<String, ConnectorConfiguration> connectorConfigurations;

    private final String nextToken;

    private DescribeConnectorsResponse(BuilderImpl builder) {
        super(builder);
        this.connectorConfigurations = builder.connectorConfigurations;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The configuration that is applied to the connectors used in the flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConnectorConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The configuration that is applied to the connectors used in the flow.
     */
    public final Map<ConnectorType, ConnectorConfiguration> connectorConfigurations() {
        return ConnectorConfigurationsMapCopier.copyStringToEnum(connectorConfigurations);
    }

    /**
     * Returns true if the ConnectorConfigurations property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasConnectorConfigurations() {
        return connectorConfigurations != null && !(connectorConfigurations instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The configuration that is applied to the connectors used in the flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConnectorConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The configuration that is applied to the connectors used in the flow.
     */
    public final Map<String, ConnectorConfiguration> connectorConfigurationsAsStrings() {
        return connectorConfigurations;
    }

    /**
     * <p>
     * The pagination token for the next page of data.
     * </p>
     * 
     * @return The pagination token for the next page of data.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectorConfigurations() ? connectorConfigurationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectorsResponse)) {
            return false;
        }
        DescribeConnectorsResponse other = (DescribeConnectorsResponse) obj;
        return hasConnectorConfigurations() == other.hasConnectorConfigurations()
                && Objects.equals(connectorConfigurationsAsStrings(), other.connectorConfigurationsAsStrings())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConnectorsResponse")
                .add("ConnectorConfigurations", hasConnectorConfigurations() ? connectorConfigurationsAsStrings() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorConfigurations":
            return Optional.ofNullable(clazz.cast(connectorConfigurationsAsStrings()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectorsResponse, T> g) {
        return obj -> g.apply((DescribeConnectorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppflowResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeConnectorsResponse> {
        /**
         * <p>
         * The configuration that is applied to the connectors used in the flow.
         * </p>
         * 
         * @param connectorConfigurations
         *        The configuration that is applied to the connectors used in the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorConfigurationsWithStrings(Map<String, ConnectorConfiguration> connectorConfigurations);

        /**
         * <p>
         * The configuration that is applied to the connectors used in the flow.
         * </p>
         * 
         * @param connectorConfigurations
         *        The configuration that is applied to the connectors used in the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorConfigurations(Map<ConnectorType, ConnectorConfiguration> connectorConfigurations);

        /**
         * <p>
         * The pagination token for the next page of data.
         * </p>
         * 
         * @param nextToken
         *        The pagination token for the next page of data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppflowResponse.BuilderImpl implements Builder {
        private Map<String, ConnectorConfiguration> connectorConfigurations = DefaultSdkAutoConstructMap.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectorsResponse model) {
            super(model);
            connectorConfigurationsWithStrings(model.connectorConfigurations);
            nextToken(model.nextToken);
        }

        public final Map<String, ConnectorConfiguration.Builder> getConnectorConfigurations() {
            Map<String, ConnectorConfiguration.Builder> result = ConnectorConfigurationsMapCopier
                    .copyToBuilder(this.connectorConfigurations);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder connectorConfigurationsWithStrings(Map<String, ConnectorConfiguration> connectorConfigurations) {
            this.connectorConfigurations = ConnectorConfigurationsMapCopier.copy(connectorConfigurations);
            return this;
        }

        @Override
        public final Builder connectorConfigurations(Map<ConnectorType, ConnectorConfiguration> connectorConfigurations) {
            this.connectorConfigurations = ConnectorConfigurationsMapCopier.copyEnumToString(connectorConfigurations);
            return this;
        }

        public final void setConnectorConfigurations(Map<String, ConnectorConfiguration.BuilderImpl> connectorConfigurations) {
            this.connectorConfigurations = ConnectorConfigurationsMapCopier.copyFromBuilder(connectorConfigurations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeConnectorsResponse build() {
            return new DescribeConnectorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
