/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties that are applied when Amazon Honeycode is used as a destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HoneycodeDestinationProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<HoneycodeDestinationProperties.Builder, HoneycodeDestinationProperties> {
    private static final SdkField<String> OBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("object")
            .getter(getter(HoneycodeDestinationProperties::object)).setter(setter(Builder::object))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("object").build()).build();

    private static final SdkField<ErrorHandlingConfig> ERROR_HANDLING_CONFIG_FIELD = SdkField
            .<ErrorHandlingConfig> builder(MarshallingType.SDK_POJO).memberName("errorHandlingConfig")
            .getter(getter(HoneycodeDestinationProperties::errorHandlingConfig)).setter(setter(Builder::errorHandlingConfig))
            .constructor(ErrorHandlingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorHandlingConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_FIELD,
            ERROR_HANDLING_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String object;

    private final ErrorHandlingConfig errorHandlingConfig;

    private HoneycodeDestinationProperties(BuilderImpl builder) {
        this.object = builder.object;
        this.errorHandlingConfig = builder.errorHandlingConfig;
    }

    /**
     * <p>
     * The object specified in the Amazon Honeycode flow destination.
     * </p>
     * 
     * @return The object specified in the Amazon Honeycode flow destination.
     */
    public final String object() {
        return object;
    }

    /**
     * Returns the value of the ErrorHandlingConfig property for this object.
     * 
     * @return The value of the ErrorHandlingConfig property for this object.
     */
    public final ErrorHandlingConfig errorHandlingConfig() {
        return errorHandlingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(object());
        hashCode = 31 * hashCode + Objects.hashCode(errorHandlingConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HoneycodeDestinationProperties)) {
            return false;
        }
        HoneycodeDestinationProperties other = (HoneycodeDestinationProperties) obj;
        return Objects.equals(object(), other.object()) && Objects.equals(errorHandlingConfig(), other.errorHandlingConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HoneycodeDestinationProperties").add("Object", object())
                .add("ErrorHandlingConfig", errorHandlingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "object":
            return Optional.ofNullable(clazz.cast(object()));
        case "errorHandlingConfig":
            return Optional.ofNullable(clazz.cast(errorHandlingConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HoneycodeDestinationProperties, T> g) {
        return obj -> g.apply((HoneycodeDestinationProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HoneycodeDestinationProperties> {
        /**
         * <p>
         * The object specified in the Amazon Honeycode flow destination.
         * </p>
         * 
         * @param object
         *        The object specified in the Amazon Honeycode flow destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder object(String object);

        /**
         * Sets the value of the ErrorHandlingConfig property for this object.
         *
         * @param errorHandlingConfig
         *        The new value for the ErrorHandlingConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorHandlingConfig(ErrorHandlingConfig errorHandlingConfig);

        /**
         * Sets the value of the ErrorHandlingConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link ErrorHandlingConfig.Builder} avoiding the need
         * to create one manually via {@link ErrorHandlingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ErrorHandlingConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #errorHandlingConfig(ErrorHandlingConfig)}.
         * 
         * @param errorHandlingConfig
         *        a consumer that will call methods on {@link ErrorHandlingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorHandlingConfig(ErrorHandlingConfig)
         */
        default Builder errorHandlingConfig(Consumer<ErrorHandlingConfig.Builder> errorHandlingConfig) {
            return errorHandlingConfig(ErrorHandlingConfig.builder().applyMutation(errorHandlingConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String object;

        private ErrorHandlingConfig errorHandlingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(HoneycodeDestinationProperties model) {
            object(model.object);
            errorHandlingConfig(model.errorHandlingConfig);
        }

        public final String getObject() {
            return object;
        }

        @Override
        public final Builder object(String object) {
            this.object = object;
            return this;
        }

        public final void setObject(String object) {
            this.object = object;
        }

        public final ErrorHandlingConfig.Builder getErrorHandlingConfig() {
            return errorHandlingConfig != null ? errorHandlingConfig.toBuilder() : null;
        }

        @Override
        public final Builder errorHandlingConfig(ErrorHandlingConfig errorHandlingConfig) {
            this.errorHandlingConfig = errorHandlingConfig;
            return this;
        }

        public final void setErrorHandlingConfig(ErrorHandlingConfig.BuilderImpl errorHandlingConfig) {
            this.errorHandlingConfig = errorHandlingConfig != null ? errorHandlingConfig.build() : null;
        }

        @Override
        public HoneycodeDestinationProperties build() {
            return new HoneycodeDestinationProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
