/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connector-specific profile credentials required when using Trend Micro.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrendmicroConnectorProfileCredentials implements SdkPojo, Serializable,
        ToCopyableBuilder<TrendmicroConnectorProfileCredentials.Builder, TrendmicroConnectorProfileCredentials> {
    private static final SdkField<String> API_SECRET_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiSecretKey").getter(getter(TrendmicroConnectorProfileCredentials::apiSecretKey))
            .setter(setter(Builder::apiSecretKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiSecretKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_SECRET_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String apiSecretKey;

    private TrendmicroConnectorProfileCredentials(BuilderImpl builder) {
        this.apiSecretKey = builder.apiSecretKey;
    }

    /**
     * <p>
     * The Secret Access Key portion of the credentials.
     * </p>
     * 
     * @return The Secret Access Key portion of the credentials.
     */
    public final String apiSecretKey() {
        return apiSecretKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiSecretKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrendmicroConnectorProfileCredentials)) {
            return false;
        }
        TrendmicroConnectorProfileCredentials other = (TrendmicroConnectorProfileCredentials) obj;
        return Objects.equals(apiSecretKey(), other.apiSecretKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrendmicroConnectorProfileCredentials")
                .add("ApiSecretKey", apiSecretKey() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiSecretKey":
            return Optional.ofNullable(clazz.cast(apiSecretKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrendmicroConnectorProfileCredentials, T> g) {
        return obj -> g.apply((TrendmicroConnectorProfileCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrendmicroConnectorProfileCredentials> {
        /**
         * <p>
         * The Secret Access Key portion of the credentials.
         * </p>
         * 
         * @param apiSecretKey
         *        The Secret Access Key portion of the credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiSecretKey(String apiSecretKey);
    }

    static final class BuilderImpl implements Builder {
        private String apiSecretKey;

        private BuilderImpl() {
        }

        private BuilderImpl(TrendmicroConnectorProfileCredentials model) {
            apiSecretKey(model.apiSecretKey);
        }

        public final String getApiSecretKey() {
            return apiSecretKey;
        }

        @Override
        public final Builder apiSecretKey(String apiSecretKey) {
            this.apiSecretKey = apiSecretKey;
            return this;
        }

        public final void setApiSecretKey(String apiSecretKey) {
            this.apiSecretKey = apiSecretKey;
        }

        @Override
        public TrendmicroConnectorProfileCredentials build() {
            return new TrendmicroConnectorProfileCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
