/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The trigger settings that determine how and when Amazon AppFlow runs the specified flow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TriggerConfig implements SdkPojo, Serializable, ToCopyableBuilder<TriggerConfig.Builder, TriggerConfig> {
    private static final SdkField<String> TRIGGER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("triggerType").getter(getter(TriggerConfig::triggerTypeAsString)).setter(setter(Builder::triggerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerType").build()).build();

    private static final SdkField<TriggerProperties> TRIGGER_PROPERTIES_FIELD = SdkField
            .<TriggerProperties> builder(MarshallingType.SDK_POJO).memberName("triggerProperties")
            .getter(getter(TriggerConfig::triggerProperties)).setter(setter(Builder::triggerProperties))
            .constructor(TriggerProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerProperties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIGGER_TYPE_FIELD,
            TRIGGER_PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String triggerType;

    private final TriggerProperties triggerProperties;

    private TriggerConfig(BuilderImpl builder) {
        this.triggerType = builder.triggerType;
        this.triggerProperties = builder.triggerProperties;
    }

    /**
     * <p>
     * Specifies the type of flow trigger. This can be <code>OnDemand</code>, <code>Scheduled</code>, or
     * <code>Event</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #triggerType} will
     * return {@link TriggerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #triggerTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of flow trigger. This can be <code>OnDemand</code>, <code>Scheduled</code>, or
     *         <code>Event</code>.
     * @see TriggerType
     */
    public final TriggerType triggerType() {
        return TriggerType.fromValue(triggerType);
    }

    /**
     * <p>
     * Specifies the type of flow trigger. This can be <code>OnDemand</code>, <code>Scheduled</code>, or
     * <code>Event</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #triggerType} will
     * return {@link TriggerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #triggerTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of flow trigger. This can be <code>OnDemand</code>, <code>Scheduled</code>, or
     *         <code>Event</code>.
     * @see TriggerType
     */
    public final String triggerTypeAsString() {
        return triggerType;
    }

    /**
     * <p>
     * Specifies the configuration details of a schedule-triggered flow as defined by the user. Currently, these
     * settings only apply to the <code>Scheduled</code> trigger type.
     * </p>
     * 
     * @return Specifies the configuration details of a schedule-triggered flow as defined by the user. Currently, these
     *         settings only apply to the <code>Scheduled</code> trigger type.
     */
    public final TriggerProperties triggerProperties() {
        return triggerProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(triggerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(triggerProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TriggerConfig)) {
            return false;
        }
        TriggerConfig other = (TriggerConfig) obj;
        return Objects.equals(triggerTypeAsString(), other.triggerTypeAsString())
                && Objects.equals(triggerProperties(), other.triggerProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TriggerConfig").add("TriggerType", triggerTypeAsString())
                .add("TriggerProperties", triggerProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "triggerType":
            return Optional.ofNullable(clazz.cast(triggerTypeAsString()));
        case "triggerProperties":
            return Optional.ofNullable(clazz.cast(triggerProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TriggerConfig, T> g) {
        return obj -> g.apply((TriggerConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TriggerConfig> {
        /**
         * <p>
         * Specifies the type of flow trigger. This can be <code>OnDemand</code>, <code>Scheduled</code>, or
         * <code>Event</code>.
         * </p>
         * 
         * @param triggerType
         *        Specifies the type of flow trigger. This can be <code>OnDemand</code>, <code>Scheduled</code>, or
         *        <code>Event</code>.
         * @see TriggerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerType
         */
        Builder triggerType(String triggerType);

        /**
         * <p>
         * Specifies the type of flow trigger. This can be <code>OnDemand</code>, <code>Scheduled</code>, or
         * <code>Event</code>.
         * </p>
         * 
         * @param triggerType
         *        Specifies the type of flow trigger. This can be <code>OnDemand</code>, <code>Scheduled</code>, or
         *        <code>Event</code>.
         * @see TriggerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerType
         */
        Builder triggerType(TriggerType triggerType);

        /**
         * <p>
         * Specifies the configuration details of a schedule-triggered flow as defined by the user. Currently, these
         * settings only apply to the <code>Scheduled</code> trigger type.
         * </p>
         * 
         * @param triggerProperties
         *        Specifies the configuration details of a schedule-triggered flow as defined by the user. Currently,
         *        these settings only apply to the <code>Scheduled</code> trigger type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerProperties(TriggerProperties triggerProperties);

        /**
         * <p>
         * Specifies the configuration details of a schedule-triggered flow as defined by the user. Currently, these
         * settings only apply to the <code>Scheduled</code> trigger type.
         * </p>
         * This is a convenience that creates an instance of the {@link TriggerProperties.Builder} avoiding the need to
         * create one manually via {@link TriggerProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link TriggerProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #triggerProperties(TriggerProperties)}.
         * 
         * @param triggerProperties
         *        a consumer that will call methods on {@link TriggerProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggerProperties(TriggerProperties)
         */
        default Builder triggerProperties(Consumer<TriggerProperties.Builder> triggerProperties) {
            return triggerProperties(TriggerProperties.builder().applyMutation(triggerProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String triggerType;

        private TriggerProperties triggerProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(TriggerConfig model) {
            triggerType(model.triggerType);
            triggerProperties(model.triggerProperties);
        }

        public final String getTriggerType() {
            return triggerType;
        }

        @Override
        public final Builder triggerType(String triggerType) {
            this.triggerType = triggerType;
            return this;
        }

        @Override
        public final Builder triggerType(TriggerType triggerType) {
            this.triggerType(triggerType == null ? null : triggerType.toString());
            return this;
        }

        public final void setTriggerType(String triggerType) {
            this.triggerType = triggerType;
        }

        public final TriggerProperties.Builder getTriggerProperties() {
            return triggerProperties != null ? triggerProperties.toBuilder() : null;
        }

        @Override
        public final Builder triggerProperties(TriggerProperties triggerProperties) {
            this.triggerProperties = triggerProperties;
            return this;
        }

        public final void setTriggerProperties(TriggerProperties.BuilderImpl triggerProperties) {
            this.triggerProperties = triggerProperties != null ? triggerProperties.build() : null;
        }

        @Override
        public TriggerConfig build() {
            return new TriggerConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
